<?php
/** 
 * Template Name: Site Map
 *
 * @package luzuk Premium
 */
get_header(); 
?>
<?php $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));?>

<header class="page-main-header"  > 
    <div class="container">  
        <div class="h_titlebx"> 
            <?php the_title( '<h1 class="ht-main-title ">', '</h1>' ); ?>
            <?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'show') : ?>
            <div class="bdcrmbox ">
                <div class="breadcrumbbox ">
                    <div class='button'>
                      <?php luzuk_lite_the_breadcrumb(); ?> </div>
                    <div class="clearfix"></div>
                </div>
            </div>
            <?php endif ?>
         
        </div>
        <div class="clearfix"></div>
    </div>
</header>
<?php
    // width 
    $c_width = get_theme_mod('innpg_c_width', 'container');

    if ($c_width === 'container') {
        $c_alignment = 'container';
    } elseif ($c_width === 'container-fluid') {
        $c_alignment = 'container-fluid';
    } else {
        $text_alignment = 'container'; // Default to 'container' if the setting is invalid
    }
        
?>
<main id="innerpage-box">
	<div class="<?php echo esc_attr($c_width); ?>">
        <div class="inner_contentbox">
    		<div id="sitemap-box" class="ht-sitemap innerpage-whitebox">
                <div class="row mr-0">
                    <div class="col-lg-3 col-md-6 col-sm-6 wow bounceInUp">
                         <h4>All Pages</h4>  
                         <ul><?php wp_list_pages("title_li=" ); ?></ul> 
                         <div class="clearfix"></div>
                    </div> 
                    <div class="col-lg-3 col-md-6 col-sm-6 sitemap-archives wow bounceInUp">
                        <h4>Archives</h4>  
                        <ul>  
                            <?php wp_get_archives('type=monthly&show_post_count=true'); ?>  
                        </ul>  
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6 sitemap-blogposts wow bounceInUp">
                        <h4>All Blog Posts</h4>  
                        <ul><?php $archive_query = new WP_Query('showposts=1000&cat=-8');  
                        while ($archive_query->have_posts()) : $archive_query->the_post(); ?>  
                            <div class="sitemap-posts-box row">
                              <div class="col-md-3 col-sm-3 col-xs-3 pl-0">
                                <a href="<?php the_permalink() ?>" ><?php the_post_thumbnail(array(60,60)); ?></a></div>   
                                <div class="col-md-9 col-sm-9 col-xs-9 blogpostsitemap pl-0">
                                    <li> 
                                        <a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a>  
                                        (<?php comments_number('0', '1', '%'); ?>)  
                                    </li>  
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        <?php endwhile; ?>  
                        </ul>  
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6 sitemap-archives wow bounceInUp">
                       <h4>Categories</h4>  
                        <ul>
                            <?php echo wp_list_categories(); ?>
                            <!-- <li></?php echo get_the_category_list(', '); ?></li> -->

                        </ul> 
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>

            <div class="clearfix"></div>
        </div>
    </div>
</main>
<?php get_template_part('template-parts/section','newsletter'); ?>
<?php get_footer(); ?>