<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.6.0
 */

get_header(); ?>
<div class="clearfix"></div>

<?php $thumb = wp_get_attachment_image_src( get_post_thumbnail_id( wc_get_page_id( 'shop' ) ), 'full' );?>
<header class="page-main-header"  >
    <div class="container">   
    	<div class="h_titlebx">
    		<h1 class="page-title ht-main-title "><?php woocommerce_page_title(); ?></h1>
	        <?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'show') : ?>
	        <div class="bdcrmbox ">
	            <div class="breadcrumbbox ">
	                <div class='button'>
	                  <?php luzuk_lite_the_breadcrumb(); ?> </div>
	                <div class="clearfix"></div>
	            </div>
	        </div>
        	<?php endif ?>
        </div> 
        <div class="clearfix"></div>
    </div>
</header>
<?php
    // width 
    $c_width = get_theme_mod('innpg_c_width', 'container');

    if ($c_width === 'container') {
        $c_alignment = 'container';
    } elseif ($c_width === 'container-fluid') {
        $c_alignment = 'container-fluid';
    } else {
        $text_alignment = 'container'; // Default to 'container' if the setting is invalid
    }
        
?>
<div class="single-productpage">
	<main id="innerpage-box">
		<?php
			//if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
			//get_header('shop'); ?>
			<div id="page" class="<?php echo esc_attr($c_width); ?>" >
				<div class="inner_contentbox" >
				<article id="content" class="article">
					
					<div class="row mr-0">
					<div class="col-lg-8 col-md-7">	
											
							<?php if ( have_posts() ) : ?>						
								<?php do_action( 'woocommerce_before_shop_loop' ); ?>
								<?php woocommerce_product_loop_start(); ?>
								<?php woocommerce_product_subcategories(); ?>
								<?php while ( have_posts() ) : the_post(); ?>
									<?php wc_get_template_part( 'content', 'product' ); ?>
								<?php endwhile; // end of the loop. ?>
								<?php woocommerce_product_loop_end(); ?>
								<?php do_action( 'woocommerce_after_shop_loop' ); ?>
								<?php elseif ( ! woocommerce_product_subcategories( array( 'before' => woocommerce_product_loop_start( false ), 'after' => woocommerce_product_loop_end( false ) ) ) ) : ?>
								<?php //woocommerce_get_template( 'loop/no-products-found.php' ); ?>
							<?php endif; ?>				
					</div>
					<div class="col-lg-4 col-md-5 product-page">
						<?php if( get_theme_mod('cd_button_display','show' ) == 'show') :
					  		?>
					  		<div class='button'><?php get_sidebar( 'shop'); ?></div>
					  	<?php endif ?>
					</div>
					<div class="clearfix"></div>
				</div>
				</article>
				<?php /*do_action('woocommerce_sidebar');*/ ?>
				<?php //get_sidebar(); ?>	
				<div class="clearfix"></div>
			</div>
				<div class="clearfix"></div>
			</div>	
	</main><!-- #main -->
</div>
<div class="clearfix"></div>
<?php get_template_part('template-parts/section','newsletter'); ?>
<?php get_footer(); ?>
