<?php   
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package luzuk Premium
 */
?>
<?php 
	if( get_theme_mod('sec_footerseTmargin',true) ) {
		$sec_footerseTmargin = 'padding-top:'.esc_attr(get_theme_mod('sec_footerseTmargin')).';';
	}
	if( get_theme_mod('sec_footersebottommargin',true) ) {
		$sec_footersebottommargin = 'padding-bottom:'.esc_attr(get_theme_mod('sec_footersebottommargin')).';';
	}
	if( get_theme_mod('sec_footersecopacity',true) ) {
		$sec_footersecopacity = 'opacity:'.esc_attr(get_theme_mod('sec_footersecopacity')).';';
	}

?>		

<footer class="footer-area" id="footer" style="<?php echo esc_attr($sec_footerseTmargin); ?>" "<?php echo esc_attr($sec_footersebottommargin); ?>" "<?php echo esc_attr($sec_footersecopacity); ?>">
	<!-- <div class="f-blur"></div> -->
	<div class="f-oly"></div>
	<?php if(is_active_sidebar('luzuk-footer1') || is_active_sidebar('luzuk-footer2') || is_active_sidebar('luzuk-footer3') || is_active_sidebar('luzuk-footer4') ){ ?>	
	<?php
		$newsletter_title = get_theme_mod('newsletter_title', 'Subscribe To Our Newsletter');	
		$luzuk_newsletter_shortcode = get_theme_mod('luzuk_newsletter_shortcode', '[Add Form shortcode]');
	?>
	<div class="container">
		<?php if($newsletter_title ){ ?>
		<div class="box-form">
			<div class="row mr-0">
				<div class="col-lg-6 col-md-6">
					<div class="newstitle">
					    <?php if($newsletter_title ){ ?>
						 <h3><?php echo ($newsletter_title); ?> 
							 <div class="f-img">
								<?php 
									$fe_image = get_theme_mod('fe_image');
									if(!empty($fe_image)){
										echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($fe_image).'" class="img-responsive secondry-bg-img" />';
									}else{
										echo '<img src="'.get_template_directory_uri().'/images/newsletter.png" class="img-responsive" />';
									}
								?>						
							</div>
						</h3> 
			            <?php }?>
					</div>
				</div>
				<div class="col-lg-6 col-md-6">
					<div class="subscribe_shortcode ">			
						<div class="ht-newsletter-member-wrap">										
							<?php echo do_shortcode($luzuk_newsletter_shortcode);?>
						</div>
					</div>
					
				</div>
			</div>
		</div>
		<?php }?>
	</div>
	<div class="fbox"> 
		<div class="newletter"></div>
		<div class="container">
			<div class="row mr-0">
				<div class="s-footer col-lg-3 col-md-6 col-sm-6 col-xs-12 single-footer-1 ">
					<div class="single-footer wow zoomIn" data-wow-duration="1s" >
							<?php if(is_active_sidebar('luzuk-footer1')): 
								dynamic_sidebar('luzuk-footer1');
							endif;
							?>	
					</div>
				</div>

				<div class="s-footer col-lg-3 col-md-6 col-sm-6 col-xs-12 single-footer-2 ">
					<div class="single-footer wow zoomIn" data-wow-duration="1.5s" >
						<?php if(is_active_sidebar('luzuk-footer2')): 
							dynamic_sidebar('luzuk-footer2');
						endif;
						?>	
					</div>
				</div>

				<div class="s-footer col-lg-3 col-md-6 col-sm-6 col-xs-12 single-footer-3">
					<div class="single-footer wow zoomIn"  data-wow-duration="2s" >
						<?php if(is_active_sidebar('luzuk-footer3')): 
							dynamic_sidebar('luzuk-footer3');
						endif;
						?>	
					</div>
				</div>

				<div class="s-footer col-lg-3 col-md-6 col-sm-6 col-xs-12 single-footer-4" >
					<div class="single-footer wow zoomIn" data-wow-duration="2.5s" >
						<?php if(is_active_sidebar('luzuk-footer4')): 
							dynamic_sidebar('luzuk-footer4');
						endif;
						?>	
					</div>
				</div>
				<!-- <div class="s-footer col-lg-1 col-md-2 col-sm-4 col-xs-12 single-footer-5" >
					<div class="single-footer" >
						</?php if(is_active_sidebar('luzuk-footer5')): 
							dynamic_sidebar('luzuk-footer5');
						endif;
						?>	
					</div>
				</div> -->
			</div>
		</div>
	</div>
			
	<?php } ?>

	<?php
		$footercopyright = get_theme_mod('footer_area_copyrighttext', '© 2024 WordPress Theme All Rights Reserved');
	?>

	<?php 

		if( get_theme_mod('sec_bottomareaTmargin',true) ) {
			$sec_bottomareaTmargin = 'padding-top:'.esc_attr(get_theme_mod('sec_bottomareaTmargin')).';';
		}
		if( get_theme_mod('sec_bottomareabottommargin',true) ) {
			$sec_bottomareabottommargin = 'padding-bottom:'.esc_attr(get_theme_mod('sec_bottomareabottommargin')).';';
		}	

	?>		
	<div class="bottom-area" style="<?php echo esc_attr($sec_bottomareaTmargin); ?>" "<?php echo esc_attr($sec_bottomareabottommargin); ?>">
		<div class="container">
			<div class="col-md-12 col-sm-12 col-xs-12 pd-0">
				<div class="footer-text">
					<?php if($footercopyright){ ?>
							<?php echo $footercopyright;?>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
	<div class="clearfix"></div>
</footer>

<script type="text/javascript">
	if(jQuery(window).width() >= 1170){
		new WOW().init();
	}
</script>
<!-- woocommerce Gallery -->
<script type="text/javascript">
    jQuery(document).ready(function(){
        setTimeout(function(){
            jQuery(".flex-control-nav").wrapInner("<div class='owl-carousel'></div>");
            jQuery('.flex-control-nav li').addClass('item');

            $('.flex-control-nav .owl-carousel').owlCarousel({
                refreshClass: 'owl-refresh',
                autoplayTimeout: 5000,
                loop: true,
                margin: 10,
                autoplay: false,
                navText: [
                    '<i class="fa fa-long-arrow-left" aria-hidden="true"></i>',
                    '<i class="fa fa-long-arrow-right" aria-hidden="true"></i>'
                ],
                responsive: {
                    0: {
                        items: 1,
                        nav: true
                    },
                    320: {
                        items: 2,
                        nav: true
                    },
                    1000: {
                        items: 3,
                        nav: true,
                        loop: true
                    }
                }
            });
        }, 1000);
    });
</script>
<!-- end -->
<script>
	$(window).scroll(function() {
		var height = $(window).scrollTop();
		if (height > 100) {
			$('#back2Top').fadeIn();
		} else {
			$('#back2Top').fadeOut();
		}
	});
	$(document).ready(function() {
		$("#back2Top").click(function(event) {
			event.preventDefault();
			$("html, body").animate({ scrollTop: 0 }, "slow");
			return false;
		});

	});
</script> 

<?php wp_footer(); ?>

	<!-- <a id="back2Top" title="Back to top" href="#"> &#10148; </a> -->

<a id="back2Top" title="Back to top" href="#">

	<svg xmlns="http://www.w3.org/2000/svg" class="bi bi-vector-pen" viewBox="0 0 16 16">
	  <path fill-rule="evenodd" d="M10.646.646a.5.5 0 0 1 .708 0l4 4a.5.5 0 0 1 0 .708l-1.902 1.902-.829 3.313a1.5 1.5 0 0 1-1.024 1.073L1.254 14.746 4.358 4.4A1.5 1.5 0 0 1 5.43 3.377l3.313-.828zm-1.8 2.908-3.173.793a.5.5 0 0 0-.358.342l-2.57 8.565 8.567-2.57a.5.5 0 0 0 .34-.357l.794-3.174-3.6-3.6z"/>
	  <path fill-rule="evenodd" d="M2.832 13.228 8 9a1 1 0 1 0-1-1l-4.228 5.168-.026.086z"/>
	</svg>
</a>

</body>
</html>
