<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package luzuk Premium
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" />
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
	<script src="https://code.jquery.com/jquery-3.1.1.min.js" integrity="sha384-3ceskX3iaEnIogmQchP8opvBy3Mi7Ce34nWjpBIwVTHfGYWQS9jwHDVRnpKKHJg7" crossorigin="anonymous"></script>

	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>

	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/swiper.min.js" type="text/javascript"  ></script>
	<script type="text/javascript" src="https://code.jquery.com/jquery-1.12.0.min.js"></script>

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<!-- <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'luzuk' ); ?></a> -->
		<div id="loading-area"><div class="la-anim-10"></div></div>
		<!-- header -->
		<!-- #masthead -->
		<header class="site-header header-transparent header header-seo">
			<div class="top-bar-head">
				<div class="container-fluid pd-0 clearfix">
					<div class="row mr-0">
						<!-- <div class="header-left col-lg-3 col-md-10 col-sm-10 col-10 logo">	 -->
						<div class="header-left logo">	
							<div class="logobx ">
							<?php 
							
								if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
									$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
								}

								?>
								<!-- website logo -->
								<div class="logo-header mostion">
									<?php 
									if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
										the_custom_logo();
								else : 
									if ( is_front_page() ) : ?>
										<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php else : ?>
											<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php endif; ?>
									<?php endif; ?>
								</div> 
								<?php if( get_theme_mod('head_tagline_display','show' ) == 'show') :?>	
								<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p> 
								<?php endif ?>  

								<!-- nav toggle button -->
								<div class="resp_header_logo">
									<?php 
									if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
										the_custom_logo();
								else : 
									if ( is_front_page() ) : ?>
										<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php else : ?>
											<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php endif; ?>
										<!-- <p class="ht-site-description"><a href="</?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"></?php //bloginfo( 'description' ); ?></a></p> -->
									<?php endif; ?>
								</div>
							</div>
						</div>
						<!-- <div class="col-lg-9 col-md-2 col-sm-2 col-2 pd-0"> -->
					<div class="mbox pd-0">
				<?php				
					$Hemiltxt = get_theme_mod('Hemiltxt', 'info@yourmail.com');
					$Hphtxt = get_theme_mod('Hphtxt', '+101 234 6789');					
					
				?>
						<?php if($Hemiltxt || $Hphtxt){ ?>
							<div class="Rtp_head">
								<?php if($Hemiltxt ){ ?>
								<li>
									<a href="mailto:<?php echo $Hemiltxt;?>">
									<i class="fa fa-envelope"></i><span class="tooltiptext"><?php echo $Hemiltxt;?></span></a>	
								</li>
								<?php }?>
								<?php if($Hphtxt ){ ?>
								<li>
									<a href="tel:<?php echo $Hphtxt;?>">
									<i class="fa fa-phone"></i> <span class="tooltiptext"><?php echo ($Hphtxt);  ?></span></a>
								</li>
								<?php }?>
								<div class="clearfix"></div>
							</div>
						<?php }?>
							<div class=" pri-menubx">
								<div class=" head-menubx">
									<div class="row mr-0">
									 <div class="col-xxl-9 col-lg-9 col-md-12 col-sm-12 col-xs-12 col-12 head-menu ">
											<div class="site-navigation ">
						                        <div class="nav-menus">                 
													<a class="js-nav-toggle">
															<span></span>
													</a>
												    <div class="nav-wrapper">
														<nav role="navigation">
															<div class="nav-toggle">
																	<span class="nav-back"></span>
																	<span class="nav-title">Menu</span>
																	<span class="nav-close"></span>
															</div>
															<?php
						                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
						                                            wp_nav_menu ( array(
						                                                'menu_class' => 'mainm ht-clearfix',
						                                                'container'=> 'ul',
						                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
						                                                'theme_location' => 'primary',  
						                                            )); 
						                                        } else {
						                                            wp_nav_menu ( array(
						                                                'menu_class' => 'mainm ht-clearfix',
						                                                'container'=> 'ul',
						                                                'theme_location' => 'primary',  
						                                            )); 
						                                        }
						                                    ?>
														</nav>
													</div>
												</div>
						                        <nav class="navigation">
						                            <div class="overlaybg"></div><!--  /.overlaybg -->
						                            <!-- Main Menu -->
						                            <div class="menu-wrapper">
						                                <div class="menu-content">
						                                    <?php
						                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
						                                            wp_nav_menu ( array(
						                                                'menu_class' => 'mainmenu ht-clearfix',
						                                                'container'=> 'ul',
						                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
						                                                'theme_location' => 'primary',  
						                                            )); 
						                                        } else {
						                                            wp_nav_menu ( array(
						                                                'menu_class' => 'mainmenu ht-clearfix',
						                                                'container'=> 'ul',
						                                                'theme_location' => 'primary',  
						                                            )); 
						                                        }
						                                    ?>
						                                </div> <!-- /.hours-content-->
													<div class="clearfix"></div>

						                        </div><!-- /.menu-wrapper --> 
						                    <?php if( get_theme_mod('cds_button_display','show' ) == 'show') :?>
						                    <div class="mobnone">  
						                        <div class="Hbtn btn1">
							                        <?php
							                           $headerinquirytitle = get_theme_mod('headerinquirytitle', 'Contact Us');
							                           
							                           $headerinquiry = get_theme_mod('luzuk_header_headerinquiry', '#');
							                        ?>
							                            
							                                		
							                        <?php if(!empty($headerinquirytitle)){ ?> 
					                                <div class="Head_cbtn btn2">
						                                <a href="<?php echo $headerinquiry ?>">
						                                	<span class="circle1"></span>
						                                    <span class="circle2"></span>
						                                    <span class="circle3"></span>
						                                    <span class="circle4"></span>
						                                    <span class="circle5"></span>
						                                	<span class="text5">
						                                		<?php echo ($headerinquirytitle);  ?>
						                                	</span>	
						                                </a>
						                            </div>  
						                            <?php }?>
							                                	
							                            
							                    </div>
						                    </div>
						                    <?php endif ?>

						                        </nav>
						                        <div class="clearfix"></div>
						                    </div><!--  /.site-navigation -->
										</div>
							            <div class="col-xxl-3 col-xl-2 col-lg-3 col-md-3 col-sm-2 pd-0">
							                <?php if( get_theme_mod('cds_button_display','show' ) == 'show') :?>
							                <div class="mobnone1">  
							                    <div class="Hbtn btn1">
							                        <?php
							                           $headerinquirytitle = get_theme_mod('headerinquirytitle', 'Contact Us');
							                           
							                           $headerinquiry = get_theme_mod('luzuk_header_headerinquiry', '#');
							                         ?>

						                           <?php if(!empty($headerinquirytitle)){ ?> 
					                                <div class="Head_cbtn btn2">
						                                <a href="<?php echo $headerinquiry ?>">
						                                	<span class="circle1"></span>
						                                    <span class="circle2"></span>
						                                    <span class="circle3"></span>
						                                    <span class="circle4"></span>
						                                    <span class="circle5"></span>
						                                	<span class="text5">
						                                		<?php echo ($headerinquirytitle);  ?>
						                                	</span>		
						                                </a>
						                            </div>  
						                            <?php }?>           
							                </div>
							                <?php endif ?>
										</div> 		  
										<div class="clearfix"></div>
									</div>
								</div>
							</div>
						</div>
						<div class="clearfix"></div>
					</div>
				</div>
				<div class="clearfix"></div>
			</div>			
			<div class="clearfix"></div>
		</header>
	</div>
