<?php 
    $wp_customize->add_section(
        'about_area',
        array(
            'title' => __( 'About Us Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'about_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'about_area_disable',
            array(
                'settings'      => 'about_area_disable',
                'section'       => 'about_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'aboutus', 'about_area', $color='#fff', get_template_directory_uri().'/images/abt_map.png', 'color');


lzCustomLable($wp_customize, 'aboutarea_padding', 'about_area', 'Section Padding');

$wp_customize->add_setting(
    'about_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaTpadding',
    array(
        'settings'      => 'about_areaTpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'about_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaBpadding',
    array(
        'settings'      => 'about_areaBpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'about_image_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_image_heading',
        array(
            'settings'      => 'about_image_heading',
            'section'       => 'about_area',
            'label'         => __( 'Left Side', 'luzuk-premium' ),
        )
    )
);

lzCustomLable($wp_customize, 'aboutarea_1stimg', 'about_area', '1st Image');

$wp_customize->add_setting(
    'about_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_image',
        array(
            'section' => 'about_area',
            'settings' => 'about_image',
            'description' => __('Recommended Image Size: 509X395px', 'luzuk-premium')
        )
    )
);


lzCustomLable($wp_customize, 'aboutarea_2ndimg', 'about_area', '2nd Image');

$wp_customize->add_setting(
    'about_img2',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_img2',
        array(
            'section' => 'about_area',
            'settings' => 'about_img2',
            'description' => __('Recommended Image Size: 517X400px', 'luzuk-premium')
        )
    )
);

lzCustomLable($wp_customize, 'aboutarea_rhs', 'about_area', 'Right Side');


lzCustomLable($wp_customize, 'aboutarea_3rdimg', 'about_area', '3rd Image');

$wp_customize->add_setting(
    'about_rhsimage',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_rhsimage',
        array(
            'section' => 'about_area',
            'settings' => 'about_rhsimage',
            'description' => __('Recommended Image Size: 517X400px', 'luzuk-premium')
        )
    )
);


$wp_customize->add_setting(
    'about_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_title_heading',
        array(
            'settings'      => 'about_title_heading',
            'section'       => 'about_area',
            'label'         => __( ' Section Heading', 'luzuk-premium' ),
        )
    )
);    

$wp_customize->add_setting(
    'aboutsubtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'ABOUT US', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'aboutsubtitle',
    array(
        'settings'      => 'aboutsubtitle',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_secsbuheading', 'about_area', 'Section Heading Color ', '#fff');

addColorPalatOption($wp_customize, 'about_secheadingbrd', 'about_area', 'Section Heading Border Color ', '#fff');

addColorPalatOption($wp_customize, 'about_secheadingbg', 'about_area', 'Section Heading BG Color ', '#0A1843');

$wp_customize->add_setting(
    'about_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Your Journey to Fluent English Begins Here!', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_title',
    array(
        'settings'      => 'about_title',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Section Title', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_sectitleclr', 'about_area', 'Title Color ', '#0A1843');

$wp_customize->add_setting(
    'about_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Duis non convallis nisl. Nunc ultrices fermentum feugiat. Proin a purus auctor, ornare nisi et, fermentum nunc. Nam eu semper purus, sit amet venenatis massa. Sed lacus orci.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_text',
    array(
        'settings'      => 'about_text',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( 'Section Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_text', 'about_area', 'Text Color', '#707070');

$wp_customize->add_setting(
    'about_list',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '<li>Expert Instructors</li><li>Modern Teaching Tools</li><li>Interactive Learning Sessions</li><li>Practical Skill Development</li><li>Practical Skill Development</li><li>Vocabulary Building</li><li>Feedback and Assessment</li><li>Cultural Integration</li>', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_list',
    array(
        'settings'      => 'about_list',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( 'Section List Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_listdt1', 'about_area', 'List Icon Color', '#1E9A6F');

addColorPalatOption($wp_customize, 'about_area_listtext', 'about_area', 'List Text Color', '#000');

lzCustomLable($wp_customize, 'Sec_abtbtn', 'about_area' , 'Section Button');


$wp_customize->add_setting(
    'abtbtntext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Learn More', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'abtbtntext',
    array(
        'settings'      => 'abtbtntext',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

$wp_customize->add_setting('abtbtnbtnlink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('abtbtnbtnlink',
    array(
        'settings'      => 'abtbtnbtnlink',
        'section'       => 'about_area',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_btntxt', 'about_area', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'about_area_btntxthv', 'about_area', 'Button Text Hover Color', '#1E9A6F');

addColorPalatOption($wp_customize, 'about_area_btnbg1', 'about_area', 'Button BG Color', '#1E9A6F');

addColorPalatOption($wp_customize, 'about_area_btnbghv', 'about_area', 'Button BG Hover Color', '#0A1843');


