<?php
// START CONTACT SECTION 
$wp_customize->add_section(
    'appoi_section',
    array(
        'title'         => __( 'Appointment Section', 'Luzuk Premium' ), 
        'panel'   => 'luzuk_premium_home_panel',
    )
);
    //ENABLE/DISABLE CONTACT SECTION
$wp_customize->add_setting(
    'appoi_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'appoi_disable',
        array(
            'settings'      => 'appoi_disable',
            'section'       => 'appoi_section',
            'label'         => __( 'Disable Section', 'Luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk Premium' ),
                'off' => __( 'No', 'Luzuk Premium' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'appointment', 'appoi_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'appoi_sectionnpadding', 'appoi_section', 'Section Padding ');

$wp_customize->add_setting(
    'appoinmentsection_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'appoinmentsection_toppadding',
    array(
        'settings'      => 'appoinmentsection_toppadding',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Top ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'appoinmentsection_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'appoinmentsection_bottompadding',
    array(
        'settings'      => 'appoinmentsection_bottompadding',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Bottom ', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'app_detailbg', 'appoi_section', 'Detail Box');

$wp_customize->add_setting(
    'dbxtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Get In Touch' )
    )
);
$wp_customize->add_control(
    'dbxtitle',
    array(
        'settings'      => 'dbxtitle',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Box Title ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'app_secdbxtitleclr', 'appoi_section', 'Box Title Color', '#0A1843');

$wp_customize->add_setting(
    'infphtxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+098 234 6576' )
    )
);
$wp_customize->add_control(
    'infphtxt',
    array(
        'settings'      => 'infphtxt',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Phone Number 1', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'infphtxt2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+009 287 4328' )
    )
);
$wp_customize->add_control(
    'infphtxt2',
    array(
        'settings'      => 'infphtxt2',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Phone Number 2', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'infemiltxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'info@mail.com' )
    )
);
$wp_customize->add_control(
    'infemiltxt',
    array(
        'settings'      => 'infemiltxt',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Email Id 1', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'infemiltxt2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2info@mail.com' )
    )
);
$wp_customize->add_control(
    'infemiltxt2',
    array(
        'settings'      => 'infemiltxt2',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Email Id 2', 'Luzuk' )
    )
);


$wp_customize->add_setting(
    'inftxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '420 Old Decatur Rd Saginaw Texas 76179 United States' )
    )
);
$wp_customize->add_control(
    'inftxt',
    array(
        'settings'      => 'inftxt',
        'section'       => 'appoi_section',
        'type'          => 'textarea',
        'label'         => __( 'Address Text', 'Luzuk' )
    )
);


lzCustomLable($wp_customize, 'app_dlhsbcclr', 'appoi_section', 'Detail Box Color');

addColorPalatOption($wp_customize, 'inquiry_icnbxbgclr', 'appoi_section', 'Icon Box BG Color', '#1E9A6F');

addColorPalatOption($wp_customize, 'inquiry_icnbgclr', 'appoi_section', 'Icon BG Color', '#33B88A');

addColorPalatOption($wp_customize, 'inquiry_icnclr', 'appoi_section', 'Icon Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_phEmAddclr', 'appoi_section', 'Ph No , Email , Adress Text Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_phEmAddhvclr', 'appoi_section', 'Ph No , Email Text Hover Color', '#0A1843');


// ===========Form Section ==========//

lzCustomLable($wp_customize, 'contactf', 'appoi_section', 'Form Section');

$wp_customize->add_setting(
    'appform_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Contact Us', 'luzuk' )
    )
);
$wp_customize->add_control(
    'appform_maintitle',
    array(
        'settings'      => 'appform_maintitle',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Form Title', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'app_secheadingclr', 'appoi_section', 'Form Title Color', '#0A1843');

$wp_customize->add_setting(
    'appform_ph',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Call Now :+008 345 6754', 'luzuk' )
    )
);
$wp_customize->add_control(
    'appform_ph',
    array(
        'settings'      => 'appform_ph',
        'section'       => 'appoi_section',
        'type'          => 'text',
        'label'         => __( 'Form Phone', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'app_secfmphclr', 'appoi_section', 'Form Phone Color', '#fff');

addColorPalatOption($wp_customize, 'app_secfmphhvclr', 'appoi_section', 'Form Phone Hover Color', '#1E9A6F');

addColorPalatOption($wp_customize, 'app_secfmphBGclr', 'appoi_section', 'Form Phone BG Color', '#0A1843');

addColorPalatOption($wp_customize, 'app_secfmphcorBGclr', 'appoi_section', 'Form Phone Corner BG Color 1', '#1E9A6F');

addColorPalatOption($wp_customize, 'app_secfmphcorBG2clr', 'appoi_section', 'Form Phone Corner BG Color 2', '#1c7254');


lzCustomLable($wp_customize, 'appointmentright_Form_label', 'appoi_section', 'Contact Inquiry Form Shortcode');

lzAddElement($wp_customize, 'luzuk_inquiry_shortcode', 'appoi_section', 'textarea', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');

addColorPalatOption($wp_customize, 'inquiry_formbxtbrdClr', 'appoi_section', 'Form Box Border Color', '#0A1843');

addColorPalatOption($wp_customize, 'inquiry_formbxbgClr', 'appoi_section', 'Form Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_forminputtxtClr', 'appoi_section', 'Form Input Text / Placeholder Color', '#B6B7BB');

addColorPalatOption($wp_customize, 'inquiry_forminputtxbgtClr', 'appoi_section', 'Form Input Placeholder Bg Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_forminputbgClr', 'appoi_section', 'Form Input Border Color', '#0A1843');

addColorPalatOption($wp_customize, 'inquiry_formlabelColor', 'appoi_section', 'Form Label Color', '#000');

addColorPalatOption($wp_customize, 'inquiry_formbuttontextColor', 'appoi_section', 'Form Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'inquiry_formbuttontexthoverColor', 'appoi_section', 'Form Button Text Hover Color', '#000');

addColorPalatOption($wp_customize, 'inquiry_formbtnbgClr', 'appoi_section', 'Form Button BG Color', '#1E9A6F');
