<?php 

$wp_customize->add_section(
    'banner_area',
    array(
        'title'         => __( 'Banner Section', 'luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
$wp_customize->add_setting(
    'banner_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'banner_area_disable',
        array(
            'settings'      => 'banner_area_disable',
            'section'       => 'banner_area',
            'label'         => __( 'Disable Section', 'luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk' ),
                'off' => __( 'No', 'luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'banner', 'banner_area', $color='#fff', get_template_directory_uri().'/images/bannerbg.jpg', 'color');


lzCustomLable($wp_customize, 'luzuk_slideropcity', 'banner_area', 'Section Overlay');

$wp_customize->add_setting(
    'banner_Opacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.3', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'banner_Opacity',
    array(
        'settings'      => 'banner_Opacity',
        'section'       => 'banner_area',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'banner_olyClr', 'banner_area', 'Overlay Color', '#000');

lzCustomLable($wp_customize, 'luzuk_sec_coursessectionpadding', 'banner_area', 'Section Padding');

$wp_customize->add_setting(
    'banner_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'banner_areaTpadding',
    array(
        'settings'      => 'banner_areaTpadding',
        'section'       => 'banner_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'banner_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'banner_areaBpadding',
    array(
        'settings'      => 'banner_areaBpadding',
        'section'       => 'banner_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);



$wp_customize->add_setting(
    'banner_maintitle_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'banner_maintitle_subtitle_heading',
        array(
            'settings'      => 'banner_maintitle_subtitle_heading',
            'section'       => 'banner_area',
            'label'         => __( 'Section Heading', 'luzuk' ),
        )
    )
);


$wp_customize->add_setting(
    'banner_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Discover <span>Software.</span> Unleash Potential', 'luzuk' )
    )
);
$wp_customize->add_control(
    'banner_maintitle',
    array(
        'settings'      => 'banner_maintitle',
        'section'       => 'banner_area', 
        'type'          => 'textarea',
        'label'         => __( 'Section Heading', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'banner_heading_clr', 'banner_area', 'Section Heading Color ', '#fff');

addColorPalatOption($wp_customize, 'banner_headinghigh_clr', 'banner_area', 'Section Heading Highlight Color ', '#2E8BE9');

$wp_customize->add_setting(
    'bannersubtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which do not look even slightly believable.', 'luzuk' )
    )
);
$wp_customize->add_control(
    'bannersubtitle',
    array(
        'settings'      => 'bannersubtitle',
        'section'       => 'banner_area', 
        'type'          => 'textarea',
        'label'         => __( 'Section Sub Heading', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'banner_subheading_clr', 'banner_area', 'Section Text Color ', '#cccccd');


lzCustomLable($wp_customize, 'luzuk_sec_bannerbtn', 'banner_area', 'Section Button');

$wp_customize->add_setting(
    'bannerbtntext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Read More', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'bannerbtntext',
    array(
        'settings'      => 'bannerbtntext',
        'section'       => 'banner_area',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

$wp_customize->add_setting('bannerbtnlink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('bannerbtnlink',
    array(
        'settings'      => 'bannerbtnlink',
        'section'       => 'banner_area',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'banner_btntxt', 'banner_area', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'banner_btntxthv', 'banner_area', 'Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'banner_btnbrd', 'banner_area', 'Button Border Color', '#2E8BE9');

addColorPalatOption($wp_customize, 'banner_btnbg1', 'banner_area', 'Button BG Color 1', '#033A9E');

addColorPalatOption($wp_customize, 'banner_btnbg2', 'banner_area', 'Button BG Color 2', '#2E8BE9');