<?php
/**
 * Createing a bog pannel for customizer
 *
 *
 */
$categories = get_categories(array('hide_empty' => 0));
foreach ($categories as $category) {
	$cat[$category->term_id] = $category->cat_name;
}
/****************************/
// START BLOG SECTION FOR HOME PAGE
/*============BLOG PANEL============*/
$wp_customize->add_section(
	'blog_area',
	array(
		'title' => __( 'Blog Section', 'luzuk-premium' ),
		'panel' => 'luzuk_premium_home_panel',
     	//'priority' => '50',
	)
);
//ENABLE/DISABLE BLOG SECTION
$wp_customize->add_setting(
	'blog_section_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'blog_section_disable',
		array(
			'settings'      => 'blog_section_disable',
			'section'       => 'blog_area',
			'label'         => __( 'Disable Section', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk-premium' ),
				'off' => __( 'No', 'luzuk-premium' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'blog', 'blog_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'blog_area_blogsectionpadding', 'blog_area', 'Section Padding');

$wp_customize->add_setting(
    'blog_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_areaTpadding',
    array(
        'settings'      => 'blog_areaTpadding',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Top ', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'blog_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_areaBpadding',
    array(
        'settings'      => 'blog_areaBpadding',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
	'blog_title_subtitle_heading',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text'
	)
);
$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'blog_title_subtitle_heading',
		array(
			'settings'		=> 'blog_title_subtitle_heading',
			'section'       => 'blog_area',
			'label'         => __( 'Section Heading ', 'luzuk-premium' ),
		)
	)
);


$wp_customize->add_setting(
	'blog_heading',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Unveiling Stories in Our Blog Haven', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'blog_heading',
	array(
		'settings'      => 'blog_heading',
		'section'       => 'blog_area',
		'type'          => 'text',
		'label'         => __( 'Section Heading', 'luzuk-premium' )
	)
);

addColorPalatOption($wp_customize, 'blogarea_headingclr', 'blog_area', 'Section Heading Color', '#0A1843');


lzCustomLable($wp_customize, 'blog_area_blogspost', 'blog_area', 'Number Of Post ');
//BLOG SETTINGS
$wp_customize->add_setting(
	'blog_post_count',
	array(
		'default'           => '3',
		'sanitize_callback' => 'luzuk_sanitize_choices'
	)
);
$wp_customize->add_control(
	new luzuk_Dropdown_Chooser(
		$wp_customize,
		'blog_post_count',
		array(
			'settings'      => 'blog_post_count',
			'section'       => 'blog_area',
			'label'         => __( 'Number Of Post To Show', 'luzuk-premium' ),
			'choices'       => $luzuk_post_count_choice
		)
	)
);


// CREATING A BLOG SECTION IN CUSTOMIZER FOR BLOG PAGES
$wp_customize->add_section(
	'premium_blog_area',
	array(
		'title' => __( 'Blog Page Settings', 'luzuk-premium' ),
        // 'panel' => 'luzuk_premium_home_panel'
		'priority' =>19
	)
);

$wp_customize->add_setting('blog_categories_settings', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control('blog_categories_settings', array(
    'settings' => 'blog_categories_settings',
    'label'    => __('Posts on Blog Page', 'luzuk-premium'),
    'section'  => 'lpremium_blog_area',
    'type'     => 'radio',
    'choices'  => array(
        '0' => __('Excerpts','luzuk-premium'),
        '1' => __('Full Posts','luzuk-premium'),
    ),
));
// ADDING THE CATEGORY TO SELECT
$wp_customize->add_setting('luzuk_blog_categories', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Checkbox_Multiple(
		$wp_customize,
		'luzuk_blog_categories',
		array(
			'label' => __('Exclude Category From Blog Posts', 'luzuk-premium'),
			'section' => 'premium_blog_area',
			'settings' => 'luzuk_blog_categories',
			'choices' => $luzuk_cat
		)
	)
);

lzCustomLable($wp_customize, 'blog_area_color', 'blog_area', 'Section Color');

addColorPalatOption($wp_customize, 'blogarea_icnclr', 'blog_area', 'Icon Color', '#fff');

addColorPalatOption($wp_customize, 'blogarea_icnhvclr', 'blog_area', 'Icon Hover Color', '#fff');

addColorPalatOption($wp_customize, 'blogarea_icnbgclr', 'blog_area', 'Icon BG Color', '#1E9A6F');

addColorPalatOption($wp_customize, 'blogarea_icnbghvclr', 'blog_area', 'Icon BG Hover Color', '#0A1843');

addColorPalatOption($wp_customize, 'blogarea_icnbrdclr', 'blog_area', 'Icon Border Color', '#fff');

addColorPalatOption($wp_customize, 'blogarea_bxdateclr', 'blog_area', 'Date & Comment Color', '#fff');

addColorPalatOption($wp_customize, 'blogarea_bxdateBGclr', 'blog_area', 'Date & Comment BG Color', '#0A1843');

addColorPalatOption($wp_customize, 'blogarea_box_color', 'blog_area', 'Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'blogarea_bxbrdclr', 'blog_area', 'Box Border Color', '#989797');

addColorPalatOption($wp_customize, 'blogarea_Title_color', 'blog_area', 'Title Color', '#0A1843');

addColorPalatOption($wp_customize, 'blogarea_Titlehover_color', 'blog_area', 'Title Hover Color', '#1E9A6F');

addColorPalatOption($wp_customize, 'blogarea_text_color', 'blog_area', 'Text Color', '#707070');

lzCustomLable($wp_customize, 'blogarea_sbtnclr', 'blog_area', 'Section Button');

$wp_customize->add_setting(
    'blog_button1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Read More', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_button1',
    array(
        'settings'      => 'blog_button1',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'blogarea_btnarowclr', 'blog_area', 'Button Text Color ', '#fff');

addColorPalatOption($wp_customize, 'blogarea_btnarowhvclr', 'blog_area', 'Button Text Hover Color ', '#1E9A6F');

addColorPalatOption($wp_customize, 'blogarea_btnarowbgclr', 'blog_area', 'Button BG Color ', '#1E9A6F');

addColorPalatOption($wp_customize, 'blogarea_btnarowbghvclr', 'blog_area', 'Button BG Hover Color ', '#0A1843');