<?php 
    $wp_customize->add_section(
        'facility_area',
        array(
            'title' => __( 'Facility Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );

    $wp_customize->add_setting(
        'facility_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'facility_area_disable',
            array(
                'settings'      => 'facility_area_disable',
                'section'       => 'facility_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'facilityus', 'facility_area', $color='#0A1843', get_template_directory_uri().'/images/facilitybg.png', 'color');

lzCustomLable($wp_customize, 'facilityarea_padding', 'facility_area', 'Section Padding');

$wp_customize->add_setting(
    'facility_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'facility_areaTpadding',
    array(
        'settings'      => 'facility_areaTpadding',
        'section'       => 'facility_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'facility_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'facility_areaBpadding',
    array(
        'settings'      => 'facility_areaBpadding',
        'section'       => 'facility_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'facility_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'facility_title_heading',
        array(
            'settings'      => 'facility_title_heading',
            'section'       => 'facility_area',
            'label'         => __( 'Section Heading ', 'luzuk-premium' ),
        )
    )
);    


$wp_customize->add_setting(
    'facility_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'BENEFITS OF ENGLISH SPEAKING CLASSES ', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'facility_heading',
    array(
        'settings'      => 'facility_heading',
        'section'       => 'facility_area',
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'facility_Heading_clr', 'facility_area', 'Section Heading Color ', '#fff');

lzCustomLable($wp_customize, 'main_spinAnimation', 'facility_area', 'Spin Circle Animation');

$wp_customize->add_setting( 'fac_animation_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'fac_animation_display', array( 'label' => 'Spin Animation Display', 'section' => 'facility_area', 'settings' => 'fac_animation_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show', 'hide' => 'Hide', ), ) ); 


$wp_customize->add_setting('facilityus_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'facilityus_npp_heading',
        array(
            'settings'      => 'facilityus_npp_heading',
            'section'       => 'facility_area',
            'label'         => __( 'Number Of Facility Box', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('facilityus_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'facilityus_npp_count',
    array(
        'settings'      => 'facilityus_npp_count',
        'section'       => 'facility_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Facility Box To Show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8)
    )
);

//facility PAGES
for( $i = 1; $i <= 8; $i++ ){
    $wp_customize->add_setting(
        'facilityus_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'facilityus_header'.$i,
            array(
                'settings'      => 'facilityus_header'.$i,
                'section'       => 'facility_area',
                'label'         => __( 'Section Box ', 'luzuk-premium' ).$i
            )
        )
    );

     $wp_customize->add_setting(
        'facilityus_page_icon'.$i,
        array(
            'default'           => 'fa fa-globe',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'facilityus_page_icon'.$i,
            array(
                'settings'      => 'facilityus_page_icon'.$i,
                'section'       => 'facility_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );


lzAddElement($wp_customize, 'facilityus_page_title'.$i, 'facility_area', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Networking Opportunities');

lzAddElement($wp_customize, 'luzuk_facility_page_url_'.$i, 'facility_area', $type = 'text', $label="Link", $callback ='esc_url', $default='Add link here');

lzAddElement($wp_customize, 'facility_txt'.$i, 'facility_area', $type = 'textarea', $label="Text", $callback ='luzuk_sanitize_text', $default='Aenean ut neque id tellus moles congue. Morbi accumsan urna tempus bibendum tempor.');

}


lzCustomLable($wp_customize, 'fac-clr', 'facility_area' , 'Section Color');

addColorPalatOption($wp_customize, 'facility_bxclr', 'facility_area', 'Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'facility_bxhvclr', 'facility_area', 'Box BG Hover Color', '#5B6DA5');

addColorPalatOption($wp_customize, 'facility_area_title', 'facility_area', 'Title Color', '#0A1843');

addColorPalatOption($wp_customize, 'facility_areatitlebg', 'facility_area', 'Title BG Color', '#fff');

addColorPalatOption($wp_customize, 'facility_areatitlebrd', 'facility_area', 'Title Border Color', '#1E9A6F');

addColorPalatOption($wp_customize, 'facility_area_icon', 'facility_area', 'Icon Color', '#000');

addColorPalatOption($wp_customize, 'facility_areaiconhv', 'facility_area', 'Icon Hover Color', '#fff');

addColorPalatOption($wp_customize, 'facility_areaiconbg', 'facility_area', 'Icon BG Color', '#1E9A6F');

addColorPalatOption($wp_customize, 'facility_area_txt', 'facility_area', 'Text Color', '#707070');

addColorPalatOption($wp_customize, 'facility_area_txtbrd', 'facility_area', 'Text Hover Color', '#fff');


lzCustomLable($wp_customize, 'fac_btnsettng', 'facility_area', 'Section Button');

$wp_customize->add_setting(
    'facbtn_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'View All', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'facbtn_text',
    array(
        'settings'      => 'facbtn_text',
        'section'       => 'facility_area',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

$wp_customize->add_setting('facbtnlink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('facbtnlink',
    array(
        'settings'      => 'facbtnlink',
        'section'       => 'facility_area',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'facility_btnclr', 'facility_area', 'Button Text Color ', '#fff');

addColorPalatOption($wp_customize, 'facility_btnhvclr', 'facility_area', 'Button Text Hover Color ', '#1E9A6F');

addColorPalatOption($wp_customize, 'facility_btnbrdhv', 'facility_area', 'Button BG Color ', '#1E9A6F');

addColorPalatOption($wp_customize, 'facility_btnbghv', 'facility_area', 'Button BG Hover Color ', '#5B6DA5');

