<?php  

$luzukSliderSingleChoice = getFitnessPostsType('slider');
$wp_customize->add_section(
	'slider_section',
	array(
		'title' => __( 'Slider Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel',
		'priority' =>18
	)
);
$wp_customize->add_setting(
	'slider_section_show_content',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'slider_section_show_content',
		array(
			'settings'      => 'slider_section_show_content',
			'section'       => 'slider_section',
			'label'         => __( 'Hide Title And Description On Slider', 'Luzuk' ),
			'on_off_label'  => array(
				'on' => __( 'No', 'Luzuk' ),
				'off' => __( 'Yes', 'Luzuk' )
			),
		)
	)
);


$wp_customize->add_setting('slider_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Info_Text( 
		$wp_customize,
		'slider_section_lbl',
		array(
			'settings'		=> 'slider_section_lbl',
			'section'		=> 'slider_section',
			'label'			=> __( 'Note:', 'Luzuk' ),	
			'description'	=> __( 'The page featured image works as a banner and the title & content work as a slider caption. You can add this from the Slider menu. <br/> Recommended Image Size: 750X700', 'Luzuk' ),
		)
	)
);


lzCustomLable($wp_customize, 'slider_conbx', 'slider_section', 'Content Box Opacity For Responsive');

$wp_customize->add_setting(
    'slider_conbxOpacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.7', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'slider_conbxOpacity',
    array(
        'settings'      => 'slider_conbxOpacity',
        'section'       => 'slider_section',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);


lzCustomLable($wp_customize, 'luzuk_sliderotherclrs', 'slider_section', 'Slider Color');

addColorPalatOption($wp_customize, 'slider_secbgClr', 'slider_section', 'Section BG Color', '#1E9A6F');

addColorPalatOption($wp_customize, 'slider_conbgClr', 'slider_section', 'Content Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'slider_titleClr', 'slider_section', 'Title Color', '#5B6DA5');

addColorPalatOption($wp_customize, 'slider_textClr', 'slider_section', 'Text Color', '#707070');


addColorPalatOption($wp_customize, 'slider_btntxtClr', 'slider_section', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'slider_btntxthvClr', 'slider_section', 'Button Text Hover Color', '#1E9A6F');

addColorPalatOption($wp_customize, 'slider_btnbg1Clr', 'slider_section', 'Button BG Color', '#1E9A6F');

addColorPalatOption($wp_customize, 'slider_btnbghvClr', 'slider_section', 'Button BG Hover Color', '#0A1843');

lzCustomLable($wp_customize, 'main_sliderAnimation', 'slider_section', 'Slider Emoji Animation');

//BREADCRUMB SETTINGS
// $wp_customize->add_section(
//     'slider_animation_display',
//     array(
//         'title' => __( 'Slider Emoji Animation Settings', 'luzuk Premium' ),
//         'panel' => 'luzuk_general_panel',
//     )
// );

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'slider_emoj_animation_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'slider_emoj_animation_display', array( 'label' => 'Emoji Animation Display', 'section' => 'slider_section', 'settings' => 'slider_emoj_animation_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show', 'hide' => 'Hide', ), ) ); 

addColorPalatOption($wp_customize, 'sli_1emjbgclr', 'slider_section', '1st Emoji Bg Color', '#57bea9');

addColorPalatOption($wp_customize, 'sli_2emjbgclr', 'slider_section', '2nd Emoji Bg Color', '#5B6DA5');


lzCustomLable($wp_customize, 'luzuk_sliderbutnclrs', 'slider_section', 'Slider Arrow Button Color');

addColorPalatOption($wp_customize, 'sli_arowclr', 'slider_section', 'Left Arrow Color', '#fff');

addColorPalatOption($wp_customize, 'sli_arowbrdclr', 'slider_section', 'Left Arrow BG Color', '#0A1843');

addColorPalatOption($wp_customize, 'sli_Rarowclr', 'slider_section', 'Right Arrow Color', '#0A1843');

addColorPalatOption($wp_customize, 'sli_Rarowbgclr', 'slider_section', 'Right Arrow BG Color', '#fff');

addColorPalatOption($wp_customize, 'sli_arowhvclr', 'slider_section', 'Arrow Hover Color', '#1E9A6F');