<?php   
$wp_customize->add_section(
	'team_area',
	array(
		'title'         => __( 'Team Section', 'luzuk-premium' ),
		'panel'   => 'luzuk_premium_home_panel',
	)
);
$wp_customize->add_setting(
	'team_area_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'team_area_disable',
		array(
			'settings'      => 'team_area_disable',
			'section'       => 'team_area',
			'label'         => __( 'Disable Section', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk-premium' ),
				'off' => __( 'No', 'luzuk-premium' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'team', 'team_area', $color='#fff', get_template_directory_uri().'/images/teambg.png', 'color');

lzCustomLable($wp_customize, 'team_area_teamsectionpadding', 'team_area', 'Section Padding');

$wp_customize->add_setting(
    'team_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'team_areaTpadding',
    array(
        'settings'      => 'team_areaTpadding',
        'section'       => 'team_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'team_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'team_areaBpadding',
    array(
        'settings'      => 'team_areaBpadding',
        'section'       => 'team_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
	'luzuk_team_title_subtitle_heading',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
	)
);
$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'luzuk_team_title_subtitle_heading',
		array(
			'settings'      => 'luzuk_team_title_subtitle_heading',
			'section'       => 'team_area',
			'label'         => __( 'Section Heading', 'luzuk-premium' ),
		)
	)
);

$wp_customize->add_setting(
	'team_title_title',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Guiding Your Journey to English Fluency with Passion and Precision', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'team_title_title',
	array(
		'settings'      => 'team_title_title',
		'section'       => 'team_area',
		'type'          => 'textarea',
		'label'         => __( 'Section Heading', 'luzuk-premium' )
	)
);

addColorPalatOption($wp_customize, 'TMsec_secheadig_clr', 'team_area', 'Section Heading Color', '#000');

/*for note text*/
$wp_customize->add_setting('team_area_lbl1', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'team_area_lbl1',
        array(
            'settings'      => 'team_area_lbl1',
            'section'       => 'team_area',
            'label'         => __( 'Note :', 'luzuk' ),    
            'description'   => __( 'Just place the shortcode "[TEAMLIST]" in your page to Show all teams in a page & Set Team Member Images Of Equal Height.{310*372 ', 'luzuk' ),
        )
    )
);

/*for note text*/

$wp_customize->add_setting('team_area_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'team_area_npp_heading',
		array(
			'settings'      => 'team_area_npp_heading',
			'section'       => 'team_area',
			'label'         => __( 'Number Of Team Members', 'luzuk-premium' ),
		)
	)
);    
$wp_customize->add_setting('team_area_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
	'team_area_npp_count',
	array(
		'settings'      => 'team_area_npp_count',
		'section'       => 'team_area',
		'type'          => 'select',
		'label'         => __( 'Number Of Team Members', 'luzuk-premium' ),
		'choices'=>array(1,2,3,4,5,6,7,8)
	)
);

// TEAM PAGES
$TeamsSingleChoice[] = 'select';
for( $i = 1; $i <= 8; $i++ ){
	$wp_customize->add_setting(
		'team_area_heading'.$i,
		array(
			'sanitize_callback' => 'luzuk_sanitize_text'
		)
	);
	$wp_customize->add_control(
		new luzuk_Customize_Heading(
			$wp_customize,
			'team_area_heading'.$i,
			array(
				'settings'      => 'team_area_heading'.$i,
				'section'       => 'team_area',
				'label'         => __( 'Team ', 'luzuk-premium' ).$i,
			)
		)
	);
	if(is_array($TeamsSingleChoice)){
		$wp_customize->add_setting(
			'team_area_page'.$i,
			array(
				'sanitize_callback' => 'absint'
			)
		);
		$wp_customize->add_control(
			'team_area_page'.$i,
			array(
				'settings'      => 'team_area_page'.$i,
				'section'       => 'team_area',
				'type'=> 'select',
				'label'         => __( 'Select A Team Member', 'luzuk-premium' ),
				'choices' => $TeamsSingleChoice,
			)
		);

	}
	else{
		$wp_customize->add_setting('team_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
		$wp_customize->add_control(
			new luzuk_Info_Text( 
				$wp_customize,
				'team_area_lbl'.$i,
				array(
					'settings'		=> 'team_area_lbl'.$i,
					'section'		=> 'team_area',
					'label'			=> __( 'Note:', 'luzuk-premium' ),	
					'description'	=> __( '<strong>Changes will not reflect unless you select the Teams.</strong> <br/>Please add the teams from "Teams menu" and then select Team Member to show information.', 'luzuk-premium' ),
				)
			)
		);
	}
}

lzCustomLable($wp_customize, 'team_area_teamsecclr', 'team_area', 'Section Color');

addColorPalatOption($wp_customize, 'TMsec_mnbxbgclr', 'team_area', 'Main Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'TMsec_mnbxbrdclr', 'team_area', 'Main Box Border Color', '#0A1843');

addColorPalatOption($wp_customize, 'TMsec_dbxbgclr', 'team_area', 'Content Box BG Color', '#1E9A6F');

addColorPalatOption($wp_customize, 'TMsec_dbxbghvclr', 'team_area', 'Content Box BG Highlight Color', '#0A1843');

addColorPalatOption($wp_customize, 'TMsec_NameClr', 'team_area', 'Member Name Color', '#fff');

addColorPalatOption($wp_customize, 'TMsec_TeamDegnClr', 'team_area', 'Designation Color', '#fff');

addColorPalatOption($wp_customize, 'TMsec_socialicnClr', 'team_area', 'Icon Color', '#fff');

addColorPalatOption($wp_customize, 'TMsec_socialicnClrhv', 'team_area', 'Icon Hover Color', '#1E9A6F');

addColorPalatOption($wp_customize, 'TMsec_socialicnbgClr', 'team_area', 'Icon BG Color', '#0A1843');
