<?php  
// TESTIMONIALS SECTION START HERE 

$wp_customize->add_section(
    'testimonials_area',
    array(
        'title'         => __( 'Testimonial Section', 'luzuk Premium' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);

    //ENABLE/DISABLE TESTIMONIALS SECTION
$wp_customize->add_setting(
    'testimonials_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'testimonials_area_disable',
        array(
            'settings'      => 'testimonials_area_disable',
            'section'       => 'testimonials_area',
            'label'         => __( 'Disable Section', 'luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk Premium' ),
                'off' => __( 'No', 'luzuk Premium' )
            )   
        ) 
    )
);
 
backgroundManager($wp_customize, 'testimonials', 'testimonials_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'luzuk_sec_testsectionpadding', 'testimonials_area', 'Section Padding');

$wp_customize->add_setting(
    'testimonials_areaTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaTpadding',
    array(
        'settings'      => 'testimonials_areaTpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk Premium' )
    )
);
$wp_customize->add_setting(
    'testimonials_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaBpadding',
    array(
        'settings'      => 'testimonials_areaBpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk Premium' )
    )
);

$wp_customize->add_setting(
    'testi_title_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'testi_title_subtitle_heading',
        array(
            'settings'      => 'testi_title_subtitle_heading',
            'section'       => 'testimonials_area',
            'label'         => __( 'Section Heading & Sub Heading ', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'testi_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Testimonials from Satisfied Learners', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'testi_maintitle',
    array(
        'settings'      => 'testi_maintitle',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'testi_headingclr', 'testimonials_area', 'Section Heading Color', '#0A1843');


$wp_customize->add_setting(
    'testisubtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Aliquam vitae venenatis turpis. Sed erat erat, placerat in nisi eu, fringilla egestas leo. Phasellus venenatis, eros ut scelerisque rhoncus, dui sem scelerisque magna, a faucibus mauris ante vel nibh.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'testisubtitle',
    array(
        'settings'      => 'testisubtitle',
        'section'       => 'testimonials_area',
        'type'          => 'textarea',
        'label'         => __( 'Section Sub Heading Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'testi_subheadingclr', 'testimonials_area', 'Section Sub Heading Text Color', '#707070');



$TesimonialsSingleChoice[] = 'select';
if(!is_array($TesimonialsSingleChoice)){
    $wp_customize->add_setting('testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
    $wp_customize->add_control(
        new luzuk_Info_Text( 
            $wp_customize,
            'testimonials_area_lbl',
            array(
                'settings'      => 'testimonials_area_lbl',
                'section'       => 'testimonials_area',
                'label'         => __( 'Note:', 'luzuk Premium' ), 
                'description'   => __( '<strong>Changes will not reflect unless you select the Testimonials.</strong> <br/>Please add the Testimonials from "Testimonials menu" and then select Testimonial to show information.', 'luzuk Premium' ),
            )
        )
    );
}
$wp_customize->add_setting('luzuk_premium_testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_testimonials_area_lbl',
        array(
            'settings'      => 'luzuk_premium_testimonials_area_lbl',
            'section'       => 'testimonials_area',
            'label'         => __( 'Note:', 'luzuk Premium' ), 
            'description'   => __( 'Just place the shortcode "[TESTIMONIALS]" in your page to list the Testimonials in a page ', 'luzuk Premium' ),
        )
    )
);
//TESTIMONIALS PAGES
for( $i = 1; $i < 10; $i++ ){
    $wp_customize->add_setting(
        'luzuk_testimonials_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_testimonials_heading'.$i,
            array(
                'settings'      => 'luzuk_testimonials_heading'.$i,
                'section'       => 'testimonials_area',
                'label'         => __( 'Testimonial ', 'luzuk Premium' ).$i,
            )
        )
    );
    $wp_customize->add_setting(
        'testimonials_page'.$i,
        array(
            'sanitize_callback' => 'absint'
        )
    );
    $wp_customize->add_control(
        'testimonials_page'.$i,
        array(
            'settings'      => 'testimonials_page'.$i,
            'section'       => 'testimonials_area',
            'type'=> 'select',
            'label'         => __( 'Select A Client Testimonial', 'luzuk Premium' ),
            'choices' => $TesimonialsSingleChoice,
        )
    );
}


lzCustomLable($wp_customize, 'clientcolor', 'testimonials_area', 'Section Color');

addColorPalatOption($wp_customize, 'luzuk_testimonialscontent_bxbgclr', 'testimonials_area', 'Box BG Color', '#1E9A6F');

addColorPalatOption($wp_customize, 'luzuk_testimonialscontent_bxbrdclr', 'testimonials_area', 'Box Border Color', '#005638');

addColorPalatOption($wp_customize, 'luzuk_testimonialscontent_textcolor', 'testimonials_area', 'Text Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_testimonials_Namecolor', 'testimonials_area', 'Client Name Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_testimonials_deginclr', 'testimonials_area', 'Client Designation Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_testbxicnclr', 'testimonials_area', 'Box Icon Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_testslidedotbrdclr', 'testimonials_area', 'Slider Dot Border Color', '#0A1843');

addColorPalatOption($wp_customize, 'luzuk_testimonials_slidearrowclr', 'testimonials_area', 'Slider Dot Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_testimonials_slidearrowhvclr', 'testimonials_area', 'Slider Active Dot Color', '#0A1843');

addColorPalatOption($wp_customize, 'luzuk_testi_sliddotnumclr', 'testimonials_area', 'Slider Dot Number Color', '#0A1843');

addColorPalatOption($wp_customize, 'luzuk_testi_slidactdotnumclr', 'testimonials_area', 'Slider Active Dot Number Color', '#fff');