<?php 
/**
 * The template for displaying archive pages.
 *
 * Used for displaying archive-type pages. These views can be further customized by
 * creating a separate template for each one.
 *
 * - author.php (Author archive)
 * - category.php (Category archive)
 * - date.php (Date archive)
 * - tag.php (Tag archive)
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 */
?>
<?php get_header(); ?>
<main id="innerpage-box">
	<div class="container">
		<div class="inner_contentbox">
			<div class="row mr-0">
				<div id="blog-box" class="col-lg-8 col-md-7 innerpage-whitebox">
					<div class="innerblogpost">
						<?php if ( have_posts() ) :
							$luzuk_lite_full_posts = get_theme_mod('luzuk_lite_full_posts');
							while ( have_posts() ) : the_post();
								luzuk_lite_archive_post();
							endwhile;
							luzuk_lite_post_navigation();
						endif; ?>
					</div>	
				</div> 
				<div class="col-lg-3 col-md-5 ">
					<div id="secondary" class="widget-area">
						<?php dynamic_sidebar('luzuk-blog-sidebar'); ?>
					</div>
				</div>
			</div>
			<div class="clearfix"></div>
		</div>
		<div class="clearfix"></div>
		<div class="row mr-0">
			<div class="col-md-12">
				<div class="pagingation">
			    	<?php lzGetPagination($query);?>
				</div>
			</div>
		</div>
	</div>
</main>

<script>
      jQuery.noConflict();
      $(function(){
      function innerblogpostHeight(){
        var ht = 0;
        $('.inner-blogpost-info').each(function(i){
          var tHt = $(this).height();
          if(ht<tHt){
            ht=tHt;
          }
        });
        $('.inner-blogpost-info').height(ht+'px');
      }
      innerblogpostHeight();
    });
    $( window ).resize(function(){
      innerblogpostHeight();
    });
</script>

<?php get_footer(); ?>