  <?php
/**
 *  functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * * @package luzuk Premium 
 */
$query='';



// //  header text color ,background color option remove
function remove_customizer_colors( $wp_customize ) {
 
    // Remove controls ONLY (safe)
    $wp_customize->remove_control( 'background_color' );
    $wp_customize->remove_control( 'header_textcolor' );
 
}
add_action( 'customize_register', 'remove_customizer_colors', 100 );

define('FS_METHOD', 'direct');

if ( ! function_exists( 'luzuk_lite_setup' ) ) :
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */
    
    function luzuk_lite_setup() {
    	define( 'MTS_THEME_VERSION', '2.0.6' );
        /*
    	 * Make theme available for translation.
    	 * Translations can be filed in the /languages/ directory.
    	 * If you're building a theme based on publishable, use a find and replace
    	 * to change 'luzuk Premium' to the name of your theme in all the template files.
    	 */
        load_theme_textdomain( 'luzuk Premium', get_template_directory() . '/languages' );

    	// Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

    	/*
    	 * Let WordPress manage the document title.
    	 * By adding theme support, we declare that this theme does not use a
    	 * hard-coded <title> tag in the document head, and expect WordPress to
    	 * provide it for us.
    	 */
    	add_theme_support( 'title-tag' );

    	/*
    	 * Enable support for Post Thumbnails on posts and pages.
    	 *
    	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
    	 */
    	add_theme_support( 'post-thumbnails' );
    	set_post_thumbnail_size( 150, 150, true );
    	add_image_size( 'luzuk Premium-related', 200, 125, true ); //related

    	// This theme uses wp_nav_menu() in one location.
    	register_nav_menus( array(
    		'primary' => esc_html__( 'My Custom Menu', 'luzuk Premium' ),
    	) );

    	/*
    	 * Switch default core markup for search form, comment form, and comments
    	 * to output valid HTML5.
    	 */
    	add_theme_support( 'html5', array(
    		'comment-form',
    		'comment-list',
    		'gallery',
    		'caption',
    	) );

        if ( luzuk_lite_is_wc_active() ) {
            add_theme_support( 'woocommerce' );
        }
        
    	// Set up the WordPress core custom background feature.
        add_theme_support( 'custom-background', apply_filters( 'luzuk_lite_custom_background_args', array(
          'default-color' => '#000',
          'default-image' => '',
      ) ) );
    }
endif;
add_action( 'after_setup_theme', 'luzuk_lite_setup' );

function luzuk_lite_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'luzuk_lite_content_width', 678 );
}
add_action( 'after_setup_theme', 'luzuk_lite_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function luzuk_lite_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'luzuk Premium' ),
		'id'            => 'sidebar',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="widget %2$s  wow bounceInUp">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	) );

	/*// Header Ad sidebar
    register_sidebar(array(
        'name' => __('Header Ad', 'luzuk Premium'),
        'description'   => __( '728x90 Ad Area', 'luzuk Premium' ),
        'id' => 'widget-header',
        'before_widget' => '<div id="%1$s" class="widget-header">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ));*/

    // single post side bar
    register_sidebar( array(
        'name'          => esc_html__( 'Single Post Sidebar', 'Luzuk Premium' ),
        'id'            => 'luzuk-single-post-sidebar',
        'description'   => __( 'Add widgets here to appear in your sidebar of service page.', 'Luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s wow bounceInUp">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );

    
    // Service side bar
    register_sidebar( array(
        'name'          => esc_html__( 'Service Sidebar', 'Luzuk Premium' ),
        'id'            => 'luzuk-service-sidebar',
        'description'   => __( 'Add widgets here to appear in your sidebar of service page.', 'Luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s wow bounceInUp">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );

    // // Project side bar
    // register_sidebar( array(
    //     'name'          => esc_html__( 'Project Sidebar', 'Luzuk Premium' ),
    //     'id'            => 'luzuk-project-sidebar',
    //     'description'   => __( 'Add widgets here to appear in your sidebar of project page.', 'Luzuk Premium' ),
    //     'before_widget' => '<aside id="%1$s" class="widget %2$s wow bounceInUp">',
    //     'after_widget'  => '</aside>',
    //     'before_title'  => '<h4 class="widget-title">',
    //     'after_title'   => '</h4>',
    // ) );

    // // Events side bar
    // register_sidebar( array(
    //     'name'          => esc_html__( 'Events Sidebar', 'Luzuk Premium' ),
    //     'id'            => 'luzuk-events-sidebar',
    //     'description'   => __( 'Add widgets here to appear in your sidebar of events page.', 'Luzuk Premium' ),
    //     'before_widget' => '<aside id="%1$s" class="widget %2$s wow bounceInUp">',
    //     'after_widget'  => '</aside>',
    //     'before_title'  => '<h4 class="widget-title">',
    //     'after_title'   => '</h4>',
    // ) );

    // // Courses side bar
    // register_sidebar( array(
    //     'name'          => esc_html__( 'Courses Sidebar', 'Luzuk Premium' ),
    //     'id'            => 'luzuk-courses-sidebar',
    //     'description'   => __( 'Add widgets here to appear in your sidebar of courses page.', 'Luzuk Premium' ),
    //     'before_widget' => '<aside id="%1$s" class="widget %2$s wow bounceInUp">',
    //     'after_widget'  => '</aside>',
    //     'before_title'  => '<h4 class="widget-title">',
    //     'after_title'   => '</h4>',
    // ) );

    // Shop side bar
    register_sidebar( array(
        'name'          => esc_html__( 'Shop Sidebar', 'luzuk Premium' ),
        'id'            => 'luzuk-shop-sidebar',
        'description'   => __( 'Add widgets here to appear in your sidebar of shop page.', 'luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s wow bounceInUp">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    // Blog side bar
    register_sidebar( array(
        'name'          => esc_html__( 'Blog Sidebar', 'luzuk Premium' ),
        'id'            => 'luzuk-blog-sidebar',
        'description'   => __( 'Add widgets here to appear in your sidebar of blog page.', 'luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s  wow bounceInUp">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    // FOOTER ONE WIDGET SIDEBAR
    register_sidebar( array(
        'name'          => esc_html__( 'Footer One', 'luzuk Premium' ),
        'id'            => 'luzuk-footer1',
        'description'   => __( 'Add widgets here to appear in your Footer.', 'luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    // FOOTER TWO WIDGET SIDEBAR
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Two', 'luzuk Premium' ),
        'id'            => 'luzuk-footer2',
        'description'   => __( 'Add widgets here to appear in your Footer.', 'luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    // FOOTER THREE WIDGET SIDEBAR
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Three', 'luzuk Premium' ),
        'id'            => 'luzuk-footer3',
        'description'   => __( 'Add widgets here to appear in your Footer.', 'luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );

    // if ( luzuk_lite_is_wc_active() ) {
    //     // Register WooCommerce Shop and Single Product Sidebar
    //     register_sidebar( array(
    //         'name' => __('Shop Page Sidebar', 'luzuk Premium' ),
    //         'description'   => __( 'Appears on Shop main page and product archive pages.', 'luzuk Premium' ),
    //         'id' => 'shop-sidebar',
    //         'before_widget' => '<div id="%1$s" class="widget %2$s">',
    //         'after_widget' => '</div>',
    //         'before_title' => '<h4 class="widget-title">',
    //         'after_title' => '</h4>',
    //     ) );
    //     register_sidebar( array(
    //         'name' => __('Single Product Sidebar', 'luzuk Premium' ),
    //         'description'   => __( 'Appears on single product pages.', 'luzuk Premium' ),
    //         'id' => 'product-sidebar',
    //         'before_widget' => '<div id="%1$s" class="widget %2$s">',
    //         'after_widget' => '</div>',
    //         'before_title' => '<h4 class="widget-title">',
    //         'after_title' => '</h4>',
    //     ) );
    // }
}
add_action( 'widgets_init', 'luzuk_lite_widgets_init' );

function luzuk_lite_custom_sidebar() {
    // Default sidebar.
    $sidebar = 'sidebar';

    // Woocommerce.
    if ( luzuk_lite_is_wc_active() ) {
        if ( is_shop() || is_product_category() ) {
            $sidebar = 'shop-sidebar';
        }
        if ( is_product() ) {
            $sidebar = 'product-sidebar';
        }
    }

    return $sidebar;
}

/**
 * Enqueue scripts and styles.
 */
function luzuk_lite_scripts() {
    wp_enqueue_style( 'luzuk Premium-style', get_stylesheet_uri() );

    $handle = 'luzuk Premium-style';

    // WooCommerce
    if ( luzuk_lite_is_wc_active() ) {
        if ( is_woocommerce() || is_cart() || is_checkout() ) {
            wp_enqueue_style( 'woocommerce', get_template_directory_uri() . '/css/woocommerce2.css' );
            $handle = 'woocommerce';
        }
    }
    //wp_enqueue_script( 'flickity-pkgd', get_template_directory_uri() . '/js/flickity.pkgd.min.js', array('jquery'), '20160903', true );

    //wp_enqueue_script( 'jquery-bxslider-min', get_template_directory_uri() . '/js/jquery.bxslider.min.js', array('jquery'), '4.1.2', true );

    wp_enqueue_script( 'jquery-bxslider', get_template_directory_uri() . '/js/jquery.bxslider.js', array('jquery'), '4.1.2', true );
    //wp_enqueue_script( 'smoothscroll', get_template_directory_uri() . '/js/SmoothScroll.js', array(), '20160809', false );
    wp_enqueue_script( 'jquery-nav', get_template_directory_uri() . '/js/jquery.nav.js', array('jquery'), '20160903', true );
    wp_enqueue_script( 'isotope-pkgd', get_template_directory_uri() . '/js/isotope.pkgd.js', array('jquery', 'imagesloaded' ), '20150903', true );
    wp_enqueue_script( 'nivo-lightbox', get_template_directory_uri() . '/js/nivo-lightbox.js', array('jquery'), '20150903', true );
    wp_enqueue_script( 'superfish', get_template_directory_uri() . '/js/superfish.js', array('jquery'), '20150903', true );
    wp_enqueue_script( 'jquery-stellar', get_template_directory_uri() . '/js/jquery.stellar.js', array('imagesloaded'), '20150903', false ); 
    wp_enqueue_script( 'wow', get_template_directory_uri() . '/js/wow.js', array('jquery'), '20150903', true );
    wp_enqueue_script( 'odometer', get_template_directory_uri() . '/js/odometer.js', array('jquery'), '20150903', true );
    wp_enqueue_script( 'waypoint', get_template_directory_uri() . '/js/waypoint.js', array('jquery'), '20150903', true );
    wp_enqueue_script( 'total-custom', get_template_directory_uri() . '/js/total-custom.js', array('jquery'), '20150903', true );
    wp_enqueue_script( 'jquery-min', get_template_directory_uri() . '/js/jquery.min.js', array('jquery'), '20150903', true );
    wp_enqueue_script('slider', get_template_directory_uri().'/js/slider.js', array(), '1.1', true);
    wp_localize_script( 'total-custom', 'total_localize', array('template_path' => get_template_directory_uri() ));
    //wp_enqueue_script('jquery-3-3-1-min', get_template_directory_uri().'/js/jquery-3.3.1.min.js', array(), '1.1', true);
    //  wp_enqueue_script( 'jquery-3-1-1-slim-min', get_template_directory_uri() . '/js/jquery-3.1.1.slim.min.js', array('jquery'), '20150903', true );
    wp_enqueue_style( 'bxslider', get_template_directory_uri() . '/css/jquery.bxslider.css', array(), '4.1.2' );
    wp_enqueue_style( 'style-min', get_template_directory_uri() . '/css/style.min.css', array(), '1.3.3' );
    wp_enqueue_style( 'swiper-min', get_template_directory_uri() . '/css/swiper.min.css', array(), '1.3.3' );

    wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/js/owl.carousel.js', array('jquery'), '1.3.3', true );
    wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/css/owl.carousel.css', array(), '1.3.3' );
    wp_enqueue_style( 'owl-theme', get_template_directory_uri() . '/css/owl.theme.css', array(), '1.3.3' );
    wp_enqueue_style( 'owl-carousel-min', get_template_directory_uri() . '/css/owl.carousel.min.css', array(), '1.3.3' );
    wp_enqueue_style( 'animate-min', get_template_directory_uri() . '/css/animate.min.css', array(), '1.3.3' );
    wp_enqueue_style( 'all-min', get_template_directory_uri() . '/css/all.min.css', array(), '1.3.3' );
    wp_enqueue_style( 'owl-theme-default-min', get_template_directory_uri() . '/css/owl.theme.default.min.css', array(), '1.3.3' );
    wp_enqueue_script( 'jquery-colorbox', get_template_directory_uri() . '/js/jquery.colorbox.js', array(), '20160809', false );
    wp_enqueue_script( 'fancybox.umd', get_template_directory_uri() . '/js/fancybox.umd.js', array('jquery'), '20150903', true );

     wp_enqueue_style( 'fancybox', get_template_directory_uri() . '/css/fancybox.css', array(), '1.3.3' );
    wp_enqueue_style( 'colorbox-popup', get_template_directory_uri() . '/css/colorbox.css', array(), '4.1.2' );
    wp_enqueue_style( 'animate', get_template_directory_uri() . '/css/animate.css', array(), '1.0' );
    wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome.css', array(), '4.4.0' );


    wp_enqueue_style( 'nivo-lightbox', get_template_directory_uri() . '/css/nivo-lightbox.css', array(), '1.3.3' );
    wp_enqueue_style( 'superfish', get_template_directory_uri() . '/css/superfish.css', array(), '1.3.3' );


// extra for header
  
   wp_enqueue_style( 'templete', get_template_directory_uri() . '/css-new/templete.css', array(), '1.3.3' );
   wp_enqueue_script( 'wishlist', get_template_directory_uri() . '/js/wishlist.js', array('jquery'), '20150903', true );

// extra for header

wp_enqueue_script( 'main', get_template_directory_uri() . '/js/main.js', array('jquery'), '20150903', true );
wp_enqueue_script( 'navigation', get_template_directory_uri() . '/js/navigation.js', array('jquery'), '20150903', true );

 wp_enqueue_style( 'style-min', get_template_directory_uri() . '/css/style.min.css', array(), '1.3.3' );

    //google fonts
    wp_enqueue_style( 'google-fonts', 'https://fonts.googleapis.com/css?family=Archivo+Narrow|Arimo|Berkshire+Swash|Bitter|Comfortaa|Dancing+Script|Dosis|Droid+Serif|Francois+One|Germania+One|Hammersmith+One|Indie+Flower|Lobster|Muli|Nosifer|PT+Sans|PT+Sans+Caption|PT+Sans+Narrow|Pacifico|Questrial|Roboto+Mono|Roboto+Slab|Source+Serif+Pro|Titillium+Web|Work+Sans|Rubik:700i' );
    // wp_add_inline_style( 'total-style', total_dymanic_styles() );

    wp_enqueue_script( 'luzuk Premium-customscripts', get_template_directory_uri() . '/js/customscripts.js',array('jquery'),'',true);

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
      wp_enqueue_script( 'comment-reply' );
  }

  $luzuk_lite_color_scheme = get_theme_mod('luzuk_template_color', '#fe5722');
  $luzuk_lite_color_scheme2 = get_theme_mod('luzuk_template_color2', '#44afdd');
  //$header = get_theme_mod('header_textcolor', '#000');
  $luzuk_lite_layout = get_theme_mod('luzuk_lite_layout', 'cslayout');

  $custom_css = total_dymanic_styles();
  wp_add_inline_style( $handle, $custom_css );
}
add_action( 'wp_enqueue_scripts', 'luzuk_lite_scripts' );
/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/style.php';
/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';


/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/lz-customizer.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/lz-customizer-functions.php';
/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';
/**
 * Load Font Awesome list file.
 */
require get_template_directory() . '/inc/font-awesome-list.php';
/**
 * Load function file.
 */
require get_template_directory() . '/inc/functions.php';
/**
 * Add the Social buttons Widget.
 */
include_once( "functions/widget-social.php" );
require_once('functions/meta-data.php'); // ADD THE META DETA FOR THE PHP


require get_template_directory() . '/inc/notifications.php';

require get_template_directory() . '/inc/theme-tracker.php';

/**
 * Add inline styles for remote notification banner.
 */
function luzuk_lite_notification_styles() {
    $css = '
    .luzuk-lite-remote-notification {
        background: #111;
        color: #fff;
        padding: 20px 0;
        text-align: center;
        border-bottom: 4px solid #e74c3c;
    }
    .luzuk-lite-remote-notification__inner {
        max-width: 1100px;
        margin: 0 auto;
        padding: 0 20px;
    }
    .luzuk-lite-dashboard-notification + .luzuk-lite-dashboard-notification {
        margin-top: 20px;
        border-top: 1px solid #e2e4e7;
        padding-top: 20px;
    }';

    wp_add_inline_style( 'luzuk-lite-style', $css );
}
add_action( 'wp_enqueue_scripts', 'luzuk_lite_notification_styles' );

/**
 * Copyrights
 */
if ( ! function_exists( 'luzuk_lite_copyrights_credit' ) ) {
    function luzuk_lite_copyrights_credit() { 
        global $mts_options
        ?>
        <!--start copyrights-->
        <div class="copyrights">
            <div class="container">
                <div id="copyright-note">
                    <span>Copyright <?php echo '&copy; '.date_i18n(__('Y','luzuk')); ?> <?php bloginfo( 'name' ); ?>. All Rights Reserved
                    </span>
            <!--<div class="top">
            
                <a href="#top" class="toplink"><//?php //_e('Back to Top','luzuk Premium'); ?> &uarr;</a>
            </div>-->
                </div>
            </div>
        </div>
<!--end copyrights-->
<?php }
}

/**
 * Custom Comments template
 */
if ( ! function_exists( 'luzuk_lite_comments' ) ) {
	function luzuk_lite_comment($comment, $args, $depth) { ?>
		<li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
			<div id="comment-<?php comment_ID(); ?>" style="position:relative;" itemscope itemtype="http://schema.org/UserComments">
				<div class="comment-author vcard">
					<?php echo get_avatar( $comment->comment_author_email, 70 ); ?>
					<div class="comment-metadata">
                        <?php printf('<span class="fn" itemprop="creator" itemscope itemtype="http://schema.org/Person">%s</span>', get_comment_author_link()) ?>
                        <span class="comment-meta">
                          <?php edit_comment_link(__('(Edit)', 'luzuk Premium'),'  ','') ?>
                      </span>
                  </div>
              </div>
              <?php if ($comment->comment_approved == '0') : ?>
               <em><?php _e('Your comment is awaiting moderation.', 'luzuk Premium') ?></em>
               <br />
           <?php endif; ?>
           <div class="commentmetadata" itemprop="commentText">
               <?php comment_text() ?>
               <time><?php comment_date(get_option( 'date_format' )); ?></time>
               <span class="reply">
                <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
            </span>
        </div>
    </div>
</li>
<?php }
}

/*
 * Excerpt
 */
function luzuk_lite_excerpt($limit) {
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt);
} else {
    $excerpt = implode(" ",$excerpt);
}
$excerpt = preg_replace('`[[^]]*]`','',$excerpt);
return $excerpt;
}

/**
 * Shorthand function to check for more tag in post.
 *
 * @return bool|int
 */
function luzuk_lite_post_has_moretag() {
    return strpos( get_the_content(), '<!--more-->' );
}

if ( ! function_exists( 'luzuk_lite_readmore' ) ) {
    /**
     * Display a "read more" link.
     */
    function luzuk_lite_readmore() {
        ?>
      <!--   <div class="readMore">
            <a href="<?php //echo esc_url( get_the_permalink() ); ?>" title="<?php //the_title_attribute(); ?>" target="_blank">
                <?php //_e( 'Continue Reading', 'luzuk Premium' ); ?>
            </a>
        </div> -->

            <?php if( get_theme_mod('blogpage_button_display','show' ) == 'show') :
                      ?>
                <?php
                    $bloginner_page_id = get_theme_mod('bloginner_page'); 
                 $bloginnerbutn_text = get_theme_mod('blogbutninner_text', 'Continue Reading');
                ?>

                <a href="<?php echo esc_url( get_the_permalink() ); ?>" title="<?php the_title_attribute(); ?>" target="_blank">
                    <?php echo $bloginnerbutn_text; ?>
                        
                </a>

                <?php endif ?>
        <?php 
    }
}

/**
 * Breadcrumbs
 */
if (!function_exists('luzuk_lite_the_breadcrumb')) {
    function luzuk_lite_the_breadcrumb() {
        if ( is_front_page() ) {
            return;
        }
        echo '<span typeof="v:Breadcrumb" class="root"><a rel="v:url" property="v:title" href="';
        echo esc_url( home_url() );
        /* =====breadcrumb text====== */
        $breadcrumbhometxtbutton = get_theme_mod('luzuk_breadcrumbhometxt', 'Home'); 
        /* =====breadcrumb text====== */
        echo '">'.(sprintf( __( "$breadcrumbhometxtbutton", 'luzuk Premium' )));
        echo '</a></span><span class="bread-arrow"> / </span>';
        if (is_single()) {
            $categories = get_the_category();
            if ( $categories ) {
                $level = 0;
                $hierarchy_arr = array();
                foreach ( $categories as $cat ) {
                    $anc = get_ancestors( $cat->term_id, 'category' );
                    $count_anc = count( $anc );
                    if (  0 < $count_anc && $level < $count_anc ) {
                        $level = $count_anc;
                        $hierarchy_arr = array_reverse( $anc );
                        array_push( $hierarchy_arr, $cat->term_id );
                    }
                }
                if ( empty( $hierarchy_arr ) ) {
                    $category = $categories[0];
                    echo '<span typeof="v:Breadcrumb"><a href="'. esc_url( get_category_link( $category->term_id ) ).'" rel="v:url" property="v:title">'.esc_html( $category->name ).'</a></span><span class="bread-arrow">
                    <i class="fa fa-angle-double-right"></i>
                    </span>';
                } else {
                    foreach ( $hierarchy_arr as $cat_id ) {
                        $category = get_term_by( 'id', $cat_id, 'category' );
                        echo '<span typeof="v:Breadcrumb"><a href="'. esc_url( get_category_link( $category->term_id ) ).'" rel="v:url" property="v:title">'.esc_html( $category->name ).'</a></span><span class="bread-arrow"><i class="fa fa-angle-double-right
                        "></i></span>';
                    }
                }
            }
            echo "<span><span class='treeEnd'>";
            the_title();
            echo "</span></span>";
        } elseif (is_page()) {
            $parent_id  = wp_get_post_parent_id( get_the_ID() );
            if ( $parent_id ) {
                $breadcrumbs = array();
                while ( $parent_id ) {
                    $page = get_page( $parent_id );
                    $breadcrumbs[] = '<span typeof="v:Breadcrumb"><a href="'.esc_url( get_permalink( $page->ID ) ).'" rel="v:url" property="v:title">'.esc_html( get_the_title($page->ID) ). '</a></span><span>
                    <i class="fa fa-angle-double-right"></i></span>';
                    $parent_id  = $page->post_parent;
                }
                $breadcrumbs = array_reverse( $breadcrumbs );
                foreach ( $breadcrumbs as $crumb ) { echo $crumb; }
            }
            echo "<span><span class='treeEnd'>";
            the_title();
            echo "</span></span>";
        } elseif (is_category()) {
            global $wp_query;
            $cat_obj = $wp_query->get_queried_object();
            $this_cat_id = $cat_obj->term_id;
            $hierarchy_arr = get_ancestors( $this_cat_id, 'category' );
            if ( $hierarchy_arr ) {
                $hierarchy_arr = array_reverse( $hierarchy_arr );
                foreach ( $hierarchy_arr as $cat_id ) {
                    $category = get_term_by( 'id', $cat_id, 'category' );
                    echo '<span typeof="v:Breadcrumb"><a href="'.esc_url( get_category_link( $category->term_id ) ).'" rel="v:url" property="v:title">'.esc_html( $category->name ).'</a></span><span><i class="fa fa-angle-double-right
                    "></i></span>';
                }
            }
            echo "<span><span class='treeEnd'>";
            single_cat_title();
            echo "</span></span>";
        } elseif (is_author()) {
            echo "<span><span class='treeEnd'>";
            if(get_query_var('author_name')) :
                $curauth = get_user_by('slug', get_query_var('author_name'));
            else :
                $curauth = get_userdata(get_query_var('author'));
            endif;
            echo esc_html( $curauth->nickname );
            echo "</span></span>";
        } elseif (is_search()) {
            echo "<span><span class='treeEnd'>";
            the_search_query();
            echo "</span></span>";
        } elseif (is_tag()) {
            echo "<span><span class='treeEnd'>";
            single_tag_title();
            echo "</span></span>";
        }
    }
}


/*
 * Google Fonts
 */
function luzuk_lite_fonts_url() {
    $fonts_url = '';

    /* Translators: If there are characters in your language that are not
    * supported by Monda, translate this to 'off'. Do not translate
    * into your own language.
    */
    $monda = _x( 'on', 'Monda font: on or off', 'luzuk Premium' );

    if ( 'off' !== $monda ) {
        $font_families = array();

        if ( 'off' !== $monda ) {
            $font_families[] = urldecode('Roboto:400,500,700,900');
        }

        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            //'subset' => urlencode( 'latin,latin-ext' ),
        );

        $fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
    }

    return $fonts_url;
}

function luzuk_lite_scripts_styles() {
    wp_enqueue_style( 'theme-slug-fonts', luzuk_lite_fonts_url(), array(), null );

}
add_action( 'wp_enqueue_scripts', 'luzuk_lite_scripts_styles' );

/**
 * WP Mega Menu Plugin Support
 */
function luzuk_lite_megamenu_parent_element( $selector ) {
    return '.primary-navigation .container';
}
add_filter( 'wpmm_container_selector', 'luzuk_lite_megamenu_parent_element' );

/**
 * Determines whether the WooCommerce plugin is active or not.
 * @return bool
 */
function luzuk_lite_is_wc_active() {
    if ( is_multisite() ) {
        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

        return is_plugin_active( 'woocommerce/woocommerce.php' );
    } else {
        return in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) );
    }
}

/**
 * WooCommerce
 */
if ( luzuk_lite_is_wc_active() ) {
    if ( !function_exists( 'mts_loop_columns' )) {
        /**
         * Change number or products per row to 3
         *
         * @return int
         */
        function mts_loop_columns() {
            return 3; // 3 products per row
        }
    }
    add_filter( 'loop_shop_columns', 'mts_loop_columns' );

    /**
     * Redefine woocommerce_output_related_products()
     */
    function woocommerce_output_related_products() {
        $args = array(
            'posts_per_page' => 3,
            'columns' => 3,
        );
        woocommerce_related_products($args); // Display 3 products in rows of 1
    }
    
    global $pagenow;
    if ( is_admin() && isset( $_GET['activated'] ) && $pagenow == 'themes.php' ) {
        /**
         * Define WooCommerce image sizes.
         */
        function luzuk_lite_woocommerce_image_dimensions() {
            $catalog = array(
                'width'     => '210',   // px
                'height'    => '155',   // px
                'crop'      => 1        // true
            );
            $single = array(
                'width'     => '326',   // px
                'height'    => '444',   // px
                'crop'      => 1        // true
            );
            $thumbnail = array(
                'width'     => '74',    // px
                'height'    => '74',   // px
                'crop'      => 0        // false
            );
            // Image sizes
            update_option( 'shop_catalog_image_size', $catalog );       // Product category thumbs
            update_option( 'shop_single_image_size', $single );         // Single product image
            update_option( 'shop_thumbnail_image_size', $thumbnail );   // Image gallery thumbs
        }
        add_action( 'init', 'luzuk_lite_woocommerce_image_dimensions', 1 );
    }


    /**
     * Change the number of product thumbnails to show per row to 4.
     *
     * @return int
     */
    function luzuk_lite_woocommerce_thumb_cols() {
     return 4; // .last class applied to every 4th thumbnail
 }
 add_filter( 'woocommerce_product_thumbnails_columns', 'luzuk_lite_woocommerce_thumb_cols' );


    /**
     * Ensure cart contents update when products are added to the cart via AJAX.
     *
     * @param $fragments
     *
     * @return mixed
     */
    function luzuk_lite_header_add_to_cart_fragment( $fragments ) {
        global $woocommerce;
        ob_start(); ?>
        
        <a class="cart-contents" href="<?php echo esc_url( $woocommerce->cart->get_cart_url() ); ?>" title="<?php _e( 'View your shopping cart', 'luzuk Premium' ); ?>"><?php echo sprintf( _n( '%d item', '%d items', $woocommerce->cart->cart_contents_count, 'luzuk Premium' ), $woocommerce->cart->cart_contents_count );?> - <?php echo $woocommerce->cart->get_cart_total(); ?></a>
        
        <?php $fragments['a.cart-contents'] = ob_get_clean();
        return $fragments;
    }
    add_filter( 'add_to_cart_fragments', 'luzuk_lite_header_add_to_cart_fragment' );

    /**
     * Optimize WooCommerce Scripts
     * Updated for WooCommerce 2.0+
     * Remove WooCommerce Generator tag, styles, and scripts from non WooCommerce pages.
     */
    function luzuk_lite_manage_woocommerce_styles() {
        //remove generator meta tag
        remove_action( 'wp_head', array( $GLOBALS['woocommerce'], 'generator' ) );

        //first check that woo exists to prevent fatal errors
        if ( function_exists( 'is_woocommerce' ) ) {
            //dequeue scripts and styles
            if ( ! is_woocommerce() && ! is_cart() && ! is_checkout() ) {
                wp_dequeue_style( 'woocommerce-layout' );
                wp_dequeue_style( 'woocommerce-smallscreen' );
                wp_dequeue_style( 'woocommerce-general' );
                wp_dequeue_style( 'wc-bto-styles' ); //Composites Styles
                wp_dequeue_script( 'wc-add-to-cart' );
                wp_dequeue_script( 'wc-cart-fragments' );
                wp_dequeue_script( 'woocommerce' );
                wp_dequeue_script( 'jquery-blockui' );
                wp_dequeue_script( 'jquery-placeholder' );



            }
        }
    }
    add_action( 'wp_enqueue_scripts', 'luzuk_lite_manage_woocommerce_styles', 99 );

    // Remove WooCommerce generator tag.
    remove_action('wp_head', 'wc_generator_tag');
}

/**
 * Post Layout for Archives
 */
if ( ! function_exists( 'luzuk_lite_archive_post' ) ) {
    /**
     * Display a post of specific layout.
     * 
     * @param string $layout
     */
    function luzuk_lite_archive_post( $layout = '' ) { 
        $luzuk_lite_full_posts = get_theme_mod('luzuk_lite_full_posts', '0'); ?>
    <article class="post excerpt inner-post-excerpt">
                <?php
            if ( is_sticky() && is_home() && ! is_paged() ) {
                printf( '<span class="sticky-post">%s</span>', __( 'Featured', 'luzuk Premium' ) );
            } ?>
        <?php if ( is_single() ) : ?>
        <div class="post-date-publishable"><?php the_time( get_option( 'date_format' ) ); ?></div>
        <?php endif; ?>

<!-- category page -->
            <div class="inner-blog-post wow zoomIn row mr-0">
                <div class="inner-blogpost">
                    <?php if ( empty($luzuk_lite_full_posts) ) : ?>
                        <?php if ( has_post_thumbnail() ) { ?>
                        <div class="ht-blog-thumbnail">
                            <a href="<?php the_permalink(); ?>">
                                    <?php the_post_thumbnail('luzuk Premium-featured',array('title' => '')); ?>
                                    <?php if (function_exists('wp_review_show_total')) wp_review_show_total(true, 'latestPost-review-wrapper'); ?>
                                <div class="inner-blog-overlay"></div>
                            </a>
                            <?php if( get_theme_mod('postdate_button_display','show' ) == 'show') :?>
                                <div class="blog-admbx">
                                    <div class="blog-authorimg">
                                        <?php echo get_avatar(get_the_author_meta('ID'), 64); ?>
                                    </div>
                                    <div class="author-deatails">
                                        <div class="blog-author">
                                            <?php echo get_the_author(); ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endif ?>
                        </div>
                    <?php } else { ?>
                    <?php } ?>    
                    <div class="inner-blogpost-info">
                        <a href="<?php the_permalink(); ?>"><h2><?php the_title(); ?></h2></a> 
                        <div class="inner-blog-excerpt">
                            <?php 
                                if (has_excerpt()) {
                                      echo get_the_excerpt();
                                  } else {
                                      echo luzuk_excerpt(get_the_content(),60);  
                               }
                            ?> 
                        </div>
                        <div class="inner-blog-bottom-area">
                            <?php
                              $innerblog_btn = get_theme_mod('innerblog_btn', 'Continue Reading');
                            ?>
                            <?php if($innerblog_btn) { ?>
                                <div class="blogbtn"> 
                                    <a href="<?php echo esc_url(get_permalink()); ?>">
                                        <?php echo $innerblog_btn ?>
                                    </a>
                                </div> 
                            <?php }?>
                            <div class="social-media">
                                <?php if( get_theme_mod('socialicon_button_display','show' ) == 'show') :
                                ?>
                                    <button type="button" class="btn share-icn"><i class="fa fa-share-alt" aria-hidden="true"></i> </button> 
                                    <div class="share-btn">
                                        <li><a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink();?>" target="_blank" class="site-button sharp"><i class="fa fa-facebook" aria-hidden="true"></i></a></li>
                                        <li><a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink();?>&title=<?php the_title();?>&source=<?php the_title();?>" target="_blank" class="site-button sharp"><i class="fa fa-linkedin" aria-hidden="true"></i></a></li>
                                        <li><a href="https://twitter.com/share?url=<?php the_permalink();?>&amp;text=<?php the_title();?>" class="site-button sharp" target="_blank"><i class="fa-brands fa-x-twitter"></i></a></li>
                                        <li><a href="https://www.instagram.com/?url=<?php the_permalink();?>" target="_blank" class="site-button sharp"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>
                                        <div class="clearfix"></div>
                                    </div>
                                <?php endif ?> 
                            </div>
                        </div>             
                    </div>
                     <div class="clearfix"></div>
                    <?php else : ?>
                    <?php if (luzuk_lite_post_has_moretag()) : ?>
                </div>
                <div class="innerblog-page-palette">
                    <div class="blog-splash"></div>
                </div>
            </div> 
<!-- END category page -->
            <?php endif; ?>
        <?php endif; ?>
        <div class="clearfix"></div>
    </article>
       
        <?php }
    }


/**
 * Extras
 */
add_action( 'customize_controls_print_styles', 'luzuk_customizer_stylesheet' );

function luzuk_load_custom_wp_admin_style( $hook ) {
    if ( 'appearance_page_about-luzuk_mag' !== $hook ) {
        return;
    }
    wp_enqueue_style( 'luzuk_mag-custom-admin-css', get_template_directory_uri() . '/css/themeinfo.css', false, '1.0.0' );
}
add_action( 'admin_enqueue_scripts', 'luzuk_load_custom_wp_admin_style' );


// Adding Custome Post Type
function createCustomeTypes() {

    // Testimonials Custome type
    register_post_type( 'our-testimonial',
        array(
            'labels' => array(
                'name' => __( 'Testimonials' , 'luzuk Premium'),
                'singular_name' => __( 'Testimonial', 'luzuk Premium' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-format-chat', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title', 'editor', 'thumbnail', 'page-attributes'),
        )
    );


// team
    register_post_type( 'our-team',
        array(
            'labels' => array(
                'name' => __( 'Teams' , 'luzuk'),
                'singular_name' => __( 'Team', 'luzuk' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-groups', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title', 'thumbnail', 'author', 'page-attributes'),
        )
    );
// Services
    register_post_type( 'our-services',
        array(
            'labels' => array(
                'name' => __( 'Services' , 'luzuk'),
                'singular_name' => __( 'Service', 'luzuk' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-update', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title', 'editor', 'thumbnail', 'author', 'page-attributes'),
        )
    );  
    
// projects 
    // register_post_type( 'our-projects',
    //     array(
    //         'labels' => array(
    //             'name' => __( 'Projects' , 'luzuk'),
    //             'singular_name' => __( 'Project', 'luzuk' )
    //         ),
    //         'public' => true,
    //         'featured_image'=>true,
    //         'has_archive' => true,
    //         'menu_icon' => 'dashicons-layout', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
    //         'supports' => array('title','editor', 'thumbnail',  'page-attributes'),
    //     )
    // );  


// events 
    // register_post_type( 'our-events',
    //     array(
    //         'labels' => array(
    //             'name' => __( 'Events' , 'luzuk'),
    //             'singular_name' => __( 'Events', 'luzuk' )
    //         ),
    //         'public' => true,
    //         'featured_image'=>true,
    //         'has_archive' => true,
    //         'menu_icon' => 'dashicons-palmtree', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
    //         'supports' => array('title','editor', 'thumbnail', 'page-attributes'),
    //     )
    // );  
    
    
// Gallery Custome type
    register_post_type( 'our-gallery',
        array(
            'labels' => array(
                'name' => __( 'Gallery' , 'luzuk'),
                'singular_name' => __( 'gallery', 'luzuk' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-admin-media', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title', 'thumbnail', 'author', 'page-attributes'),
        )
    ); 

// FAQ Custome type
    register_post_type( 'our-faq',
        array(
            'labels' => array(
                'name' => __( 'FAQs' , 'luzuk'),
                'singular_name' => __( 'FAQ', 'luzuk' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-format-status', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title', 'editor', 'page-attributes'),
        )
    );


// SLIDER Custome type
        register_post_type( 'slider',
            array(
                'labels' => array(
                    'name' => __( 'Sliders' , 'Luzuk'),
                    'singular_name' => __( 'Slider', 'Luzuk' )
                ),
                'public' => true,
                'featured_image'=>true,
                'has_archive' => true,
                'menu_icon' => 'dashicons-images-alt', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
                'supports' => array('title','editor', 'thumbnail', 'page-attributes'),
            )
        );
    }
 add_action( 'add_meta_boxes', 'lzLuzukSliderCustomFild' );

/**
 * Method to add the custom field for the slider postsM 
 * @author Luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function lzLuzukSliderCustomFild(){
    add_meta_box( 'luzuk-more-btn-link', __('Slider button link to page', 'luzuk-premium'), 'lzLuzukSliderPages', 'slider', 'normal', 'high' );
    add_meta_box( 'slider-subtitle', __('Sub Title', 'luzuk-premium'), 'sliderSubtitleCutomFieldHtml', 'slider', 'normal', 'high' );
}

/**
 * Method to add the custom field's html that to be apears at the admin section
 * @author Luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function lzLuzukSliderPages(){
    global $post;
    // Use nonce for verification
    wp_nonce_field( plugin_basename( __FILE__ ), 'Sider_button_link' );
    //get the saved meta as an array
    $slider_btn_link = get_post_meta($post->ID,'slider_btn_link',false);
    $sliderBtnTxt = get_post_meta($post->ID,'sliderBtnTxt',false);
    $luzuk_pages = get_pages(array('hide_empty' => 0));
    echo '<div>Select the page : ';
    echo '<select name="sliderBtnLink">';
    echo '<option>Select page</option>';
    foreach ($luzuk_pages as $luzuk_pages_single) {
        $selected = ( $luzuk_pages_single->ID == $slider_btn_link[0] )?'selected':'';
        echo '<option value="'.$luzuk_pages_single->ID.'" '.$selected.'>'.$luzuk_pages_single->post_title.'</option>';
    }
    echo '</select></div>';
    echo '<div>Button Text :';
    echo '<input type="text" name="sliderBtnTxt" value="'.$sliderBtnTxt[0].'" /></div>';
}

function sliderSubtitleCutomFieldHtml(){
    global $post;
    // get the saved value 
    $slider_subtitle = get_post_meta($post->ID, 'slider_subtitle', false);
    $slider_subtitle = !empty($slider_subtitle[0])?$slider_subtitle[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Team_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-welcome-learn-more"></span></th>
    <td width="90%"><input type="text" name="slider_subtitle" width="100%" placeholder="slider_subtitle" value="'.$slider_subtitle.'" /></td>
    </tr>';
    echo '</table>';
}

function saveCustomFieds($post_id){
    // verify if this is an auto save routine. 
    // If it is our form has not been submitted, so we dont want to do anything
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) 
        return;
    // verify this came from the our screen and with proper authorization,
    // because save_post can be triggered at other times
    if ( !isset( $_POST['Sider_button_link'] )  || !isset( $_POST['slider_subtitle'] ))
        return;

    if ( !wp_verify_nonce( $_POST['Sider_button_link'], plugin_basename( __FILE__ ) ) )
        return;

    // OK, we're authenticated: we need to find and save the data
    $sliderBtnLink = $_POST['sliderBtnLink'];
    $sliderBtnTxt = $_POST['sliderBtnTxt'];
    update_post_meta($post_id,'slider_btn_link',$sliderBtnLink);
    update_post_meta($post_id,'sliderBtnTxt',$sliderBtnTxt);

    $slider_subtitle = $_POST['slider_subtitle'];
    update_post_meta($post_id, 'slider_subtitle', $slider_subtitle);
}

// add web hook for save the custome field
add_action('save_post', 'saveCustomFieds');
add_action( 'init', 'createCustomeTypes' );

function SliderVideobtntxtURLsCutomFieldHtml(){
    global $post;
    $slider_videotxt = get_post_meta($post->ID, 'slider_videotxt', false);
    $slider_videotxtValue = !empty($slider_videotxt[0])?$slider_videotxt[0]:'';
   
    wp_nonce_field(plugin_basename(__FILE__), 'slider_links');
    echo '<table id="sliderUrls" width="100%">';
    echo '<tr> 
        <th width="10%"><span class="dashicons dashicons-playlist-video"></span></th>
        <td width="90%"><input type="text" name="slider_videotxt" width="100%" placeholder="Video Button Text" value="'.$slider_videotxtValue.'" /></td>
        </tr>';
    
    echo '</table>';
}

function SliderVideoURLsCutomFieldHtml(){
    global $post;
    $slider_videourl = get_post_meta($post->ID, 'slider_videourl', false);
    $slider_videourlValue = !empty($slider_videourl[0])?$slider_videourl[0]:'';
   
    wp_nonce_field(plugin_basename(__FILE__), 'slider_links');
    echo '<table id="sliderUrls" width="100%">';
    echo '<tr> 
        <th width="10%"><span class="dashicons dashicons-playlist-video"></span></th>
        <td width="90%"><input type="text" name="slider_videourl" width="100%" placeholder="Video Src URL" value="'.$slider_videourlValue.'" /></td>
        </tr>';
    
    echo '</table>';
}
function addfeaturedHook(){
    add_meta_box('featured-social', __('Add Video Url (Copy url from iframe) Here', 'Luzuk'), 'SliderVideoURLsCutomFieldHtml', 'slider', 'normal', 'high');
    add_meta_box('slider-videobtntxt', __('Add Video Button Text', 'Luzuk'), 'SliderVideobtntxtURLsCutomFieldHtml', 'slider', 'normal', 'high');
}
function savefeaturedSocialCutomData($post_id){
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;
    if(empty($_POST['slider_videourl']) && empty($_POST['slider_videourl']) && empty($_POST['slider_videourl']) && empty($_POST['slider_videotxt']) ){
        return;
    }
    $slider_videourl = $_POST['slider_videourl'];
    update_post_meta($post_id, 'slider_videourl', $slider_videourl);

    $slider_videotxt = $_POST['slider_videotxt'];
    update_post_meta($post_id, 'slider_videotxt', $slider_videotxt);
    
}
add_action('add_meta_boxes', 'addfeaturedHook');
add_action('save_post', 'savefeaturedSocialCutomData');


/***** Start Add custome fields for team section *****/
/**
 * Method to save the custom field for the team posts 
 * When the post is saved, saves our custom data 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/

/**
 * Method to save the custom field for the slider posts 
 * When the post is saved, saves our custom data 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function teamDesignationCutomFieldHtml(){
    global $post;
    // get the saved value 
    $designation = get_post_meta($post->ID, 'designation', false);
    $designation = !empty($designation[0])?$designation[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Team_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-welcome-learn-more"></span></th>
    <td width="90%"><input type="text" name="designation" width="100%" placeholder="Designation" value="'.$designation.'" /></td>
    </tr>';
    echo '</table>';
}

function teamAgeCutomFieldHtml(){
    global $post;
    // get the saved value 
    $team_age = get_post_meta($post->ID, 'team_age', false);
    $team_age = !empty($team_age[0])?$team_age[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Team_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-businesswoman"></span></th>
    <td width="90%"><input type="text" name="team_age" width="100%" placeholder="Age" value="'.$team_age.'" /></td>
    </tr>';
    echo '</table>';
}

function teamExperienceCutomFieldHtml(){
    global $post;
    // get the saved value 
    $team_experience = get_post_meta($post->ID, 'team_experience', false);
    $team_experience = !empty($team_experience[0])?$team_experience[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Team_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-admin-users"></span></th>
    <td width="90%"><input type="text" name="team_experience" width="100%" placeholder="Experience" value="'.$team_experience.'" /></td>
    </tr>';
    echo '</table>';
}

function teamHeightCutomFieldHtml(){
    global $post;
    // get the saved value 
    $team_height = get_post_meta($post->ID, 'team_height', false);
    $team_height = !empty($team_height[0])?$team_height[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Team_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-heading"></span></th>
    <td width="90%"><input type="text" name="team_height" width="100%" placeholder="Height" value="'.$team_height.'" /></td>
    </tr>';
    echo '</table>';
}

function teamWeightCutomFieldHtml(){
    global $post;
    // get the saved value 
    $team_weight = get_post_meta($post->ID, 'team_weight', false);
    $team_weight = !empty($team_weight[0])?$team_weight[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Team_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-editor-paste-word"></span></th>
    <td width="90%"><input type="text" name="team_weight" width="100%" placeholder="Weight" value="'.$team_weight.'" /></td>
    </tr>';
    echo '</table>';
}

function teamGoalsCutomFieldHtml(){
    global $post;
    // get the saved value 
    $team_goals = get_post_meta($post->ID, 'team_goals', false);
    $team_goals = !empty($team_goals[0])?$team_goals[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Team_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-vault"></span></th>
    <td width="90%"><input type="text" name="team_goals" width="100%" placeholder="Goals" value="'.$team_goals.'" /></td>
    </tr>';
    echo '</table>';
}

function teamMatchesCutomFieldHtml(){
    global $post;
    // get the saved value 
    $team_matches = get_post_meta($post->ID, 'team_matches', false);
    $team_matches = !empty($team_matches[0])?$team_matches[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Team_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-groups"></span></th>
    <td width="90%"><input type="text" name="team_matches" width="100%" placeholder="Matches" value="'.$team_matches.'" /></td>
    </tr>';
    echo '</table>';
}

function teamAwardsCutomFieldHtml(){
    global $post;
    // get the saved value 
    $team_awards = get_post_meta($post->ID, 'team_awards', false);
    $team_awards = !empty($team_awards[0])?$team_awards[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Team_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-awards"></span></th>
    <td width="90%"><input type="text" name="team_awards" width="100%" placeholder="Awards" value="'.$team_awards.'" /></td>
    </tr>';
    echo '</table>';
}

function addTeamHook(){
    add_meta_box('luzuk-team-designation', __('Add Designation', 'luzuk'), 'teamDesignationCutomFieldHtml', 'our-team', 'normal', 'high');
    add_meta_box('luzuk-team-age', __('Add Age', 'luzuk'), 'teamAgeCutomFieldHtml', 'our-team', 'normal', 'high');
    add_meta_box('luzuk-team-experience', __('Add Experience', 'luzuk'), 'teamExperienceCutomFieldHtml', 'our-team', 'normal', 'high');
    add_meta_box('luzuk-team-height', __('Add Height', 'luzuk'), 'teamHeightCutomFieldHtml', 'our-team', 'normal', 'high');
    add_meta_box('luzuk-team-weight', __('Add Weight', 'luzuk'), 'teamWeightCutomFieldHtml', 'our-team', 'normal', 'high');
    add_meta_box('luzuk-team-goals', __('Add Goals', 'luzuk'), 'teamGoalsCutomFieldHtml', 'our-team', 'normal', 'high');
    add_meta_box('luzuk-team-matches', __('Add Matches', 'luzuk'), 'teamMatchesCutomFieldHtml', 'our-team', 'normal', 'high');
    add_meta_box('luzuk-team-awards', __('Add Awards', 'luzuk'), 'teamAwardsCutomFieldHtml', 'our-team', 'normal', 'high');
}

/**
 * Method to save the custom field for the testimonial posts 
 * When the post is saved, saves our custom data 
 * @param integer $post_id - An id of the post 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function saveTeamSocialCutomData($post_id){
    // If it is our form has not been submitted, so we dont want to do anything
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;
    if(empty($_POST['teamFacebook']) && empty($_POST['teamTwitter']) && empty($_POST['teamlinkedIn']) && empty($_POST['teamPinterest']) && empty($_POST['teamInstagram']) && empty($_POST['designation']) && empty($_POST['team_age']) && empty($_POST['team_experience']) && empty($_POST['team_height']) && empty($_POST['team_weight']) && empty($_POST['team_goals']) && empty($_POST['team_matches']) && empty($_POST['team_awards']) ){
        // echo 'empty --> '; exit;       
        return;
    }
    $teamFacebook = $_POST['teamFacebook'];
    update_post_meta($post_id, 'teamFacebook', $teamFacebook);
    $teamTwitter = $_POST['teamTwitter'];
    update_post_meta($post_id, 'teamTwitter', $teamTwitter);
    // $teamGPlus = $_POST['teamGPlus'];
    // update_post_meta($post_id, 'teamGPlus', $teamGPlus);
    $teamInstagram = $_POST['teamInstagram'];
    update_post_meta($post_id, 'teamInstagram', $teamInstagram);

    $teamlinkedIn = $_POST['teamlinkedIn'];
    update_post_meta($post_id, 'teamlinkedIn', $teamlinkedIn);


    $teamPinterest = $_POST['teamPinterest'];
    update_post_meta($post_id, 'teamPinterest', $teamPinterest);

    $designation = $_POST['designation'];
    update_post_meta($post_id, 'designation', $designation);

    $team_age = $_POST['team_age'];
    update_post_meta($post_id, 'team_age', $team_age);

    $team_experience = $_POST['team_experience'];
    update_post_meta($post_id, 'team_experience', $team_experience);

    $team_height = $_POST['team_height'];
    update_post_meta($post_id, 'team_height', $team_height);

    $team_weight = $_POST['team_weight'];
    update_post_meta($post_id, 'team_weight', $team_weight);

    $team_goals = $_POST['team_goals'];
    update_post_meta($post_id, 'team_goals', $team_goals);

    $team_matches = $_POST['team_matches'];
    update_post_meta($post_id, 'team_matches', $team_matches);

     $team_awards = $_POST['team_awards'];
    update_post_meta($post_id, 'team_awards', $team_awards);
}

add_action('add_meta_boxes', 'addTeamHook');
add_action('save_post', 'saveTeamSocialCutomData');

/***** End Add custome fields for team section *****/
/**
 * Method to save the custom field for the slider posts 
 * When the post is saved, saves our custom data 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function testimonialCutomFieldHtml(){
    global $post;
    // get the saved value 
    $testimonialSubTitle = get_post_meta($post->ID, 'testimonial_Sub_Title', false);
    $value = !empty($testimonialSubTitle[0])?$testimonialSubTitle[0]:'';
    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Testimonial_sut_title');
    echo '<div class="rows"> 
        <div class="col-sm-3">Authors Designation</div>
        <div class="col-sm-9"><input type="text" name="testimonialSubTitle" placeholder="Designation" value="'.$value.'" /></div>
    </div>';
}
function addTestimonialHook(){
    add_meta_box('lz-finesss-sub-title', __('Add subtitle for the testimonial', 'luzuk-premium'), 'testimonialCutomFieldHtml', 'our-testimonial', 'normal', 'high');
}
/**
 * Method to save the custom field for the testimonial posts 
 * When the post is saved, saves our custom data 
 * @param integer $post_id - An id of the post 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function saveTestimonialCutomData($post_id){
    // If it is our form has not been submitted, so we dont want to do anything
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;
    if(empty($_POST['Testimonial_sut_title']))
        return;
    if(!wp_verify_nonce($_POST['Testimonial_sut_title'], plugin_basename(__FILE__)))
        return;
    $testimonial_Sub_Title = $_POST['testimonialSubTitle'];
    update_post_meta($post_id, 'testimonial_Sub_Title', $testimonial_Sub_Title);
}
add_action('add_meta_boxes', 'addTestimonialHook');
add_action('save_post', 'saveTestimonialCutomData');

/**
 * Method to save the custom field for the testimonial posts 
 * When the post is saved, saves our custom data 
 * @param integer $post_id - An id of the post 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function getFonts($list = false, $index = -1){
    $fonts = array(
        "'Archivo Narrow', sans-serif",
        "'Arial', sans-serif",
        "'Arimo', sans-serif",
        "'Alex Brush', cursive",
        "'Arvo', serif",
        "'Biryani', sans-serif", 
        "'Berkshire Swash', cursive",
        "'Bitter', serif",
        "'Comfortaa', cursive",
        "'Dancing Script', cursive",
        "'Dosis', sans-serif",
        "'Droid Serif', serif",
        "'EB Garamond', serif",
        "'Exo 2', sans-serif",
        "'Francois One', sans-serif",
        "'Germania One', cursive",
        "'Hammersmith One', sans-serif",
        "'Indie Flower', cursive",
        "'Jockey One', sans-serif",
        "'Laila', sans-serif",
        "'Lobster', cursive",
        "'Lora', serif",
        "'Lato', sans-serif",
        "'Mulish', sans-serif",
        "'Muli', sans-serif",
        "'Montserrat', sans-serif",
        "'Montserrat Alternates', sans-serif",
        "'Nosifer', cursive",
        "'Oswald', sans-serif",
        "'Open Sans', sans-serif",
        "'Passion One', cursive",
        "'Passion One', cursive",
        "'PT Sans Caption', sans-serif",
        "'PT Sans Narrow', sans-serif",
        "'PT Sans', sans-serif",
        "'Pacifico', cursive",
        "'Poppins', sans-serif",       
        "'Pontano Sans', sans-serif",
        "'Playfair Display', serif", 
        "'Questrial', sans-serif",
        "'Raleway', sans-serif",
        "'Roboto Mono', monospace",
        "'Roboto Slab', serif",
        "'Roboto', sans-serif",
        "'Rubik', sans-serif",
        "'Source Serif Pro', serif",
        "'Schoolbell', cursive",
        "'Titillium Web', sans-serif",
        "'Work Sans', sans-serif",
    );
    if($list == true){
        foreach ($fonts as $key => $value) {
            $fonts[$key] = str_replace("'", "", $value);
        }
        asort($fonts);
        return $fonts;
    }
    $len = count($fonts);
    if(is_integer($index) && $index >= 0 && $index < $len){
        return $fonts[$index];
    }else{
        return $fonts;
    }
}

/**
 * show the pagination for the custome or normal post types
 * @param object $customeQuery - An onject of a query post
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Nov 2017
 **/
function lzGetPagination($customQuery){
    if(!is_object($customQuery)){return false;}
    $total_pages = $customQuery->max_num_pages;
    $big = 999999999;
    $current_page = max(1, get_query_var('paged'));
    echo paginate_links(array(
        'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
        'format' => '?paged=%#%',
        'current' => $current_page,
        'total' => $total_pages,  
        'prev_text' => __('« Prev', 'text-domain'), // Add custom prev text
        'next_text' => __('Next »', 'text-domain'), // Add custom next text  
    ));
}


/**
 * @snippet       Plus Minus Quantity Buttons @ WooCommerce Product Page & Cart
 * @how-to        Get CustomizeWoo.com FREE
 * @author        Rodolfo Melogli
 * @compatible    WooCommerce 5
 * @donate $9     https://businessbloomer.com/bloomer-armada/
 */
  
// -------------
// 1. Add quantity buttons

add_action( 'woocommerce_after_quantity_input_field', 'bbloomer_display_quantity_plus' );
  
function bbloomer_display_quantity_plus() {
    echo '<button type="button" class="plus">+</button>';
}
  
add_action( 'woocommerce_before_quantity_input_field', 'bbloomer_display_quantity_minus' );
  
function bbloomer_display_quantity_minus() {
    echo '<button type="button" class="minus">-</button>';
}
  
// 2. Trigger update quantity script

add_action( 'wp_footer', 'bbloomer_add_cart_quantity_plus_minus' );
  
function bbloomer_add_cart_quantity_plus_minus() {
    // Check if WooCommerce is active
    if ( class_exists( 'WooCommerce' ) ) {
        // Check if we're on a product or cart page
        if ( ! is_product() && ! is_cart() ) return;
    
        wc_enqueue_js( "   
            $(document).on( 'click', 'button.plus, button.minus', function() {
                var qty = $( this ).parent( '.quantity' ).find( '.qty' );
                var val = parseFloat(qty.val());
                var max = parseFloat(qty.attr( 'max' ));
                var min = parseFloat(qty.attr( 'min' ));
                var step = parseFloat(qty.attr( 'step' ));
 
                if ( $( this ).is( '.plus' ) ) {
                    if ( max && ( max <= val ) ) {
                        qty.val( max ).change();
                    } else {
                        qty.val( val + step ).change();
                    }
                } else {
                    if ( min && ( min >= val ) ) {
                        qty.val( min ).change();
                    } else if ( val > 1 ) {
                        qty.val( val - step ).change();
                    }
                }
            });
        " );
    }
}



/**
* WooCommerce Extra Feature
* --------------------------
*
* Change number of related products on product page
* Set your own value for 'posts_per_page'
*
*/ 

// Single product image gallery zoom and slider

add_action( 'after_setup_theme', 'yourtheme_setup' );

function yourtheme_setup() {
    add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
    add_theme_support( 'wc-product-gallery-slider' );
    add_theme_support( 'woocommerce' );
}


add_filter( 'woocommerce_single_product_carousel_options', 'cuswoo_update_woo_flexslider_options' );
/** 
 * Filer WooCommerce Flexslider options - Add Navigation Arrows
 */
function cuswoo_update_woo_flexslider_options( $options ) {

    $options['directionNav'] = true;

    return $options;
}

function sbw_wc_add_buy_now_button_single()
{
    global $product;
    printf( '<button id="sbw_wc-adding-button" type="submit" name="sbw-wc-buy-now" value="%d" class="single_add_to_cart_button buy-now-button button alt">%s</button>', $product->get_ID(), esc_html__( 'Buy Now', 'sbw-wc' ) );
}

add_action( 'woocommerce_after_add_to_cart_button', 'sbw_wc_add_buy_now_button_single' );

/*** Handle for click on buy now ***/
function sbw_wc_handle_buy_now() {
    if ( ! isset( $_REQUEST['sbw-wc-buy-now'] ) ) {
        return false;
    }

    $product_id = absint( $_REQUEST['sbw-wc-buy-now'] );
    $quantity = isset( $_REQUEST['quantity'] ) ? absint( $_REQUEST['quantity'] ) : 1;
    $variation_id = isset( $_REQUEST['variation_id'] ) ? absint( $_REQUEST['variation_id'] ) : 0;

    // Check if product is already in the cart
    $cart = WC()->cart->get_cart();
    $product_in_cart = false;

    foreach ( $cart as $cart_item_key => $cart_item ) {
        if ( $cart_item['product_id'] == $product_id && $cart_item['variation_id'] == $variation_id ) {
            $product_in_cart = true;
            // Update the quantity if needed
            WC()->cart->set_quantity( $cart_item_key, $cart_item['quantity'] + $quantity );
            break;
        }
    }

    // Add product to cart if not already in
    if ( ! $product_in_cart ) {
        if ( $variation_id > 0 ) {
            WC()->cart->add_to_cart( $product_id, $quantity, $variation_id );
        } else {
            WC()->cart->add_to_cart( $product_id, $quantity );
        }
    }

    wp_safe_redirect( wc_get_checkout_url() );
    exit;
}
add_action( 'wp_loaded', 'sbw_wc_handle_buy_now' );






// To display quantity label on product page
add_action( 'woocommerce_before_add_to_cart_quantity', 'woosuite_echo_qty_front_add_cart' );
function woosuite_echo_qty_front_add_cart() {
    echo '<div class="price-info">';
    echo '<div class="total-price"></div>';
    echo '</div>';
 echo '<span class="qty-label">Quantity : </span>';
}


function reading_time() {
    $word_count = str_word_count(strip_tags(get_post_field('post_content', get_the_ID())));
    $reading_time = ceil($word_count / 70); // Assuming 200 words per minute
    return $reading_time . ' mins read';
}


// tags----------

// Add Image Upload field to the 'Add New Tag' form
add_action('post_tag_add_form_fields', 'add_image_upload_field_to_tag', 10, 2);
function add_image_upload_field_to_tag() {
    ?>
    <div class="form-field">
        <label for="tag_image"><?php _e('Tag Image', 'your-text-domain'); ?></label>
        <input type="button" class="button tag-image-upload-button" value="<?php _e('Upload Image', 'your-text-domain'); ?>" />
        <input type="hidden" name="tag_image" id="tag_image" class="tag-image-url" value="" />
        <div class="tag-image-preview"></div>
        <p class="description"><?php _e('Upload an image for this tag.', 'your-text-domain'); ?></p>
    </div>
    <?php
}

// Add Image Upload field to the 'Edit Tag' form
add_action('post_tag_edit_form_fields', 'edit_image_upload_field_for_tag', 10, 2);
function edit_image_upload_field_for_tag($term) {
    $tag_image = get_term_meta($term->term_id, 'tag_image', true);
    ?>
    <tr class="form-field">
        <th scope="row" valign="top"><label for="tag_image"><?php _e('Tag Image', 'your-text-domain'); ?></label></th>
        <td>
            <input type="button" class="button tag-image-upload-button" value="<?php _e('Upload Image', 'your-text-domain'); ?>" />
            <input type="hidden" name="tag_image" id="tag_image" class="tag-image-url" value="<?php echo esc_attr($tag_image); ?>" />
            <div class="tag-image-preview">
                <?php if ($tag_image) : ?>
                    <img src="<?php echo esc_url($tag_image); ?>" style="max-width: 100px;" />
                <?php endif; ?>
            </div>
            <p class="description"><?php _e('Upload an image for this tag.', 'your-text-domain'); ?></p>
        </td>
    </tr>
    <?php
}

// Save the Tag Image
add_action('created_post_tag', 'save_tag_image_meta', 10, 2);
add_action('edited_post_tag', 'save_tag_image_meta', 10, 2);
function save_tag_image_meta($term_id) {
    if (isset($_POST['tag_image']) && $_POST['tag_image'] !== '') {
        update_term_meta($term_id, 'tag_image', esc_url_raw($_POST['tag_image']));
    } else {
        delete_term_meta($term_id, 'tag_image');
    }
}

// Enqueue Media Uploader
add_action('admin_enqueue_scripts', 'enqueue_media_uploader_for_tags');
function enqueue_media_uploader_for_tags() {
    wp_enqueue_media();
    wp_enqueue_script('tag-image-upload', get_template_directory_uri() . '/js/tag-image-upload.js', array('jquery'), null, true);
}


// For tag page
add_action('wp_ajax_fetch_posts_by_tag', 'fetch_posts_by_tag');
add_action('wp_ajax_nopriv_fetch_posts_by_tag', 'fetch_posts_by_tag');

function fetch_posts_by_tag() {
    $tag_id = intval($_POST['tag_id']);
    
    $args = array(
        'tag_id' => $tag_id,
        'posts_per_page' => -1 // Fetch all posts for the tag
    );
    
    $query = new WP_Query($args);
    
    if ($query->have_posts()) {
        ob_start(); // Start output buffering

         $start_number = 1; // Start numbering from 1
        $counter = $start_number;
        while ($query->have_posts()) {
            $query->the_post();
            ?>
            <div class="inner-blog-post col-lg-12 tag-post">
                <div class="inner-blogpost">
                    <div class="inner-blogpost-info">
                        <div class="post-tags">
                            <?php
                            $tags = get_the_tags();
                            if ($tags) {
                                foreach ($tags as $tag) {
                                    echo '<a href="" class="tag" data-tag-id="' . esc_attr($tag->term_id) . '">#' . esc_html($tag->name) . '</a> ';
                                }
                            }
                            ?>
                        </div>
                        <a href="<?php the_permalink(); ?>"><h2><?php the_title(); ?></h2></a>
                        <div class="inner-blog-excerpt">
                            <?php 
                            //$blgtagstxtlimit = get_theme_mod('blgtagstxtlimit', '380');
                            if (has_excerpt()) {
                                echo get_the_excerpt();
                            } else {
                                echo wp_trim_words(get_the_content(), 50);
                            }
                            ?> 
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <div class="tagpage-blognumber">
                     <?php echo $counter++; ?>
                </div>
                </div>
            </div>
            <?php
        }
        $output = ob_get_clean(); 
        echo $output; 
    } else {
        echo '<p>No posts found for this tag.</p>';
    }

    wp_reset_postdata();
    wp_die(); 
}



function display_blog_image_gallery($post_id) {
    $gallery_ids = get_post_meta($post_id, 'gallery_ids', true); // Assuming you store gallery IDs in post meta
    if ($gallery_ids) {
        $ids = explode(',', $gallery_ids);
        $output = '<div class="blog-image-gallery">';

        foreach ($ids as $id) {
            $img_url = wp_get_attachment_image_src($id, 'large')[0];
            $output .= '<div class="gallery-item">';
            $output .= '<img src="' . esc_url($img_url) . '" alt="" />';
            $output .= '</div>';
        }

        $output .= '</div>';
        return $output;
    }
    return '';
}



class Custom_Recent_Posts_Widget extends WP_Widget_Recent_Posts {
    public function widget( $args, $instance ) {
        if ( ! isset( $args['widget_id'] ) ) {
            $args['widget_id'] = $this->id;
        }

        $title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Recent Posts' );
        $title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

        $query_args = [
            'posts_per_page'      => ! empty( $instance['number'] ) ? absint( $instance['number'] ) : 5,
            'post_status'         => 'publish',
            'no_found_rows'       => true,
            'ignore_sticky_posts' => true,
        ];

        $recent_posts = new WP_Query( apply_filters( 'widget_posts_args', $query_args ) );

        if ( ! $recent_posts->have_posts() ) {
            return;
        }
        ?>

        <?php echo $args['before_widget']; ?>
        <?php if ( $title ) {
            echo $args['before_title'] . $title . $args['after_title'];
        } ?>
        <ul>
            <?php foreach ( $recent_posts->posts as $recent_post ) : ?>
                <?php
                $post_title = get_the_title( $recent_post->ID );
                $title = ( ! empty( $post_title ) ) ? $post_title : __( '(No Title)' );
                $thumbnail = get_the_post_thumbnail( $recent_post->ID, 'thumbnail' );
                ?>
                <li>
                    <?php if ( $thumbnail ) : ?>
                        <a href="<?php echo get_permalink( $recent_post->ID ); ?>">
                            <?php echo $thumbnail; ?>
                        </a>
                    <?php endif; ?>
                    <a href="<?php echo get_permalink( $recent_post->ID ); ?>">
                        <?php echo $title; ?>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>
        <?php echo $args['after_widget']; ?>

        <?php
    }
}

function register_custom_recent_posts_widget() {
    unregister_widget( 'WP_Widget_Recent_Posts' );
    register_widget( 'Custom_Recent_Posts_Widget' );
}
add_action( 'widgets_init', 'register_custom_recent_posts_widget' );



add_action('admin_menu', 'luzuk_lite_reorder_appearance_menu', 999);

function luzuk_lite_reorder_appearance_menu() {
    global $submenu;

    if (isset($submenu['themes.php'])) {
        $themes_submenu = $submenu['themes.php'];

        // Find and extract the Themes Dashboard item
        foreach ($themes_submenu as $key => $item) {
            if ($item[2] === 'themes-dashboard') {
                $dashboard_item = $item;
                unset($themes_submenu[$key]);
                break;
            }
        }

        // Re-index and add Themes Dashboard at the top
        if (isset($dashboard_item)) {
            $themes_submenu = array_values($themes_submenu); // reindex
            array_unshift($themes_submenu, $dashboard_item);
            $submenu['themes.php'] = $themes_submenu;
        }
    }
}

// Hook into current_screen to detect if we're on our custom page
add_action('current_screen', 'luzuk_lite_hide_admin_notices_on_custom_page');

function luzuk_lite_hide_admin_notices_on_custom_page($screen) {
    // Check for our custom page slug
    if ($screen->id === 'appearance_page_themes-dashboard') {
        // Remove all actions that show admin notices
        remove_all_actions('admin_notices');
        remove_all_actions('all_admin_notices');
        remove_all_actions('network_admin_notices');
    }
}

add_action('admin_menu', 'luzuk_lite_add_themes_dashboard_menu');

function luzuk_lite_add_themes_dashboard_menu() {
    add_theme_page(
        'Themes Dashboard',
        'Themes Dashboard',
        'manage_options',
        'themes-dashboard',
        'luzuk_lite_themes_dashboard_page'
    );
}

function luzuk_lite_themes_dashboard_page() {
    // Handle force ping request
    if ( isset( $_GET['force_tracker_ping'] ) && check_admin_referer( 'force_tracker_ping' ) ) {
        if ( function_exists( 'luzuk_lite_force_tracker_ping' ) ) {
            $result = luzuk_lite_force_tracker_ping();
            if ( $result['success'] ) {
                echo '<div class="notice notice-success is-dismissible"><p>' . esc_html( $result['message'] ) . '</p></div>';
            } else {
                echo '<div class="notice notice-error is-dismissible"><p>' . esc_html( $result['message'] ) . '</p></div>';
            }
        }
    }

    echo luzuk_lite_render_combined_dashboard();
}

function luzuk_lite_render_combined_dashboard() {
    $theme = wp_get_theme();
    $theme_name = $theme->get('Name');
    $screenshot = $theme->get_screenshot();
	$theme_description = $theme->get('Description');
    $theme_version = $theme->get('Version');

    $customize_url = admin_url('customize.php');

	// Dashboard file
	$dashboard_url = 'https://raw.githubusercontent.com/LuzukThemes/themes-dashboard/main/dashboard.html';
	$dashboard_response = wp_remote_get($dashboard_url);
	$dashboard_html = '';

	if (!is_wp_error($dashboard_response)) {
		$dashboard_html = wp_remote_retrieve_body($dashboard_response);
	} else {
		$dashboard_html = '<div class="notice notice-error"><p>Unable to load Dashboard content from GitHub.</p></div>';
	}

    ob_start(); ?>
    <div class="wrap">
        <h1>Themes Dashboard</h1>
        <div style="display: flex; gap: 30px; margin-top: 30px;">

            <!-- Left Column -->
            <div style="flex: 1; background: #fff; padding: 20px; border: 1px solid #ddd; border-radius: 8px;">
				<h2 style="margin: 0 0 30px;background: #000;color: #fff;padding: 22px;text-align: center;border-radius: 6px;">Use this coupon code and get 15% discount instantly <span style="background: #ff0000; color: #fff; padding: 5px 10px; border-radius: 5px;margin-left: 10px;">LUZUKDISCOUNT</span></h2>
                <img src="<?php echo esc_url($screenshot); ?>" alt="Theme Screenshot" style="max-width: 50%; border: 1px solid #ccc; float: left; margin-right: 20px; border-radius: 8px; border-right-color: #ff0000; border-bottom-color: #ff0000;" />
				<div style="background: #fff; padding: 20px; border: 1px solid #ddd; border-radius: 8px;">
					<h2 style="margin: 20px 0 30px;"><?php echo esc_html($theme_name); ?></h2>
					<p><strong>Version:</strong> <?php echo esc_html($theme_version); ?></p>
					<p><?php echo esc_html($theme_description); ?></p>
				</div>
                <div style="margin: 15px 0 50px;">
                    <a href="https://www.luzukdemo.com/demo/expert-blogger/" target="_blank" class="button" style="background: #000; color: #fff; margin-right: 10px; padding: 6px 24px; font-size: 16px; font-weight: bold">Live Demo</a>
					<a href="https://www.luzukdemo.com/docs/expert-blogger/" target="_blank" class="button" style="background: #000; color: #fff; margin-right: 10px; padding: 6px 24px; font-size: 16px; font-weight: bold">Pro Documentation</a>
					<a href="https://www.luzuk.com/products/premium-blog-expert-wordpress-theme?_pos=3&_sid=a5913a817&_ss=r" target="_blank" class="button" style="background: #0056ff; color: #fff; margin-right: 10px; padding: 6px 24px; font-size: 16px; font-weight: bold">Buy Premium</a>
                </div>

                <?php echo $dashboard_html; ?>

		</div>
          
		<div style="display: flex; gap: 30px; margin-top: 30px; text-align: center;">
			<div style="flex: 2; margin: 20px 0; padding: 20px; background: #f7f7f7; border: 1px dashed #aaa;">
                <div class="coupon-ticket">
                    <div class="coupon-title">Get 15% OFF</div>
                    <div>Use Code Below:</div>
                    <div class="coupon-code" onclick="copyCoupon(this)">LUZUKDISCOUNT</div>
                </div>
                <script>
                    function copyCoupon(el) {
                        const coupon = el.textContent;
                        navigator.clipboard.writeText(coupon).then(() => {
                        el.classList.add("copied");
                        setTimeout(() => {
                            el.classList.remove("copied");
                        }, 2000);
                        });
                    }
                </script>
                  <style>
      
                .coupon-ticket {
                width: 320px;
                margin: 40px auto;
                padding: 20px;
                border: 2px dashed #ff4d4d;
                border-radius: 10px;
                background-color: #fff4f4;
                font-family: Arial, sans-serif;
                text-align: center;
                position: relative;
                }

                .coupon-ticket::before,
                .coupon-ticket::after {
                content: "";
                position: absolute;
                top: 50%;
                width: 20px;
                height: 20px;
                background-color: #fff4f4;
                border: 2px dashed #ff4d4d;
                border-radius: 50%;
                transform: translateY(-50%);
                }

                .coupon-ticket::before {
                left: -12px;
                }

                .coupon-ticket::after {
                right: -12px;
                }

                .coupon-title {
                font-size: 20px;
                color: #d80000;
                font-weight: bold;
                margin-bottom: 10px;
                }

                .coupon-code {
                display: inline-block;
                background-color: #d80000;
                color: #fff;
                padding: 8px 16px;
                font-size: 16px;
                border-radius: 4px;
                margin-top: 5px;
                letter-spacing: 1px;
                cursor: pointer;
                }
                .coupon-code::after {
                content: "Click to copy";
                position: absolute;
                top: -30px;
                left: 50%;
                transform: translateX(-50%);
                background: #333;
                color: #fff;
                padding: 5px 8px;
                border-radius: 4px;
                font-size: 12px;
                white-space: nowrap;
                opacity: 0;
                pointer-events: none;
                transition: opacity 0.3s ease;
            }

            .coupon-code:hover::after {
                opacity: 1;
            }

            .coupon-code.copied::after {
                content: "Copied!";
                background: #4caf50;
            }
            </style>
				<a href="https://www.luzuk.com/products/premium-blog-expert-wordpress-theme?_pos=3&_sid=a5913a817&_ss=r" target="_blank" class="button button-primary" style="display: block; padding: 10px; background: #77b255;font-weight: bold; margin-top: 10px;">UPGRADE NOW</a><br>
			</div>
			<div style="flex: 2; margin: 20px 0; padding: 20px;"></div>
		</div>
		
    <?php
    return ob_get_clean();
}

/**
 * Show notice on frontend pages that contain shortcodes.
 * Free theme: inform user that shortcodes require premium.
 */
function luzuk_lite_shortcode_premium_notice( $content ) {
    if ( is_admin() ) {
        return $content;
    }
 
    if ( ! is_singular( 'page' ) || ! in_the_loop() || ! is_main_query() ) {
        return $content;
    }
 
    global $post;
    if ( ! $post instanceof WP_Post ) {
        return $content;
    }
 
    // Simple detection: if the original content contains shortcode syntax
    if ( strpos( $post->post_content, '[' ) === false || strpos( $post->post_content, ']' ) === false ) {
        return $content;
    }
 
    $notice  = '<div class="luzuk-shortcode-premium-notice" style="margin:20px 0;padding:12px 15px;border:1px solid #e1a200;background:#fff8e5;color:#333;font-size:14px;border-radius:4px;">';
    $notice .= esc_html__( 'Shortcodes are available only in the premium version of this theme. To use shortcode features, please purchase the premium theme.', 'Luzuk Premium' );
    $notice .= '</div>';
 
    // Add big upgrade button under the notice text
    $notice .= '<a href="https://www.luzuk.com/products/premium-blog-expert-wordpress-theme?_pos=3&_sid=a5913a817&_ss=r" target="_blank" class="button button-primary" style="    color: #fff;display:block;padding:10px;background:#77b255;font-weight:bold;margin:10px 0 0 0;text-align:center;">UPGRADE NOW</a>';
 
    return $notice . $content;
}
add_filter( 'the_content', 'luzuk_lite_shortcode_premium_notice', 5 );