<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package luzuk Premium
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css
" rel="stylesheet">
	
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Lora:ital,wght@0,400..700;1,400..700&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=PT+Sans:ital,wght@0,400;0,700;1,400;1,700&display=swap" rel="stylesheet">


    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.1.1.min.js" integrity="sha384-3ceskX3iaEnIogmQchP8opvBy3Mi7Ce34nWjpBIwVTHfGYWQS9jwHDVRnpKKHJg7" crossorigin="anonymous"></script>

    <script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
    <script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
    <script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>

    <script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" type="text/javascript"  ></script>
    <script src="<?php echo get_template_directory_uri(); ?>/js/swiper.min.js" type="text/javascript"  ></script>
    <script type="text/javascript" src="https://code.jquery.com/jquery-1.12.0.min.js"></script>
   	<script type="text/javascript">
		$(document).ready(function(){
			$("#formButton").click(function(){
				$("#form1").toggle();
			});
		});
	 </script>

	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<div class="main-container">
		<!-- <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'luzuk' ); ?></a> -->
	    <div id="loading-area"><div class="la-anim-10"></div></div>
		<header class="site-header header-transparent header header-seo">
		    <div class="top-bar-head">
		    	<div class="container">
                  <div class="h-img">
			        <div class="row mr-0 bottom-header">
				        <div class="offset-xl-1 col-xl-7 col-lg-9 col-md-2 col-sm-3 col-2 header-menu">
			        		<div class="nav-menus">                  
								<a class="js-nav-toggle">
									<span></span>
								</a>
							    <div class="nav-wrapper">
									<nav role="navigation">
										<div class="nav-toggle">
												<span class="nav-back"></span>
												<span class="nav-title">Menu</span>
												<span class="nav-close"></span>
										</div>
										<?php
	                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
	                                            wp_nav_menu ( array(
	                                                'menu_class' => 'mainm ht-clearfix',
	                                                'container'=> 'ul',
	                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
	                                                'theme_location' => 'primary',  
	                                            )); 
	                                        } else {
	                                            wp_nav_menu ( array(
	                                                'menu_class' => 'mainm ht-clearfix',
	                                                'container'=> 'ul',
	                                                'theme_location' => 'primary',  
	                                            )); 
	                                        }
	                                    ?>
									</nav>
								</div>
							</div>
							<nav class="navigation">
		                        <div class="menu-wrapper">
		                            <div class="menu-content">
	                                    <?php
	                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
	                                            wp_nav_menu ( array(
	                                                'menu_class' => 'mainmenu ht-clearfix',
	                                                'container'=> 'ul',
	                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
	                                                'theme_location' => 'primary',  
	                                            )); 
	                                        } else {
	                                            wp_nav_menu ( array(
	                                                'menu_class' => 'mainmenu ht-clearfix',
	                                                'container'=> 'ul',
	                                                'theme_location' => 'primary',  
	                                            )); 
	                                        }
	                                    ?>
		                            </div> <!-- /.hours-content-->
						            <div class="clearfix"></div>
		                        </div><!-- /.menu-wrapper --> 
		                	</nav>
				        </div>
				        <?php
							$twitter = get_theme_mod('header_tw', 'https://x.com/');
							$facebook = get_theme_mod('header_fb', 'https://www.facebook.com/');
							$linkedin = get_theme_mod('header_in', 'https://www.linkedin.com/');
							$instagram = get_theme_mod('header_insta', 'https://www.instagram.com/');
							$youtube = get_theme_mod('header_yt', 'https://www.youtube.com/');
						?>
				        <div class="col-xl-3 col-lg-3 col-md-10 col-sm-9 col-10 header-social">
				        	<?php if($twitter || $facebook || $linkedin || $instagram || $youtube){ ?>
								<div class="header-socialicon">	
									<?php if(!empty($twitter)){ ?>
										<li>
											<a href="<?php echo $twitter; ?>" title="Twitter" class="site-button sharp" target="_blank">
												<i class="fa-brands fa-x-twitter"></i>
											</a>
										</li>
									<?php }?>
									<?php if(!empty($facebook)){ ?>
										<li>
											<a href="<?php echo $facebook; ?>" title="Facebook" class="site-button sharp" target="_blank">
												<i class="fa fa-facebook"></i>
											</a>
										</li>
									<?php }?>
									<?php if(!empty($linkedin)){ ?>
										<li>
											<a href="<?php echo $linkedin; ?>" title="Facebook" class="site-button sharp" target="_blank">
												<i class="fa fa-linkedin"></i>
											</a>
										</li>
									<?php }?>
									<?php if(!empty($instagram)){ ?>
										<li>
											<a href="<?php echo $instagram; ?>" title="Instagram" class="site-button sharp" target="_blank">
												<i class="fa fa-instagram"></i>
											</a>
										</li>
									<?php }?>
									<?php if(!empty($youtube)){ ?>
										<li>
											<a href="<?php echo $youtube; ?>" title="Instagram" class="site-button sharp" target="_blank">
												<i class="fa fa-youtube-play"></i>
											</a>
										</li>
									<?php }?>
									<div class="clearfix"></div>
								</div>
							 <?php }?>
				        </div>
				    </div>
	                <!-- </div> -->
	    			<div class="clearfix"></div>
	    		</div>
		    </div>	
		</div>	
		<div class="bottom-bar-head">
			<div class="container">
				<div class="row">
					<div class="offset-xl-1 col-xl-6 col-lg-7 col-md-6 col-sm-5 col-xs-4 col-7 ">
						<div class="header-left logo">
		    				<?php 
		    					if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
		    						$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
		    					}
		    				?>
							<!-- website logo -->
						    <div class="logo-header mostion">
		    					<?php 
		    					if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
		    						the_custom_logo();
		    					else : 
		    						 if( get_theme_mod('head_sitetitle_display','show' ) == 'show') :
		    					if ( is_front_page() ) : ?>
		    					<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
		    						<?php else : ?>
		    					<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
		    					<?php endif ?>
		    						<?php endif; ?>
		    					<?php endif; ?>
						    </div> 
							<?php if( get_theme_mod('head_tagline_display','show' ) == 'show') :?>	
								<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p> 
							<?php endif ?>
									<!-- nav toggle button -->
							<div class="resp_header_logo">
								<?php 
								if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
									the_custom_logo();
									else : 
								if ( is_front_page() ) : ?>
							    <h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
									<?php else : ?>
							    <p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
								<?php endif; ?>
									<!-- <p class="ht-site-description"><a href="<//?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><//?php //bloginfo( 'description' ); ?></a></p> -->
							    <?php endif; ?>
							</div>
						</div>
					</div>
					<div class="col-xl-4 col-lg-5 col-md-6 col-sm-7 col-5">
						<div id="sb-search" class="sb-search">
							<form role="search" method="get" class="woocommerce-product-search" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
								<label class="screen-reader-text" for="s"><?php _e( 'Search for:', 'woocommerce' ); ?></label>
								<input type="search" class="search-field" placeholder="<?php echo esc_attr_x( 'Search', 'placeholder', 'woocommerce' ); ?>" value="<?php echo get_search_query(); ?>" name="s" title="<?php echo esc_attr_x( 'Search for:', 'label', 'woocommerce' ); ?>" />
								<input type="submit" value="<?php echo esc_attr_x( '', 'submit button', 'woocommerce' ); ?>" />
								<input type="hidden" name="post_type" value="product" />
							</form>
						</div>
						<div class="top-form">
							<button type="button" id="formButton" class="pull-right"></button>
							<form id="form1">					
								<?php get_search_form(); ?>
							</form>	
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="clearfix"></div>
	</header>
</div>