<?php

$wp_customize->add_panel(
	'luzuk_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'luzuk Premium')
	)
);

//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

// $wp_customize->add_setting(
//     'pages_logoTopsetmaxwidth',
//     array(
//         'sanitize_callback' => 'luzuk_sanitize_text',
//         'default'           => __( '100', 'luzuk-premium' )
//     )
// );

// $wp_customize->add_control(
//     'pages_logoTopsetmaxwidth',
//     array(
//         'settings'      => 'pages_logoTopsetmaxwidth',
//         'section'       => 'title_taFgline',
//         'type'          => 'text',
//         'label'         => __( 'Set Logo Max Width', 'luzuk-premium' )
//     )
// );

addColorPalatOption($wp_customize, 'header_SiteTitleClr', 'title_tagline', 'Title Color', '#2E2E2E');

addColorPalatOption($wp_customize, 'header_SiteTaglineClr', 'title_tagline', 'Tagline Color', '#2E2E2E');

$wp_customize->add_setting( 'head_sitetitle_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'head_sitetitle_display', array( 'label' => 'Site Title Display', 'section' => 'title_tagline', 'settings' => 'head_sitetitle_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 

$wp_customize->add_setting( 'head_tagline_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'head_tagline_display', array( 'label' => 'Tagline Display', 'section' => 'title_tagline', 'settings' => 'head_tagline_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 


//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );


//HEADER SETTINGS
$wp_customize->add_section(
	'header_settings',
	array(
		'title' => __( 'Header Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'stickyheader_view', 'header_settings', 'Sticky Header Settings');
    //ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
    'luzuk_sticky_header_enable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'luzuk_sticky_header_enable',
        array(
            'settings'      => 'luzuk_sticky_header_enable',
            'section'       => 'header_settings',
            'label'         => __( 'Sticky Header', 'luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Enable', 'luzuk-premium' ),
                'off' => __( 'Disable', 'luzuk-premium' )
            )   
        )
    )
);


$sectionHeader = 'header_settings';


lzCustomLable($wp_customize, 'pages_logosetmaxwidth5', 'title_tagline', 'Set Logo Width & Height');

$wp_customize->add_setting(
    'pages_logoTopsetmaxwidth',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '100%', 'luzuk-premium' )

    )
);

// logo width

$wp_customize->add_control(
    'pages_logoTopsetmaxwidth',
    array(
        'settings'      => 'pages_logoTopsetmaxwidth',
        'section'       => 'title_tagline',
        'type'          => 'range',
        'label'         => __( 'Width', 'luzuk-premium' )
    )
);

// logo height

$wp_customize->add_setting(
    'pages_logoTopsetmaxheight',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoTopsetmaxheight',
    array(
        'settings'      => 'pages_logoTopsetmaxheight',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Height ', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'luzuk_headerlogo_margin', 'header_settings', 'Logo Margin');

$wp_customize->add_setting(
    'logo_logoTmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'logo_logoTmargin',
    array(
        'settings'      => 'logo_logoTmargin',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'logo_logoRmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'logo_logoRmargin',
    array(
        'settings'      => 'logo_logoRmargin',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Right', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'logo_logoBmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'logo_logoBmargin',
    array(
        'settings'      => 'logo_logoBmargin',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'logo_logoLmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'logo_logoLmargin',
    array(
        'settings'      => 'logo_logoLmargin',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Left', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'header_MenuColorssettings', $sectionHeader, 'Navigation Color');

addColorPalatOption($wp_customize, 'header_innpagetopmenusClr', 'header_settings', 'Inner Page Menus Color', '#C2C2C2');

addColorPalatOption($wp_customize, 'header_topmenusColor', 'header_settings', 'Menus Color', '#C2C2C2');

addColorPalatOption($wp_customize, 'header_topmenushoverColor', 'header_settings', 'Menus Hover Color', '#fff');

addColorPalatOption($wp_customize, 'header_topmenusactiveColor', 'header_settings', 'Active Menus Color', '#fff');

addColorPalatOption($wp_customize, 'header_topsubmenusColor', 'header_settings', 'Header Sub Menus Color', '#000');

addColorPalatOption($wp_customize, 'header_topsubmenushvrColor', 'header_settings', 'Sub Menus Hover & Sub Menus Active Color', '#F47E00');

addColorPalatOption($wp_customize, 'header_topsubmenushvrbgColor', 'header_settings', 'Sub Menus Hover BG Color', '#F4F4F4');

addColorPalatOption($wp_customize, 'header_submenusbgsscColor', 'header_settings', 'Dropdown Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'header_submenusbgsColor', 'header_settings', 'Top Header BG Color', '#2E2E2E');

lzCustomLable($wp_customize, 'header_headersocialiconsettings', $sectionHeader, 'Social Icon');

$wp_customize->add_setting(
    'header_tw',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'https://x.com/', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'header_tw',
    array(
        'settings'      => 'header_tw',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Twitter Link', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'header_fb',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'https://www.facebook.com/', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'header_fb',
    array(
        'settings'      => 'header_fb',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Facebook Link', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'header_in',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'https://www.linkedin.com/', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'header_in',
    array(
        'settings'      => 'header_in',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Linkedin Link', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'header_insta',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'https://www.instagram.com/', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'header_insta',
    array(
        'settings'      => 'header_insta',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Instagram Link', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'header_yt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'https://www.youtube.com/', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'header_yt',
    array(
        'settings'      => 'header_yt',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Youtube Link', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'header_headersocialiconscolor', $sectionHeader, 'Social Icon');

addColorPalatOption($wp_customize, 'header_socialiconColor', 'header_settings', 'Social Icon Color', '#fff');

addColorPalatOption($wp_customize, 'header_socialiconhoverColor', 'header_settings', 'Social Icon Hover Color', '#F47E00');

lzCustomLable($wp_customize, 'header_colorsfortabandmobview', $sectionHeader, 'Responsive Header Settings');

addColorPalatOption($wp_customize, 'header_respnavtoggbarbgssColor', 'header_settings', 'Toggle Bar Color', '#fff');

addColorPalatOption($wp_customize, 'header_respnavbsbgssColor', 'header_settings', ' Navigation Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'header_navigationrespnavbrssColor', 'header_settings', 'Menus Title Color', '#000');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenuttlbgColor', 'header_settings', 'Menus Title BG Color', '#d5d5d5');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenuColor', 'header_settings', 'Menus Color', '#fff');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenubgColor', 'header_settings', 'Menus BG Color', '#2E2E2E'); 

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'luzuk Premium'),
	'panel' => 'luzuk_general_panel',
) );

    $wp_customize->add_setting('luzuk_premium_color_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_color_section_lbl',
        array(
            'settings'      => 'luzuk_premium_color_section_lbl',
            'section'       => 'colors',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);


//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'luzuk_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'luzuk_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show', 'hide' => 'Hide', ), ) ); 


$wp_customize->add_setting(
        'luzuk_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Home', 'luzuk' )
        )
    );
    $wp_customize->add_control(
        'luzuk_breadcrumbhometxt',
        array(
            'settings'      => 'luzuk_breadcrumbhometxt',
            'section'       => 'luzuk_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here', 'luzuk' )
        )
    );

// end to show & hide button

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'luzuk_blogpage_settings',
	array(
		'title' => __( 'Inner Blog Page Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

    $wp_customize->add_setting('luzuk_premium_blog_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_blog_section_lbl',
        array(
            'settings'      => 'luzuk_premium_blog_section_lbl',
            'section'       => 'luzuk_blogpage_settings',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);


//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'footer_area',
	array(
		'title' => __( 'Footer Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);  

backgroundManager($wp_customize, 'footer', 'footer_area', $color='#F8F8F8', get_template_directory_uri().'/images/default.png', 'img');

lzCustomLable($wp_customize, 'footer_areaPadding', 'footer_area', 'Footer Padding');

$wp_customize->add_setting(
    'sec_footerseTmargin', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footerseTmargin',
    array(
        'settings'      => 'sec_footerseTmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'sec_footersebottommargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footersebottommargin',
    array(
        'settings'      => 'sec_footersebottommargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'footer_areabottomfPadding', 'footer_area', 'Copyright Text Box Padding');

$wp_customize->add_setting(
    'sec_bottomareaTmargin', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_bottomareaTmargin',
    array(
        'settings'      => 'sec_bottomareaTmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'sec_bottomareabottommargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_bottomareabottommargin',
    array(
        'settings'      => 'sec_bottomareabottommargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'footer_copytext', 'footer_area', 'Footer Copyright Text');

$wp_customize->add_setting(
    'footer_area_copyrighttext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Copyright @ 2024 Expert Blogger All Rights Reserved.', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'footer_area_copyrighttext',
    array(
        'settings'      => 'footer_area_copyrighttext',
        'section'       => 'footer_area',
        'type'          => 'textarea',
        'label'         => __( 'Footer Copyright Text', 'luzuk Premium' )
    )
);

// Footer  Color
lzCustomLable($wp_customize, 'footer_allcolor', 'footer_area', 'Footer Color');

addColorPalatOption($wp_customize, 'footerarea_title_color', 'footer_area', 'Title Color', '#1C1C1C');

addColorPalatOption($wp_customize, 'footerarea_text_color', 'footer_area', 'Text Color', '#8a898a');

addColorPalatOption($wp_customize, 'footerarea_icon_color', 'footer_area', 'Icon Color', '#E40000');

addColorPalatOption($wp_customize, 'footerarea_sicon_color', 'footer_area', 'Social Icon Color', '#E40000');

addColorPalatOption($wp_customize, 'footerarea_siconbghv_clr', 'footer_area', 'Social Icon Hover Color', '#E40000');

addColorPalatOption($wp_customize, 'footerarea_siconbrd_color', 'footer_area', 'Social Icon Border Color', '#7a7a7c');

addColorPalatOption($wp_customize, 'footerarea_siconbrdhvr_color', 'footer_area', 'Social Icon Border Hover Color', '#E40000');

addColorPalatOption($wp_customize, 'footerarea_menu_color', 'footer_area', 'Menu Color', '#8a898a');

addColorPalatOption($wp_customize, 'footerarea_menuhover_color', 'footer_area', 'Menu Hover Color', '#F47E00');

addColorPalatOption($wp_customize, 'footerarea_activemenu_color', 'footer_area', 'Active Menu Color', '#FABE16');

addColorPalatOption($wp_customize, 'footerarea_datext_color', 'footer_area', 'Date Text Color', '#E40000');

addColorPalatOption($wp_customize, 'FooterAreatabgColor', 'footer_area', 'Form Text BG Color', '#fff');

addColorPalatOption($wp_customize, 'FooterAreata_brdClr', 'footer_area', 'Form Border Color', '#000');

addColorPalatOption($wp_customize, 'footerarea_formtextlabel_color', 'footer_area', 'Label Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_formtext_color', 'footer_area', 'Form Text & Placeholder Text Color', '#000');

addColorPalatOption($wp_customize, 'footerarea_formbuttontext_clr', 'footer_area', 'Form Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_formbtntxthv_clr', 'footer_area', 'Form Text Hover Color', '#000');

addColorPalatOption($wp_customize, 'footerarea_formbuttonbg_clr', 'footer_area', 'Form Button BG Color', '#E40000');

addColorPalatOption($wp_customize, 'footerarea_copytxtclr', 'footer_area', 'Copyright Text Color', '#636363');

lzCustomLable($wp_customize, 'footerarea_imgdisplay', 'footer_area' , 'Image Setting');


//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'luzuk_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'luzuk_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show', 'hide' => 'Hide', ), ) ); 
// end to show & hide button

$wp_customize->add_section(
	'luzuk_innerpageshortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

   $wp_customize->add_setting('luzuk_premium_colorsetting_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_colorsetting_section_lbl',
        array(
            'settings'      => 'luzuk_premium_colorsetting_section_lbl',
            'section'       => 'luzuk_innerpageshortcode_page_settings',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);


$wp_customize->add_section(
	'luzuk_innerpagefont_settings',
	array(
		'title' => __( 'Inner Page Settings', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

   $wp_customize->add_setting('luzuk_premium_innerpage_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_innerpage_section_lbl',
        array(
            'settings'      => 'luzuk_premium_innerpage_section_lbl',
            'section'       => 'luzuk_innerpagefont_settings',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);