<?php
/**
 * Createing a bog pannel for customizer
 *
 *
 */
$categories = get_categories(array('hide_empty' => 0));
foreach ($categories as $category) {
	$cat[$category->term_id] = $category->cat_name;
}
/****************************/
// START BLOG SECTION FOR HOME PAGE
/*============BLOG PANEL============*/
$wp_customize->add_section(
	'blog_area',
	array(
		'title' => __( 'Blog Section', 'luzuk-premium' ),
		'panel' => 'luzuk_premium_home_panel',
     	//'priority' => '50',
	)
);
//ENABLE/DISABLE BLOG SECTION
$wp_customize->add_setting(
	'blog_section_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'blog_section_disable',
		array(
			'settings'      => 'blog_section_disable',
			'section'       => 'blog_area',
			'label'         => __( 'Disable Section', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk-premium' ),
				'off' => __( 'No', 'luzuk-premium' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'blog', 'blog_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'blog_area_blogsectionpadding', 'blog_area', 'Section Padding');

$wp_customize->add_setting(
    'blog_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_areaTpadding',
    array(
        'settings'      => 'blog_areaTpadding',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Top ', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'blog_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_areaBpadding',
    array(
        'settings'      => 'blog_areaBpadding',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);


lzCustomLable($wp_customize, 'blog_area_blogspost', 'blog_area', 'Number Of Post ');
//BLOG SETTINGS
$wp_customize->add_setting(
	'blog_post_count',
	array(
		'default'           => '7',
		'sanitize_callback' => 'luzuk_sanitize_choices'
	)
);
$wp_customize->add_control(
	new luzuk_Dropdown_Chooser(
		$wp_customize,
		'blog_post_count',
		array(
			'settings'      => 'blog_post_count',
			'section'       => 'blog_area',
			'label'         => __( 'Number Of Post To Show', 'luzuk-premium' ),
			'choices'       => $luzuk_post_count_choice
		)
	)
);

// CREATING A BLOG SECTION IN CUSTOMIZER FOR BLOG PAGES
$wp_customize->add_section(
	'premium_blog_area',
	array(
		'title' => __( 'Blog Page Settings', 'luzuk-premium' ),
        // 'panel' => 'luzuk_premium_home_panel'
		'priority' =>19
	)
);

$wp_customize->add_setting('blog_categories_settings', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control('blog_categories_settings', array(
    'settings' => 'blog_categories_settings',
    'label'    => __('Posts on Blog Page', 'luzuk-premium'),
    'section'  => 'lpremium_blog_area',
    'type'     => 'radio',
    'choices'  => array(
        '0' => __('Excerpts','luzuk-premium'),
        '1' => __('Full Posts','luzuk-premium'),
    ),
));
// ADDING THE CATEGORY TO SELECT
$wp_customize->add_setting('luzuk_blog_categories', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Checkbox_Multiple(
		$wp_customize,
		'luzuk_blog_categories',
		array(
			'label' => __('Exclude Category From Blog Posts', 'luzuk-premium'),
			'section' => 'premium_blog_area',
			'settings' => 'luzuk_blog_categories',
			'choices' => $luzuk_cat
		)
	)
); 

lzCustomLable($wp_customize, 'blog_area_color', 'blog_area', 'Section Color Settings');

addColorPalatOption($wp_customize, 'blogarea_iconadmin_color', 'blog_area', 'Admin Text Color', '#0C0B0B');

addColorPalatOption($wp_customize, 'blogarea_iconadminbg_color', 'blog_area', 'Admin Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'blogarea_Title_color', 'blog_area', 'Title Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_text_color', 'blog_area', 'Text Color', '#4E4A4A');


lzCustomLable($wp_customize, 'luzuk_secblog_sbtnclr', 'blog_area', 'Section Button Setting');
$wp_customize->add_setting(
    'blog_button1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Continue Reading', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_button1',
    array(
        'settings'      => 'blog_button1',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'blogarea_btnarroclr', 'blog_area', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'blogarea_btntxthvclr', 'blog_area', 'Button Text Hover Color', '#F69404');

addColorPalatOption($wp_customize, 'blogarea_btnbgclr', 'blog_area', 'Button BG Color', '#F47E00');

addColorPalatOption($wp_customize, 'blogarea_btnbghvrclr', 'blog_area', 'Button BG Hover Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_btnbghvrclr', 'blog_area', 'Botton Circle Color', '#000');

lzCustomLable($wp_customize, 'blog_area_socialicon', 'blog_area', 'Section Social Icons Settings');

$wp_customize->add_setting( 'socialicon_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'socialicon_button_display', array( 'label' => 'Post social Icons Display', 'section' => 'luzuk_blogpage_settings', 'settings' => 'blog_area', 'type' => 'radio', 'choices' => array( 'show' => 'Show Social Icons', 'hide' => 'Hide Social Icons', ), ) ); 

addColorPalatOption($wp_customize, 'blogarea_shareicnclr', 'blog_area', 'Share Icon Color', '#fff');

addColorPalatOption($wp_customize, 'blogarea_shareicnbgclr', 'blog_area', 'Share BG Color', '#32AADC');

addColorPalatOption($wp_customize, 'blogarea_socialicnclr', 'blog_area', 'Social Icon Color', '#fff');

addColorPalatOption($wp_customize, 'blogarea_socialicnhvrclr', 'blog_area', 'Social Icon Hover Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_socialicnbgclr', 'blog_area', 'Social Icon BG Color', '#F47E00');

lzCustomLable($wp_customize, 'blog_area_pagination', 'blog_area', 'Section Pagination Settings');

addColorPalatOption($wp_customize, 'blogarea_paginationclr', 'blog_area', 'Pagination Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_actvpaginationclr', 'blog_area', 'Active And Hover Pagination Color', '#fff');

addColorPalatOption($wp_customize, 'blogarea_paginationbgclr', 'blog_area', 'Pagination BG Color', '#E8E8E8');

addColorPalatOption($wp_customize, 'blogarea_actvpaginationbgclr', 'blog_area', 'Active Pagination BG Color', '#000');