jQuery(document).ready(function($) {
    // Upload image button
    $('.upload-category-image-button').on('click', function(e) {
        e.preventDefault();
        var button = $(this),
            customUploader = wp.media({
                title: 'Choose Image',
                button: {
                    text: 'Use this image'
                },
                multiple: false
            }).on('select', function() {
                var attachment = customUploader.state().get('selection').first().toJSON();
                button.prev().val(attachment.url);
                button.siblings('.category-image-preview').attr('src', attachment.url).show();
            }).open();
    });
    // Remove image button
    $('.remove-category-image-button').on('click', function(e) {
        e.preventDefault();
        $(this).prevAll('input').val('');
        $(this).siblings('.category-image-preview').hide();
    });
});