<?php
/**
 * Template Name: Blog
 *
 * @package luzuk Premium
 */
get_header();   
?>
<main id="innerpage-box">
    <div class="container">
        <div class="inner_contentbox">
            <div id="blog-box" class="ht-blog-wrap innerpage-whitebox ">
                <div class="row mr-0">
                    <div class="offset-xl-1 col-xl-10">
                        <div class="row">
                        <?php
                            $current_page = max(1, get_query_var('paged'));
                            $luzuk_blog_cat_exclude = get_theme_mod('luzuk_blog_categories');
                            $luzuk_blog_cat_exclude = explode(',', $luzuk_blog_cat_exclude);
                            $excerpt = get_theme_mod('luzuk_blog_categories_settings');
                            $args = array(
                                'category__not_in' => $luzuk_blog_cat_exclude,
                                // 'page'=,
                                'paged'=> $current_page,

                            );
                            $query = new WP_Query($args);
                            if($query -> have_posts()):
                                while($query -> have_posts()) : $query -> the_post();
                                 $luzuk_image = wp_get_attachment_image_src(get_post_thumbnail_id() , 'total-blog-thumb');
                                 $img = (has_post_thumbnail())?esc_url($luzuk_image[0]):get_template_directory_uri().'/images/default.png';
                        ?>
                        <div class="inner-blog-post col-lg-4 col-md-6 col-sm-6 col-xs-12 wow zoomIn">
                            <?php 
                                $blgtxtlimit = get_theme_mod('blgtxtlimit', '150');
                            ?> 
                            <div class="inner-blogpost">
                                <div class="ht-blog-thumbnail">
                                    <a href="<?php the_permalink(); ?>">
                                        <img class="inner-blog-img" src="<?php echo $img; ?>" alt="<?php the_title(); ?>">
                                        <div class="inner-blog-overlay"></div>
                                    </a>
                                    <?php if( get_theme_mod('postdate_button_display','show' ) == 'show') :?>
                                        <div class="blog-admbx">
                                            <div class="blog-authorimg">
                                                <?php echo get_avatar(get_the_author_meta('ID'), 64); ?>
                                            </div>
                                            <div class="author-deatails">
                                                <div class="blog-author">
                                                    <?php echo get_the_author(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif ?>
                                </div>
                                <div class="inner-blogpost-info">
                                    <a href="<?php the_permalink(); ?>"><h2><?php the_title(); ?></h2></a>
                                    <div class="inner-blog-excerpt">
                                        <?php 
                                           if (has_excerpt()) {
                                                      echo get_the_excerpt();
                                              } else {
                                                  echo luzuk_excerpt(get_the_content(),$blgtxtlimit );  
                                           }
                                        ?> 
                                    </div>
                                    <div class="inner-blog-bottom-area">
                                        <?php
                                          $innerblog_btn = get_theme_mod('innerblog_btn', 'Continue Reading');
                                        ?>
                                        <?php if($innerblog_btn) { ?>
                                            <div class="blogbtn"> 
                                                <a href="<?php echo esc_url(get_permalink()); ?>">
                                                    <?php echo $innerblog_btn ?>
                                                </a>
                                            </div> 
                                        <?php }?>
                                        <div class="social-media">
                                            <?php if( get_theme_mod('socialicon_button_display','show' ) == 'show') :
                                            ?>
                                                <button type="button" class="btn share-icn"><i class="fa fa-share-alt" aria-hidden="true"></i> </button> 
                                                <div class="share-btn">
                                                    <li><a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink();?>" target="_blank" class="site-button sharp"><i class="fa fa-facebook" aria-hidden="true"></i></a></li>
                                                    <li><a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink();?>&title=<?php the_title();?>&source=<?php the_title();?>" target="_blank" class="site-button sharp"><i class="fa fa-linkedin" aria-hidden="true"></i></a></li>
                                                    <li><a href="https://twitter.com/share?url=<?php the_permalink();?>&amp;text=<?php the_title();?>" class="site-button sharp" target="_blank"><i class="fa-brands fa-x-twitter"></i></a></li>
                                                    <li><a href="https://www.instagram.com/?url=<?php the_permalink();?>" target="_blank" class="site-button sharp"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>
                                                    <div class="clearfix"></div>
                                                </div>
                                            <?php endif ?> 
                                        </div>
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                            <script type="text/javascript">
                                var title = 0;
                                jQuery(".page-template-blog-left-sidebar .inner-blogpost").each(function(){
                                  if ($(this).height() > title) { title = $(this).height(); }
                                });
                                jQuery(".page-template-blog-left-sidebar .inner-blogpost").height(title);

                                // on Resize change height

                                jQuery(window).resize(function(){
                                  jQuery(".page-template-blog-left-sidebar .inner-blogpost").height("");
                                  var title = 0;
                                  jQuery(".page-template-blog-left-sidebar .inner-blogpost").each(function(){
                                    if ($(this).height() > title) { title = $(this).height(); }
                                  });
                                  jQuery(".page-template-blog-left-sidebar .inner-blogpost").height(title);
                                });
                            </script>
                      </div> 
               <?php
                   endwhile;
                endif;
                wp_reset_postdata();
                ?>
            </div>
              <div class="clearfix"></div>
          </div>
      </div>
    </div>
    <div class="clearfix"></div>
    <div class="row mr-0">
        <div class="col-md-12">
            <div class="pagingation">
                 <?php lzGetPagination($query);?>
            </div>
        </div>
    </div>
  <div class="clearfix"></div>
  </div>
</div>
</main>
<?php get_footer(); ?>