<?php   
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?>
<?php 
	if( get_theme_mod('sec_footerseTmargin',true) ) {
		$sec_footerseTmargin = 'padding-top:'.esc_attr(get_theme_mod('sec_footerseTmargin')).';';
	}
	if( get_theme_mod('sec_footersebottommargin',true) ) {
		$sec_footersebottommargin = 'padding-bottom:'.esc_attr(get_theme_mod('sec_footersebottommargin')).';';
	}
	if( get_theme_mod('footer_areaOpacity',true) ) {
		$footer_areaOpacity = 'opacity:'.esc_attr(get_theme_mod('footer_areaOpacity')).';';
	}

?>		
<footer class="footer-area" id="footer">
	<?php if(is_active_sidebar('luzuk-footer1') || is_active_sidebar('luzuk-footer2') || is_active_sidebar('luzuk-footer3') || is_active_sidebar('luzuk-footer4') ){ ?>
		<div class="overlay"></div>
			<div class="top-area">
				<div class="container"> 
				<div class="s-footer col-lg-3 col-md-3 col-sm-12 single-footer-1">
					<div class="single-footer single-footer-first wow zoomIn" data-wow-duration="1s" >
						<?php if(is_active_sidebar('luzuk-footer1')): 
							dynamic_sidebar('luzuk-footer1');
						endif;
						?>	
					</div>
				</div>

				<div class="s-footer col-lg-3 col-md-3 col-sm-12 single-footer-2">
					<div class="single-footer wow zoomIn" data-wow-duration="1.5s" >
						<?php if(is_active_sidebar('luzuk-footer2')): 
							dynamic_sidebar('luzuk-footer2');
						endif;
						?>	
					</div>
				</div>

				<div class="s-footer col-lg-3 col-md-3 col-sm-12 single-footer-3">
					<div class="single-footer wow zoomIn"  data-wow-duration="2s" >
						<?php if(is_active_sidebar('luzuk-footer3')): 
							dynamic_sidebar('luzuk-footer3');
						endif;
						?>	
					</div>
				</div>

				<div class="s-footer col-lg-3 col-md-3 col-sm-12 single-footer-4" >
					<div class="single-footer wow zoomIn" data-wow-duration="2.5s" >
						<?php if(is_active_sidebar('luzuk-footer4')): 
							dynamic_sidebar('luzuk-footer4');
						endif;
						?>	
					</div>
				</div>

				<div class="clearfix"></div>
			</div>
			<div class="clearfix"></div>
		</div>
	<?php } ?>

	<div class="clearfix"></div>
	
		<?php 
		if( get_theme_mod('sec_bottomareaTmargin',true) ) {
			$sec_bottomareaTmargin = 'padding-top:'.esc_attr(get_theme_mod('sec_bottomareaTmargin')).';';
		}
		if( get_theme_mod('sec_bottomareabottommargin',true) ) {
			$sec_bottomareabottommargin = 'padding-bottom:'.esc_attr(get_theme_mod('sec_bottomareabottommargin')).';';
		}
		
		?>	

			<?php 
		// Prevent direct access
		if ( ! defined( 'ABSPATH' ) ) {
			exit; // Exit if accessed directly
		}

		$footercopyright = '';
		if (function_exists('custom_theme_copyright')) {
			$footercopyright = custom_theme_copyright();
		}
 
	?>	
		<div class="bottom-area wow zoomIn" style="<?php echo esc_attr($sec_bottomareaTmargin); ?>" "<?php echo esc_attr($sec_bottomareabottommargin); ?>">
			<div class="container">

				<div class="footer-text">
					<?php if($footercopyright){ ?>
						<?php echo $footercopyright;?>
					<?php } ?>
				</div>
		</div>
	</div>
</div>
</footer><!-- #colophon -->


<script type="text/javascript">
	if(jQuery(window).width() >= 1170){
		new WOW().init();
	}
</script>
<script>
	$(window).scroll(function() {
		var height = $(window).scrollTop();
		if (height > 100) {
			$('#back2Top').fadeIn();
		} else {
			$('#back2Top').fadeOut();
		}
	});
	$(document).ready(function() {
		$("#back2Top").click(function(event) {
			event.preventDefault();
			$("html, body").animate({ scrollTop: 0 }, "slow");
			return false;
		});

	});
</script>


<?php wp_footer(); ?>
<a id="back2Top" title="Back to top" href="#"> &#10148; </a>
</body>
</html>