<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luzuk Premium
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link rel="preconnect" href="https://fonts.gstatic.com">
	<link href="https://fonts.googleapis.com/css2?family=Playfair+Display:ital,wght@0,400;0,500;0,600;0,700;0,800;0,900;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
	<link rel="preconnect" href="https://fonts.gstatic.com"> 
	<link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">

<link rel="preconnect" href="https://fonts.gstatic.com">
 
<link href="https://fonts.googleapis.com/css2?family=Allerta&display=swap" rel="stylesheet">

	<!-- <script src="<?php //echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script> -->
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>  

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="main-container">
		<!-- <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'InsideTours' ); ?></a> -->
		<div id="loading-area"><div class="la-anim-10"></div></div>
		<!-- header -->
		<!-- #masthead -->
		<header class="site-header header-transparent header mo-left header-seo">
			<div class="header-overlay"></div>
			<div class="container clearfix">
				<div class="top-bar-head">
						<div class="row row-eq-height">
					<div class="header-left col-md-3 col-sm-4 col-xs-6 logo">
				
						<div class="inside-full-height header-logo-bg">
						<div class="hl-border">
						<?php 
							if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
								$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
							}
						?>
							<!-- website logo -->
							<div class="logo-header mostion">
								<?php 
								if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
									the_custom_logo();
							else : 
								if ( is_front_page() ) : ?>
									<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
									<?php else : ?>
										<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
									<?php endif; ?>
								<?php endif; ?>
							</div> 
							<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>  
							<!-- nav toggle button -->
							<div class="resp_header_logo">
								<?php 
								if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
									the_custom_logo();
							else : 
								if ( is_front_page() ) : ?>
									<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
									<?php else : ?>
										<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
									<?php endif; ?>
									<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
								<?php endif; ?>
							</div>
							<div class="clearfix"></div>
						</div> 
					
					</div>
				</div> 
					
			<div class="col-md-9 col-sm-8 col-xs-6 header-right pd-0">
					<div class="inside-full-height">
						<?php 	
							$phone = get_theme_mod('header_phone', '012-478-787878');
						?>
							<?php if($phone){ ?>
				    <div class="header-phone">
				  		
							<div class="hd-contact">							
								<i class="fa fa-phone-square" aria-hidden="true"></i><a href="tel:<?php echo $phone;?>"><?php echo $phone ;?></a>							
								<div class="clearfix"></div>
							</div>
						
			  	 	</div>
			  	 	<div class="header-inner-border"></div>
			  	 	<?php } ?>
			  		 <div class="clearfix"></div>
	                <div class="header-menu">

						<div class="site-navigation ">
	                        <div class="hamburger-menus">
	                            <span></span>
	                            <span></span>
	                            <span></span>
	                            <span></span>
	                            <span></span>
	                            <span></span>
	                            <span></span>
	                            <span></span>
	                            <span></span>
	                        </div>
	                        <nav class="navigation">
	                            <div class="overlaybg"></div><!--  /.overlaybg -->
	                            <!-- Main Menu -->
	                            <div class="menu-wrapper">
	                                <div class="menu-content">
	                                    <?php
	                                        if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
	                                            wp_nav_menu ( array(
	                                                'menu_class' => 'mainmenu ht-clearfix',
	                                                'container'=> 'ul',
	                                                'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
	                                                'theme_location' => 'primary',  
	                                            )); 
	                                        } else {
	                                            wp_nav_menu ( array(
	                                                'menu_class' => 'mainmenu ht-clearfix',
	                                                'container'=> 'ul',
	                                                'theme_location' => 'primary',  
	                                            )); 
	                                        }
	                                    ?>
	                                </div> <!-- /.hours-content-->

	                              

								<div class="clearfix"></div>

	                            </div><!-- /.menu-wrapper --> 
	                        </nav>
	                        <div class="clearfix"></div>
	                    </div><!--  /.site-navigation -->
	                      <!-- <div class="header-inner-border"></div> -->
	                </div>


   
                	</div>
				  </div>
				  	<div class="clearfix"></div>
					</div>
				  
				<div class="clearfix"></div>
				</div>
				<div class="clearfix"></div>
			</div>			
			<div class="clearfix"></div>
		</header>
	</div>
