<?php 
    $wp_customize->add_section(
        'about_area',
        array(
            'title' => __( 'About Us Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'about_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'about_area_disable',
            array(
                'settings'      => 'about_area_disable',
                'section'       => 'about_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'about', 'about_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'aboutarea_padding', 'about_area', 'Set Section Padding:');

$wp_customize->add_setting(
    'about_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '10em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaTpadding',
    array(
        'settings'      => 'about_areaTpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'about_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaBpadding',
    array(
        'settings'      => 'about_areaBpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);

//Left Side
lzCustomLable($wp_customize, 'aboutarea_lhs2', 'about_area', 'Left Image & Circle Text Setting:');

$wp_customize->add_setting(
    'about_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_image',
        array(
            'section' => 'about_area',
            'settings' => 'about_image',
            'description' => __('Recommended Image Size: 400X600px', 'luzuk-premium')
        )
    )
);

addColorPalatOption($wp_customize, 'about_cirimghvclr', 'about_area', 'Section Circle Image Hover Border Color ', '#fe5317');


$wp_customize->add_setting(
    'about_yeartext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '30+', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_yeartext',
    array(
        'settings'      => 'about_yeartext',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Add Year', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_yearnum_color', 'about_area', 'Section Year Color ', '#fe5317');

$wp_customize->add_setting(
    'about_expertext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Year Experience', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_expertext',
    array(
        'settings'      => 'about_expertext',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Year Label', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_yeartext_color', 'about_area', 'Section Year Label Color ', '#fe5317');

addColorPalatOption($wp_customize, 'about_area_yearborder_color', 'about_area', 'Section Circle Border Color ', '#fe5317');

addColorPalatOption($wp_customize, 'about_area_yearbg_color', 'about_area', 'Section Circle Background Color ', '#fff');


//Right Side
lzCustomLable($wp_customize, 'aboutarea_rhs', 'about_area', 'Right Box Text Setting:');

$wp_customize->add_setting(
    'about_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_title_heading',
        array(
            'settings'      => 'about_title_heading',
            'section'       => 'about_area',
            'label'         => __( 'Section Heading, Sub Heading ,Text, List', 'luzuk-premium' ),
        )
    )
);    

$wp_customize->add_setting(
    'about_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'About', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_subtitle',
    array(
        'settings'      => 'about_subtitle',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Section Sub Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_secsubtitle_color', 'about_area', 'Section Sub Heading Color ', '#ff6730');
addColorPalatOption($wp_customize, 'about_area_secsubtitleborder_color', 'about_area', 'Section SubHeading Border Color ', '#ff6730');

 $wp_customize->add_setting(
    'about_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'About Us', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_title',
    array(
        'settings'      => 'about_title',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_sectitle_color', 'about_area', 'Section Heading Color ', '#001b42');

$wp_customize->add_setting(
    'about_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'With our service you can easily control all your social media accounts in one place and make them accessible to several administrators. With our auto tools, you can schedule posts for the future or have your accounts fully automated by our intelligent algorithm.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_text',
    array(
        'settings'      => 'about_text',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( 'Section Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'aboutsectxt_clr', 'about_area', 'Section Text Color ', '#9f9f9f');

$wp_customize->add_setting(
    'aboutbold_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem ipsum dolor sit amet, consectetur power.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'aboutbold_text',
    array(
        'settings'      => 'aboutbold_text',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( 'Section Title', 'luzuk-premium' )
    )
);
addColorPalatOption($wp_customize, 'about_area_sectextbold_color', 'about_area', 'Section Title Color ', '#2e4565');

 $wp_customize->add_setting(
        'about_textlist',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( '<ul><li>With our service you can easily controled.</li>
                <li>With our service you can easily controled.</li>
                <li>With our service you can easily controled.</li>
                </ul>', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'about_textlist',
        array(
            'settings'      => 'about_textlist',
            'section'       => 'about_area',
            'type'          => 'textarea',
            'label'         => __( 'Section List', 'luzuk-premium' )
        )
    );

addColorPalatOption($wp_customize, 'about_area_sectext_color', 'about_area', 'List Text Color ', '#9f9f9f');
addColorPalatOption($wp_customize, 'about_area_sectexticon_color', 'about_area', 'List Icon Color ', '#ff6730');

lzCustomLable($wp_customize, 'aboutarea_bottmbx', 'about_area', 'Section Bottom Side Image & Contain Box Setting:');
          // // to show & hide another button
 $wp_customize->add_setting( 'Bottom_box_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'Bottom_box_display', array( 'label' => 'Section Bottom Side Image & Contain Box Display', 'section' => 'about_area', 'settings' => 'Bottom_box_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Icon', 'hide' => 'Hide Icon', ), ) ); 
// // end to show & hide button

$wp_customize->add_setting(
    'about_bottom_image_heading1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_bottom_image_heading1',
        array(
            'settings'      => 'about_bottom_image_heading1',
            'section'       => 'about_area',
            'label'         => __( 'Section Bottom Left Image ', 'luzuk-premium' ),
        )
    )
);

    $wp_customize->add_setting(
    'about_bottom_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_bottom_image',
        array(
            'section' => 'about_area',
            'settings' => 'about_bottom_image',
            'description' => __('Recommended Image Size: 500X280px', 'luzuk-premium')
        )
    )
);

addColorPalatOption($wp_customize, 'about_btmimgbrdclr', 'about_area', 'Section Bottom Left Image Hover Border Color ', '#fff');


//bottom Right Box
$wp_customize->add_setting(
    'about_bottomrhs_image_heading1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_bottomrhs_image_heading1',
        array(
            'settings'      => 'about_bottomrhs_image_heading1',
            'section'       => 'about_area',
            'label'         => __( 'Section Bottom Right Image ', 'luzuk-premium' ),
        )
    )
);

    $wp_customize->add_setting(
    'about_bottomrhs_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_bottomrhs_image',
        array(
            'section' => 'about_area',
            'settings' => 'about_bottomrhs_image',
            'description' => __('Recommended Image Size: 500X280px', 'luzuk-premium')
        )
    )
);

addColorPalatOption($wp_customize, 'about_btmRhsimgbrdclr', 'about_area', 'Section Bottom Right Image Border Color ', '#fff');

lzCustomLable($wp_customize, 'about_areabtndisplay', 'about_area', 'Button Display & Text Setting:');

// to show & hide another button
$wp_customize->add_setting( 'aboutusection_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'aboutusection_button_display', array( 'label' => 'Button Display', 'section' => 'about_area', 'settings' => 'aboutusection_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) );

$wp_customize->add_setting(
    'luzuk_aboutussection_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Appointment' )
    )
);
$wp_customize->add_control(
    'luzuk_aboutussection_txt',
    array(
        'settings'      => 'luzuk_aboutussection_txt',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);
$wp_customize->add_setting('luzuk_aboutusectionlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('luzuk_aboutusectionlink',
    array(
        'settings'      => 'luzuk_aboutusectionlink',
        'section'       => 'about_area',
        'type'          => 'url',
        'label'         => __( 'Add "Button link" here', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'about_btntxtclr', 'about_area', 'Section Button Text Color ', '#fff');
addColorPalatOption($wp_customize, 'about_btntxthvclr', 'about_area', 'Section Button Text Hover Color ', '#001b42');
addColorPalatOption($wp_customize, 'about_btntxtbgclr', 'about_area', 'Section Button Background Color ', '#001b42');
addColorPalatOption($wp_customize, 'about_btntxtbghvclr', 'about_area', 'Section Button Background Hover Color ', '#ff5317');

$wp_customize->add_setting(
    'aboutbottom_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Get a Money-Back Guarantee', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'aboutbottom_title',
    array(
        'settings'      => 'aboutbottom_title',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Section Bottom Right Box Title', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_btnrhstitclr', 'about_area', 'Section Bottom Right Box Title Color ', '#fff');
addColorPalatOption($wp_customize, 'about_btnrhsbxclr', 'about_area', 'Section Bottom Right Box Background Color ', '#ff5317');

$wp_customize->add_setting(
    'aboutbottom_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem ipsum dolor sit amet, consect adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'aboutbottom_text',
    array(
        'settings'      => 'aboutbottom_text',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( 'Section Bottom Right Box Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_btnrhstxtclr', 'about_area', 'Section Bottom Right Box Text Color ', '#fff');