<?php 
$wp_customize->add_section(
    'service_area',
    array(
        'title'         => __( 'Services Section', 'Luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
$wp_customize->add_setting(
    'service_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'service_area_disable',
        array(
            'settings'      => 'service_area_disable',
            'section'       => 'service_area',
            'label'         => __( 'Disable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'service', 'service_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'luzuk_sec_servicessectionpadding', 'service_area', 'Set Section Padding:');

$wp_customize->add_setting(
    'service_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaTpadding',
    array(
        'settings'      => 'service_areaTpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Top Padding', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'service_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaBpadding',
    array(
        'settings'      => 'service_areaBpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Bottom Padding', 'luzuk-premium' )
    )
);



$wp_customize->add_setting(
    'services_maintitle_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'services_maintitle_subtitle_heading',
        array(
            'settings'      => 'services_maintitle_subtitle_heading',
            'section'       => 'service_area',
            'label'         => __( 'Section Heading & Sub Heading', 'Luzuk' ),
        )
    )
);

$wp_customize->add_setting(
    'services_subheading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Services', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'services_subheading',
    array(
        'settings'      => 'services_subheading',
        'section'       => 'service_area', 
        'type'          => 'text',
        'label'         => __( 'Section Sub Heading', 'Luzuk' )
    )
);
addColorPalatOption($wp_customize, 'ser_secsubtitleclr', 'service_area', 'Section Sub Heading Color ', '#ff5317');

addColorPalatOption($wp_customize, 'ser_secsubtitlebrdclr', 'service_area', 'Section Sub Heading Border Color ', '#ff5317');

$wp_customize->add_setting(
    'services_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'SERVICES WE PROVIDE', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'services_maintitle',
    array(
        'settings'      => 'services_maintitle',
        'section'       => 'service_area', 
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'servicearea_sectitle_color', 'service_area', 'Heading color ', '#001b42');



$wp_customize->add_setting('service_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'service_area_lbl2',
        array(
            'settings'      => 'service_area_lbl2',
            'section'       => 'service_area',
            'label'         => __( 'Note1:', 'Luzuk' ),  
            'description'   => __( 'Use Shortcode [SERVICES] to show all services in a page', 'Luzuk' ),
        )
    )
);


$wp_customize->add_setting('service_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'service_npp_heading',
        array(
            'settings'      => 'service_npp_heading',
            'section'       => 'service_area',
            'label'         => __( 'Number of services to show', 'Luzuk' ),
        )
    )
);    
$wp_customize->add_setting('service_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 2));
$wp_customize->add_control(
    'service_npp_count',
    array(
        'settings'      => 'service_npp_count',
        'section'       => 'service_area',
        'type'          => 'select',
        'label'         => __( 'Number of services to show', 'Luzuk' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

$ServiceSingleChoice[] = 'Select';

for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'services_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'services_heading'.$i,
            array(
                'settings'      => 'services_heading'.$i,
                'section'       => 'service_area',
                'label'         => __( 'Service Page', 'Luzuk' ).$i,
            )
        )
    );
    if(is_array($ServiceSingleChoice)){
        $wp_customize->add_setting(
            'services_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'services_page'.$i,
            array(
                'settings'      => 'services_page'.$i,
                'section'       => 'service_area',
                'type'=> 'select',
                'label'         => __( 'Select a service', 'Luzuk' ),
                'choices' => $ServiceSingleChoice,
            )
        );

$wp_customize->add_setting(
        'services_page_icon1'.$i,
        array(
            'default'           => 'fa fa-object-ungroup',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'services_page_icon1'.$i,
            array(
                'settings'      => 'services_page_icon1'.$i,
                'section'       => 'service_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'Luzuk' ),
            )
        )
    );



    }else{
        $wp_customize->add_setting('service_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'service_area_lbl'.$i,
                array(
                    'settings'      => 'service_area_lbl'.$i,
                    'section'       => 'service_area',
                    'label'         => __( 'Note:', 'Luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the service Page.</strong> <br/>Please add the services from "services menu" and then select services to show information.', 'Luzuk' ),
                )
            )
        );
    }
}

lzCustomLable($wp_customize, 'sersec_button', 'service_area', 'Section Color');

addColorPalatOption($wp_customize, 'services_imgbrdClr', 'service_area', 'Section Image Hover Color ', '#ff5317');
addColorPalatOption($wp_customize, 'services_icon1Color', 'service_area', 'Section Icon Color ', '#fff');
addColorPalatOption($wp_customize, 'services_iconhoverColor', 'service_area', 'Section Icon Hover Color ', '#ff5317');
addColorPalatOption($wp_customize, 'services_iconbgClr', 'service_area', 'Section Icon Background Color ', '#ff5317');
addColorPalatOption($wp_customize, 'services_iconbghvClr', 'service_area', 'Section Icon Background Hover Color ', '#001b42');
addColorPalatOption($wp_customize, 'services_iconbgbrdClr', 'service_area', 'Section Icon Box Border Color ', '#fff');
addColorPalatOption($wp_customize, 'services_iconbgbrdhvClr', 'service_area', 'Section Icon Box Border Hover Color ', '#ff5317');

addColorPalatOption($wp_customize, 'services_secnumClr', 'service_area', 'Section Number Color ', '#f5f6f7');
addColorPalatOption($wp_customize, 'services_secnumhvClr', 'service_area', 'Section Number Hover Color ', '#f0b39f');
addColorPalatOption($wp_customize, 'services_servicePageTitleColor', 'service_area', 'Section Title Color ', '#001b42');
addColorPalatOption($wp_customize, 'services_servicePageTitlehoverColor', 'service_area', 'Section Title Hover Color ', '#ff5317');
addColorPalatOption($wp_customize, 'services_SubttlColor', 'service_area', 'Section Text Color ', '#858585');

lzCustomLable($wp_customize, 'homepageservices_button_displaysets', 'service_area', 'Services Button Display, Button Text:');

// to show & hide another button
$wp_customize->add_setting( 'homepageservices_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'homepageservices_button_display', array( 'label' => 'Button Display', 'section' => 'service_area', 'settings' => 'homepageservices_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show Button', 'hide' => 'Hide Button', ), ) ); 
// end to show & hide button


$wp_customize->add_setting(
    'homepageservicesbutton',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'See More', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'homepageservicesbutton',
    array(
        'settings'      => 'homepageservicesbutton',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'sersec_btntxtclr', 'service_area', 'Section Button Text Color ', '#ff5317');