<?php  

$luzukSliderSingleChoice = getFitnessPostsType('slider');
$wp_customize->add_section(
	'slider_section',
	array(
		'title' => __( 'Slider Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel',
		'priority' =>18
	)
);
$wp_customize->add_setting(
	'slider_section_show_content',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'slider_section_show_content',
		array(
			'settings'      => 'slider_section_show_content',
			'section'       => 'slider_section',
			'label'         => __( 'Hide Title and description on Slider', 'Luzuk' ),
			'on_off_label'  => array(
				'on' => __( 'No', 'Luzuk' ),
				'off' => __( 'Yes', 'Luzuk' )
			),
		)
	)
);
$wp_customize->add_setting('slider_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Info_Text( 
		$wp_customize,
		'slider_section_lbl',
		array(
			'settings'		=> 'slider_section_lbl',
			'section'		=> 'slider_section',
			'label'			=> __( 'Note:', 'Luzuk' ),	
			'description'	=> __( 'The Page featured image works as a banner and the title & content work as a slider caption. You can add this from the Slider menu. <br/> Recommended Image Size: 1140X768', 'Luzuk' ),
		)
	)
);


lzCustomLable($wp_customize, 'slider_section_overlayop', 'slider_section', 'Section Banner Overlay & Opacity settings:');

$wp_customize->add_setting(
'sliderarea_overlay_color', array(
'default' => '#001b42',
'sanitize_callback' => 'sanitize_hex_color',
)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'sliderarea_overlay_color',array(
'settings' => 'sliderarea_overlay_color',
'section' => 'slider_section',
'label' => __( 'Apply Overlay Color', 'Luzuk' ),
'description' => __( 'The color used for the overlay in the banner.', 'luzuk-premium' ),
)
)
);


lzCustomLable($wp_customize, 'luzuk_sliderotherclrs', 'slider_section', 'Slider Colors:');

$wp_customize->add_setting(
    'slider_opacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.4', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'slider_opacity',
    array(
        'settings'      => 'slider_opacity',
        'section'       => 'slider_section',
        'type'          => 'text',
        'label'         => __( 'Section opacity', 'luzuk-premium' )
    )
);
addColorPalatOption($wp_customize, 'sliderarea_overlay_color', 'slider_section', 'Slider Overlay Color', '#001b42');
addColorPalatOption($wp_customize, 'slider_titleColor', 'slider_section', 'Slider Title Color', '#fff');
addColorPalatOption($wp_customize, 'slider_SubtitleColor', 'slider_section', 'Slider Sub Title Color', '#d7dae0');
addColorPalatOption($wp_customize, 'slider_highlightboxColor', 'slider_section', 'Slider Highlight Box Color', '#ff5317');