<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Luzuk Premium
 */
$luzuk_lite_single_breadcrumb_section = get_theme_mod('luzuk_lite_single_breadcrumb_section', '1');
$luzuk_lite_single_tags_section = get_theme_mod('luzuk_lite_single_tags_section', '1');
$luzuk_lite_authorbox_section = get_theme_mod('luzuk_lite_authorbox_section', '1');
$luzuk_lite_relatedposts_section = get_theme_mod('luzuk_lite_relatedposts_section', '1');

get_header(); ?> 
<header class="page-main-header">
    <div class="container">
        <?php the_title( '<h1 class="ht-main-title wow zoomIn">', '</h1>' ); ?>
        <div class="clearfix"></div>
    </div>
      <?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'hide') :
        ?>
        <div class="breadcrumbbox wow zoomIn">
            <div class="container">
                <div class='button'><?php luzuk_lite_the_breadcrumb(); ?></div>
            </div>
        </div>

    <?php endif ?>  
</header><!-- .entry-header -->
<main id="innerpage-box">
    <div class="container">
        <div class="inner_contentbox">
            <div class="col-md-12">
                <div id="content-box" class="innerpage-whitebox">
                    <article class="article">       
                        <?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
                        <div id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>>
                            <div class="single_post">                               
                               <!-- Start Content -->
                               <div id="content" class="post-single-content box mark-links">
                                <?php the_content(); ?>                           
                                
                                <?php if($luzuk_lite_single_tags_section == '1') { ?>
                                    <!-- Start Tags -->
                                    <div class="tags"><?php the_tags('<span class="tagtext">'.__('Tags','Luzuk Premium').':</span>',', ') ?></div>
                                    <!-- End Tags -->
                                <?php } ?>
                            </div><!-- End Content -->
                            <?php comments_template( '', true ); ?>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </article>
                </div>


<div class="clearfix"></div>
          </div>

        <!-- <div class="col-md-3">
            <div id="secondary" class="widget-area">
                <?php //dynamic_sidebar('luzuk-services-sidebar'); ?>
            </div>
        </div> -->

        <div class="clearfix"></div>

        </div>
  
  <div class="clearfix"></div>
</div>
    
    <div class="clearfix"></div>
        <!-- start -->
                <div class="contact-area" id="contact">
                    <div class="contact_gradiant "></div>
                    <?php
                        $showStatic = true;
                        for( $i = 1; $i < 3; $i++ ){
                            $url = get_theme_mod('contact_page_url_'.$i, '#');
                            $link = get_theme_mod('contact_page_link'.$i);
                            $contact_page_id = get_theme_mod('contact_page_icon'.$i); 
                            if(!empty($contact_page_id)){
                                $showStatic = false;
                                break;
                            }
                        }
                    ?>
                    <!-- <div class="container"> -->  
                        <div class="row">
                            <div class="col-md-4 col-sm-4 col-xs-12 wow zoom"></div>
                            <div class="col-md-2 col-sm-2 col-xs-12 wow zoom">
                            <?php
                                $contact_number = get_theme_mod('contact_number', '24/7');
                                $contact_text = get_theme_mod('contact_text', 'emergancy service');

                                $contact_page_maintitle = get_theme_mod('contact_page_maintitle', 'Contact With Us?');
                                $contact_address = get_theme_mod('contact_address', 'Address: <span>C42 - Downtown Los Angeles ,USA</span>');
                                $contact_mobile = get_theme_mod('contact_mobile', 'Mobile: +012 (3456) 7788');
                                $contact_mail = get_theme_mod('contact_mail', 'Mail: info@gentechtree.com');
                            ?>
                                <?php if($contact_number || $contact_text){ ?>
                                <div class="emergencybx">
                                    <div class="emergencybxinn">
                                        <div class="number"><?php echo ($contact_number);  ?></div>
                                        <p><?php echo ($contact_text);  ?></p>
                                    </div>
                                </div>
                                <?php }?>
                            </div>
                            <div class="col-md-6 col-sm-6 col-xs-12 wow zoom">
                                <div class="contact-detail">
                                    <?php if($contact_page_maintitle){ ?>
                                    <div class="section-title">
                                        <h2><?php echo ($contact_page_maintitle);  ?></h2>
                                    </div>
                                    <?php }?>
                                    <!-- <div class="section-area-text"> -->
                                        <p><?php echo ($contact_address);  ?></p>
                                        <p><a href="tel:<?php echo $contact_mobile;?>"><?php echo ($contact_mobile);  ?></a></p>
                                        <p><a href="mailto:<?php echo $contact_mail;?>"><?php echo ($contact_mail);  ?></a></p>
                                    <!-- </div> -->
                                    <div class="clearfix"></div>

                                <?php
                                  $contactbutton = get_theme_mod('contact_btn_txt', '(0080) 123-453-789'); 
                                  $contactbtnlink = get_theme_mod('contact_btnlink', '#');
                                ?> 

                                  <?php if( get_theme_mod('contact_button_display','show' ) == 'show') :
                                    ?>  
                                    <div class="contact-btn">
                                      <a href="tel:<?php echo $contactbutton;?>">      
                                        <?php echo ($contactbutton );  ?>
                                      </a></div>
                                    <?php endif ?>
                                </div>

                            </div>
                        </div>
                <div class="clearfix"></div>
                    <!-- </div> -->
                </div> 
                <!-- end -->

</main>
<?php get_footer(); ?>
