<?php   
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package luzuk Premium
 */
?>
	
<footer class="footer-area" id="footer">
	<?php
        // width 
        $c_width = get_theme_mod('footer_c_width', 'container-fluid');

        if ($c_width === 'container') {
            $c_alignment = 'container';
        } elseif ($c_width === 'container-fluid') {
            $c_alignment = 'container-fluid';
        } else {
            $text_alignment = 'container'; // Default to 'container' if the setting is invalid
        }
            
    ?>
	<?php
		$footercont = get_theme_mod('footercont', 'Quick Contact');
		$footeradd = get_theme_mod('footeradd', '20c Factory Street, Newyork, NY 10205');
		$footerph = get_theme_mod('footerph', '+(111) 123-456-787');
		$footerml = get_theme_mod('footerml', 'handyman@gmail.com');

		$facebook = get_theme_mod('f_fb', '//facebook.com/');
		$twitter = get_theme_mod('f_twitt', '//twitter.com/');
		$instagram = get_theme_mod('f_insta', '//instagram.com/');
		$linkedin = get_theme_mod('f_lin', '//linkedin.com/');				
		$youtube = get_theme_mod('f_ytb', '//youtube.com/');

		$payappimglink = get_theme_mod('payappimglink', '#');
		$pay_g_imglink = get_theme_mod('pay_g_imglink', '#');

		$footercopyright = get_theme_mod('footer_area_copyrighttext', '- All Rights Reserved -');

	?>
	<?php if(is_active_sidebar('luzuk-footer1') || is_active_sidebar('luzuk-footer2') || is_active_sidebar('luzuk-footer3')  || is_active_sidebar('luzuk-footer5') ){ ?>
		<div class="<?php echo esc_attr($c_width); ?>"> 
			<div class="fbox">
				<!-- <div class="s-footer col-lg-4 col-md-3 col-sm-6 col-xs-12 single-footer-1 ">	 -->
				<div class="row mr-0">
					<div class="footbx1 "> 	
						<div class="row mr-0 footbx1inn">		
							<div class="footbx1oly "></div>	
							<div class="s-footer single-footer-1 ">
								<div class="single-footer wow zoomIn" data-wow-duration="1s">	
									<?php if(is_active_sidebar('luzuk-footer1')): 
											dynamic_sidebar('luzuk-footer1');
										endif;
									?>	
								</div>
							</div> 
								
							<div class="s-footer single-footer-2">
								<div class="single-footer wow zoomIn" data-wow-duration="1.5s" >
									<?php if(is_active_sidebar('luzuk-footer2')): 
										dynamic_sidebar('luzuk-footer2');
									endif;
									?>	
									
								</div>
							</div>
								
							<div class="s-footer single-footer-3 ">
								<div class="single-footer wow zoomIn"  data-wow-duration="1.4s" >
									<?php if(is_active_sidebar('luzuk-footer3')): 
										dynamic_sidebar('luzuk-footer3');
									endif;
									?>	
								</div>
							</div>
						</div>
					</div>
					<?php if( $footercopyright || $footercont || $footeradd || $footerph || $footerml ){ ?>
					<div class="footbx2"> 	
						<div class="footbx2inn">
							<div class="title inner-area-title"><?php echo $footercont;?></div>

							<?php if(  $footeradd ){ ?>
							<div class="delt"> <i class="fa fa-home"> </i> <?php echo $footeradd;?>  </div>
							<?php } ?>

							<?php if(  $footerph ){ ?>
							<a class="" href="tel:<?php echo $footerph;?>"><div class="delt"> <i class="fa fa-phone"> </i> <?php echo $footerph;?>  </div> </a>
							<?php } ?>

							<?php if(  $footerml ){ ?>
							<a href="mailto:<?php echo $footerml;?>"><div class="delt"> <i class="fa fa-envelope"> </i> <?php echo $footerml;?> </div> </a> 
							<?php } ?>

							<?php if( get_theme_mod('payimg_display','show' ) == 'show') :?>
							<div class="paybx">
								
								<div class="payapp">
									<a href="<?php echo ($payappimglink);  ?>" >
									<?php 
										$payapp_image = get_theme_mod('payapp_image');
										if(!empty($payapp_image)){
											echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($payapp_image).'" class="img-responsive secondry-bg-img" />';
										}else{
											echo '<img src="'.get_template_directory_uri().'/images/f_appstore.png" class="img-responsive" />';
										}
									?>	
									</a>
								</div>

								<div class="payg_pay">
									<a href="<?php echo ($pay_g_imglink);  ?>" >
									<?php 
										$pay_g_image = get_theme_mod('pay_g_image');
										if(!empty($pay_g_image)){
											echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($pay_g_image).'" class="img-responsive secondry-bg-img" />';
										}else{
											echo '<img src="'.get_template_directory_uri().'/images/f_gpay.png" class="img-responsive" />';
										}
									?>	
									</a>
								</div>
								
							</div>
							<?php endif ?>
							

							<?php if( $facebook || $instagram || $linkedin || $twitter || $youtube){ ?>
							<div class="soc_medi">				
								<ul>
									<?php if(!empty($facebook)){ ?>
										<li><a href="<?php echo $facebook ?>" title="Facebook" target="_blank"><i class="fa fa-facebook"></i></a></li>
									<?php }?>

									<?php if(!empty($twitter)){ ?>
										<li><a href="<?php echo $twitter ?>" title="twitter" target="_blank"><i class="fa-brands fa-x-twitter"></i></a></li>
									<?php }?>

									<?php if(!empty($linkedin)){ ?>
										<li><a href="<?php echo $linkedin ?>" title="Linkedin" target="_blank"><i class="fa fa-linkedin"></i></a></li>
									<?php }?>
											
									<?php if(!empty($instagram)){ ?>
										<li><a href="<?php echo $instagram ?>" title="Instagram"  target="_blank"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>
									<?php }?>

									<?php if(!empty($youtube)){ ?>
										<li><a href="<?php echo $youtube ?>" title="Youtube"  target="_blank"><i class="fa fa-youtube-play" aria-hidden="true"></i></a></li>
									<?php }?>
								</ul>
							</div>
							<?php }?>
														
						</div>
						<?php } ?>
						<?php if( $footercopyright  ){ ?>
						<div class="bottom-area " >
							<div class="footer-text">
								<?php if($footercopyright){ ?>
										<?php echo $footercopyright;?>
								<?php } ?>
							</div>
						</div>
						<?php } ?>
					</div> 
				
			</div>
			<div class="clearfix"></div>
		</div>
	<?php } ?>
</footer>

<script type="text/javascript">
	if(jQuery(window).width() >= 1170){
		new WOW().init();
	}
</script>

<script>
	$(window).scroll(function() {
		var height = $(window).scrollTop();
		if (height > 100) {
			$('#back2Top').fadeIn();
		} else {
			$('#back2Top').fadeOut();
		}
	});
	$(document).ready(function() {
		$("#back2Top").click(function(event) {
			event.preventDefault();
			$("html, body").animate({ scrollTop: 0 }, "slow");
			return false;
		});

	});
</script> 

<?php wp_footer(); ?>

	<!-- <a id="back2Top" title="Back to top" href="#"> &#10148; </a> -->
	<div id="back2Top" title="Back to top" >
		<span class="circle">
		    <i class="fa fa-angle-double-up"></i>
		  </span>
  		<span class="movepulse"></span>
	</div>

</body>
</html>
