<?php

$wp_customize->add_panel(
	'luzuk_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'luzuk Premium')
	)
);

//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

addColorPalatOption($wp_customize, 'header_SiteTitleClr', 'title_tagline', 'Title Color', '#000');

addColorPalatOption($wp_customize, 'header_SiteTaglineClr', 'title_tagline', 'Tagline Color', '#000');

$wp_customize->add_setting( 'head_tagline_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'head_tagline_display', array( 'label' => 'Tagline Display', 'section' => 'title_tagline', 'settings' => 'head_tagline_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 


//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );


//HEADER SETTINGS
$wp_customize->add_section(
	'header_settings',
	array(
		'title' => __( 'Header Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'stickyheader_view', 'header_settings', 'Sticky Header Settings');
    //ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
    'luzuk_sticky_header_enable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'luzuk_sticky_header_enable',
        array(
            'settings'      => 'luzuk_sticky_header_enable',
            'section'       => 'header_settings',
            'label'         => __( 'Sticky Header', 'luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Enable', 'luzuk-premium' ),
                'off' => __( 'Disable', 'luzuk-premium' )
            )   
        )
    )
);


$sectionHeader = 'header_settings';


lzCustomLable($wp_customize, 'pages_logosetmaxwidth5', 'title_tagline', 'Set Logo Width & Height');

$wp_customize->add_setting(
    'pages_logoTopsetmaxwidth',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '100%', 'luzuk-premium' )

    )
);

// logo width

$wp_customize->add_control(
    'pages_logoTopsetmaxwidth',
    array(
        'settings'      => 'pages_logoTopsetmaxwidth',
        'section'       => 'title_tagline',
        'type'          => 'range',
        'label'         => __( 'Width', 'luzuk-premium' )
    )
);

// logo height

$wp_customize->add_setting(
    'pages_logoTopsetmaxheight',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoTopsetmaxheight',
    array(
        'settings'      => 'pages_logoTopsetmaxheight',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Height ', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'luzuk_headerlogo_margin', 'header_settings', 'Logo Margin');

$wp_customize->add_setting(
    'logo_logoTmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'logo_logoTmargin',
    array(
        'settings'      => 'logo_logoTmargin',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'logo_logoRmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'logo_logoRmargin',
    array(
        'settings'      => 'logo_logoRmargin',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Right', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'logo_logoBmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'logo_logoBmargin',
    array(
        'settings'      => 'logo_logoBmargin',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'logo_logoLmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'logo_logoLmargin',
    array(
        'settings'      => 'logo_logoLmargin',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Left', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'header_tpheader', $sectionHeader, 'Top Header');

$wp_customize->add_setting(
    'tpxtx',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'There are many variations of passages of Lorem Ipsum', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'tpxtx',
    array(
        'settings'      => 'tpxtx',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Top Header Text', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'emilid',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'hello@example.com', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'emilid',
    array(
        'settings'      => 'emilid',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Email Id', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'header_tpheademil_phClr', 'header_settings', 'Text & Email Color', '#fff');

addColorPalatOption($wp_customize, 'header_tpheademil_phhvClr', 'header_settings', 'Email Hover Color', '#FDA12B');


addColorPalatOption($wp_customize, 'header_logobgClr', 'header_settings', 'Top Header BG Color', '#333');

addColorPalatOption($wp_customize, 'header_mnheabgClr', 'header_settings', 'Main Header BG Color', '#fff');

lzCustomLable($wp_customize, 'header_phonesettings', $sectionHeader, 'Phone Setting');

$wp_customize->add_setting(
    'hphtxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '24/7 Emergency Care', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'hphtxt',
    array(
        'settings'      => 'hphtxt',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Header Phone Text ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'hphno',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '123 456 7890', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'hphno',
    array(
        'settings'      => 'hphno',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Header Phone Number ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'header_tpbtnphtxtClr', 'header_settings', 'Text Color', '#000');

addColorPalatOption($wp_customize, 'header_tpbtntlephnoClr', 'header_settings', 'Phone Number Color', '#FDA12B');

addColorPalatOption($wp_customize, 'header_tpbtntlephnohvClr', 'header_settings', 'Phone Number Hover Color', '#000');


lzCustomLable($wp_customize, 'header_appbtnsettings', $sectionHeader, 'Appointment Button Setting');

$wp_customize->add_setting(
    'headrbtntext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Request an', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'headrbtntext',
    array(
        'settings'      => 'headrbtntext',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Header Button Text ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'headrbtntitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Appointment', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'headrbtntitle',
    array(
        'settings'      => 'headrbtntitle',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Header Button Title ', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'header_appfrmsettings', $sectionHeader, 'Appointment Form Setting');

addColorPalatOption($wp_customize, 'header_tpappfrmbgClr', 'header_settings', 'Form BG Color', '#fff');

addColorPalatOption($wp_customize, 'header_tpbtnapptxtClr', 'header_settings', 'Text Color', '#000');

addColorPalatOption($wp_customize, 'header_tpbtntleapptitlClr', 'header_settings', 'Title Color', '#FDA12B');

addColorPalatOption($wp_customize, 'header_tpbtntleapphvClr', 'header_settings', 'Title Hover Color', '#000');

$wp_customize->add_setting(
    'h_shortcode',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '[your Shortcode]' )
    )
);
$wp_customize->add_control(
    'h_shortcode',
    array(
        'settings'      => 'h_shortcode',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Appointment Form Shortcode Here', 'luzuk Premium' )
    )
);

addColorPalatOption($wp_customize, 'hfrm_labelclr', 'header_settings', 'Form Label Color', '#000');

addColorPalatOption($wp_customize, 'hfrm_textplaceclr', 'header_settings', 'Form Text & Placeholder Color', '#000');

addColorPalatOption($wp_customize, 'hfrm_borderbottomclr', 'header_settings', 'Form Text & Placeholder Border Color', '#ccc');

addColorPalatOption($wp_customize, 'hfrm_bgClr', 'header_settings', 'Form Text & Placeholder BG Color', '#fff');

addColorPalatOption($wp_customize, 'hfrm_btnclr', 'header_settings', 'Form Button Text Color', '#000');

addColorPalatOption($wp_customize, 'hfrm_btnhoverclr', 'header_settings', 'Form Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'hfrm_btnbgclr', 'header_settings', 'Form Button BG Color', '#FDA12B');

addColorPalatOption($wp_customize, 'hfrm_btnbghvClr', 'header_settings', 'Form Button BG Hover Color', '#000');

// *******
lzCustomLable($wp_customize, 'header_MenuColorssettings', $sectionHeader, 'Navigation Color');


addColorPalatOption($wp_customize, 'header_innpagetopmenusClr', 'header_settings', 'Inner Page Menus Color', '#000');

addColorPalatOption($wp_customize, 'header_topmenusColor', 'header_settings', 'Menus Color', '#000');

addColorPalatOption($wp_customize, 'header_topmenushoverColor', 'header_settings', 'Menus Hover Color', '#FDA12B');

addColorPalatOption($wp_customize, 'header_topmenusactiveColor', 'header_settings', 'Active Menus Color', '#FDA12B');

//addColorPalatOption($wp_customize, 'header_topmenusactivebrdClr', 'header_settings', 'Active Menus Border Color', '#C69453');

addColorPalatOption($wp_customize, 'header_topsubmenusColor', 'header_settings', 'Header Sub Menus Color', '#000');

addColorPalatOption($wp_customize, 'header_topsubmenusbrdclr', 'header_settings', 'Header Sub Menus Border Color', '#f1f1f1');

addColorPalatOption($wp_customize, 'header_topsubmenushvrColor', 'header_settings', 'Sub Menus Hover & Sub Menus Active Color', '#FDA12B');

addColorPalatOption($wp_customize, 'header_submenusbgsscColor', 'header_settings', 'Dropdown Box BG Color', '#fff');


lzCustomLable($wp_customize, 'header_colorsfortabandmobview', $sectionHeader, 'Responsive Header Settings');

addColorPalatOption($wp_customize, 'header_topheadbgclr', 'header_settings', 'Header BG Color', '#fff');

addColorPalatOption($wp_customize, 'header_respnavtoggbarbgssColor', 'header_settings', 'Toggle Bar Color', '#000');

addColorPalatOption($wp_customize, 'header_respnavbsbgssColor', 'header_settings', ' Navigation Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenutitleColor', 'header_settings', 'Menus Title Color', '#000');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenutitlebgColor', 'header_settings', 'Menus Title BG Color', '#D5D5D8');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenubgColor', 'header_settings', 'Menus BG Color', '#b6b4b4');

addColorPalatOption($wp_customize, 'header_socilbgClr', 'header_settings', 'Social Icon BG Color', '#000');

// 

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'luzuk Premium'),
	'panel' => 'luzuk_general_panel',
) );


    $wp_customize->add_setting('luzuk_premium_color_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_color_section_lbl',
        array(
            'settings'      => 'luzuk_premium_color_section_lbl',
            'section'       => 'colors',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);


//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'luzuk_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'luzuk_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show', 'hide' => 'Hide', ), ) ); 


$wp_customize->add_setting(
        'luzuk_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Home', 'luzuk' )
        )
    );
    $wp_customize->add_control(
        'luzuk_breadcrumbhometxt',
        array(
            'settings'      => 'luzuk_breadcrumbhometxt',
            'section'       => 'luzuk_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here', 'luzuk' )
        )
    );

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenbxbgclr', 'luzuk_breadcrumb_settings', 'Breadcrumb Box BG Color', '#E7F5FC');

addColorPalatOption($wp_customize, 'lzk_tmp_innpg_breadcrumbcurrenbxbrdclr', 'luzuk_breadcrumb_settings', 'Breadcrumb Box Border Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlecolor', 'luzuk_breadcrumb_settings', 'Breadcrumb Box Title Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlehovercolor', 'luzuk_breadcrumb_settings', 'Breadcrumb Box Title Hover Color', '#C69453');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbtitlecolor', 'luzuk_breadcrumb_settings', 'Breadcrumb Box Current Title Color', '#000');


// end to show & hide button

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'luzuk_blogpage_settings',
	array(
		'title' => __( 'Blog Page Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);


    $wp_customize->add_setting('luzuk_premium_blog_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_blog_section_lbl',
        array(
            'settings'      => 'luzuk_premium_blog_section_lbl',
            'section'       => 'luzuk_blogpage_settings',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);



//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'footer_area',
	array(
		'title' => __( 'Footer Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

backgroundManager($wp_customize, 'footer', 'footer_area', $color='#fff', get_template_directory_uri().'/images/footerbg.jpg', 'colors');


lzCustomLable($wp_customize, 'footer_areaPadding', 'footer_area', 'Footer Padding');

$wp_customize->add_setting(
    'sec_footerseTmargin', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footerseTmargin',
    array(
        'settings'      => 'sec_footerseTmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'sec_footersebottommargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footersebottommargin',
    array(
        'settings'      => 'sec_footersebottommargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);



lzCustomLable($wp_customize, 'footerarea_conwidth', 'footer_area', 'Footer Width ');

$wp_customize->add_setting('footer_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container-fluid'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'footer_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'footer_area', // Replace with your actual section ID
    'settings' => 'footer_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );

lzCustomLable($wp_customize, 'footer_dbox', 'footer_area', 'Footer Detail Box');


$wp_customize->add_setting(
    'footercont',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Quick Contac', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'footercont',
    array(
        'settings'      => 'footercont',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Detail Box Title ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'fotr_dbxtitlclr', 'footer_area', 'Detail Box Title Color', '#000');

$wp_customize->add_setting(
    'footeradd',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '20c Factory Street, Newyork, NY 10205', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'footeradd',
    array(
        'settings'      => 'footeradd',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Address ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'footerph',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+(111) 123-456-787', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'footerph',
    array(
        'settings'      => 'footerph',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Phone Number ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'footerml',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'handyman@gmail.com', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'footerml',
    array(
        'settings'      => 'footerml',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Mail ', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'fotr_dbxphclr', 'footer_area', 'Address , Phone , Email Color', '#333');

addColorPalatOption($wp_customize, 'fotr_dbxphicnclr', 'footer_area', 'Address , Phone , Email Icon Color', '#FDA12B');

$wp_customize->add_setting( 'payimg_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'payimg_display', array( 'label' => 'App & G-pay Image Display', 'section' => 'footer_area', 'settings' => 'payimg_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 

$wp_customize->add_setting('payappimglink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('payappimglink',
    array(
        'settings'      => 'payappimglink',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'App Store Link ', 'luzuk-premium' )
    )
);


$wp_customize->add_setting('pay_g_imglink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('pay_g_imglink',
    array(
        'settings'      => 'pay_g_imglink',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Google Pay Link ', 'luzuk-premium' )
    )
);

// social media

lzCustomLable($wp_customize, 'f_appsmedia', 'footer_area', 'Social Media');

// FACEBOOK 
$wp_customize->add_setting('f_fb', array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('f_fb',
    array(
        'settings'      => 'f_fb',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Facebook Url', 'luzuk-premium' )
    )
);

// Twitter
$wp_customize->add_setting('f_twitt',array('default'=> 'https://twitter.com/','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('f_twitt',
    array(
        'settings'      => 'f_twitt',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Twitter Url', 'luzuk-premium' )
    )
);

// Instagram
$wp_customize->add_setting('f_insta',array('default'=> 'https://instagram.com/','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('f_insta',
    array(
        'settings'      => 'f_insta',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Instagram Url', 'luzuk-premium' )
    )
);

// Linkedin
$wp_customize->add_setting('f_lin', array('default'=> 'https://linkedin.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('f_lin',
    array(
        'settings'      => 'f_lin',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Linkedin Url', 'luzuk-premium' )
    )
);

// Youtobe
$wp_customize->add_setting('f_ytb', array('default'=> 'https://youtube.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('f_ytb',
    array(
        'settings'      => 'f_ytb',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Youtobe Url', 'luzuk-premium' )
    )
);


lzCustomLable($wp_customize, 'footer_copytext', 'footer_area', 'Footer Copyright Text');

$wp_customize->add_setting(
    'footer_area_copyrighttext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '- All Rights Reserved -', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'footer_area_copyrighttext',
    array(
        'settings'      => 'footer_area_copyrighttext',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Footer Copyright Text', 'luzuk Premium' )
    )
);
addColorPalatOption($wp_customize, 'footerarea_copytxtclr', 'footer_area', 'CopyRight Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_copytxtbgclr', 'footer_area', 'CopyRight Text BG Color', '#333');

addColorPalatOption($wp_customize, 'footerarea_copybxbgclr', 'footer_area', 'CopyRight Box BG Color', '#E7F5FC');

addColorPalatOption($wp_customize, 'footerarea_copybxbrdclr', 'footer_area', 'CopyRight Box Border Color', '#FDA12B');

// Footer  Color
lzCustomLable($wp_customize, 'footer_allcolor', 'footer_area', 'Footer Color');

addColorPalatOption($wp_customize, 'footerarea_imgolyclr', 'footer_area', 'Image Overlay Color', '#000');

addColorPalatOption($wp_customize, 'footerarea_title_color', 'footer_area', 'Title Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_text_color', 'footer_area', 'Text Color', '#fff');

//addColorPalatOption($wp_customize, 'footerarea_bbxtxt_clr', 'footer_area', 'Black Box Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_icon_color', 'footer_area', 'Icon Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_sicon_color', 'footer_area', 'Social Icon Color', '#FDA12B');

addColorPalatOption($wp_customize, 'footerarea_siconbghv_clr', 'footer_area', 'Social Icon Hover Color', '#000');

//addColorPalatOption($wp_customize, 'footerarea_menuicn_color', 'footer_area', 'Menu Icon Color', '#FFD159');

addColorPalatOption($wp_customize, 'footerarea_menu_color', 'footer_area', 'Menu Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_menuhover_clr', 'footer_area', 'Menu Hover Color', '#FDA12B');

addColorPalatOption($wp_customize, 'footerarea_activemenu_clr', 'footer_area', 'Active Menu Color', '#FDA12B');

addColorPalatOption($wp_customize, 'footerarea_datext_color', 'footer_area', 'Date Text Color', '#000');

addColorPalatOption($wp_customize, 'FooterAreatabgColor', 'footer_area', 'Form Text BG Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_formtextlabel_color', 'footer_area', 'Label Color', '#000');

addColorPalatOption($wp_customize, 'footerarea_formtext_color', 'footer_area', 'Form Text & Placeholder Text Color', '#bfbfbf');

addColorPalatOption($wp_customize, 'footerarea_formbuttontext_clr', 'footer_area', 'Form Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_formbtntxthv_clr', 'footer_area', 'Form Text Hover Color', '#000');

addColorPalatOption($wp_customize, 'footerarea_formbuttonbg_clr', 'footer_area', 'Form Button BG Color', '#000');

addColorPalatOption($wp_customize, 'footerarea_formbuttonbrd_clr', 'footer_area', 'Form Button BG Hover Color', '#FDA12B');

//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'luzuk_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'luzuk_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show', 'hide' => 'Hide', ), ) ); 
// end to show & hide button

$wp_customize->add_section(
	'luzuk_innerpageshortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);


    $wp_customize->add_setting('luzuk_premium_colorsetting_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_colorsetting_section_lbl',
        array(
            'settings'      => 'luzuk_premium_colorsetting_section_lbl',
            'section'       => 'luzuk_innerpageshortcode_page_settings',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);

// 
//Inner Page Width Setting
// $wp_customize->add_section( 'inn_page', array(
//     'title' => __( 'Inner Page Width Setting' , 'luzuk Premium'),
//     'panel' => 'luzuk_general_panel',
// ) );



$wp_customize->add_section(
	'luzuk_innerpagefont_settings',
	array(
		'title' => __( 'Inner Page Settings', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

$wp_customize->add_setting('luzuk_premium_innerpage_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_innerpage_section_lbl',
        array(
            'settings'      => 'luzuk_premium_innerpage_section_lbl',
            'section'       => 'luzuk_innerpagefont_settings',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);