<?php 
    $wp_customize->add_section(
        'about_area',
        array(
            'title' => __( 'About Us Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'about_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'about_area_disable',
            array(
                'settings'      => 'about_area_disable',
                'section'       => 'about_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'aboutus', 'about_area', $color='#fff', get_template_directory_uri().'/images/abtbg.png', 'color');


lzCustomLable($wp_customize, 'aboutarea_padding', 'about_area', 'Section Padding');

$wp_customize->add_setting(
    'about_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaTpadding',
    array(
        'settings'      => 'about_areaTpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'about_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaBpadding',
    array(
        'settings'      => 'about_areaBpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'abtarea_conwidth', 'about_area', 'Section Width ');

$wp_customize->add_setting('abt_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'abt_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'about_area', // Replace with your actual section ID
    'settings' => 'abt_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );

$wp_customize->add_setting(
    'about_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_title_heading',
        array(
            'settings'      => 'about_title_heading',
            'section'       => 'about_area',
            'label'         => __( ' Section Left Side', 'luzuk-premium' ),
        )
    )
);    


lzCustomLable($wp_customize, 'aboutarea_headingaling', 'about_area', 'Heading Alignment');

$wp_customize->add_setting('abt_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'left'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'abt_maintitle_align', array(
        'label'    => __( '', 'luzuk' ),
        'section'  => 'about_area', // Replace with your actual section ID
        'settings' => 'abt_maintitle_align',
        'choices'=>array(
           'left' => 'Left',
           'center' => 'Center',
           'right' => 'Right',
        )
    ) ) );

lzCustomLable($wp_customize, 'abtarea_headingcase', 'about_area', 'Heading Style');

$wp_customize->add_setting('abt_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'abt_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'about_area', // Replace with your actual section ID
    'settings' => 'abt_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Capitalize',
    )
) ) );



lzCustomLable($wp_customize, 'aboutarea_heading', 'about_area', 'Section Heading ');

$wp_customize->add_setting(
    'abt_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'About Us', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'abt_title',
    array(
        'settings'      => 'abt_title',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'about_subHeading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Home And Businesses Installation Services', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_subHeading',
    array(
        'settings'      => 'about_subHeading',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Sub Heading', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'about_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or which do not look even slightly believable.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_text',
    array(
        'settings'      => 'about_text',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( 'Section Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_secheading_clr', 'about_area', 'Heading Color ', '#000000');

addColorPalatOption($wp_customize, 'about_secsubtitle_clr', 'about_area', 'Sub Heading Color ', '#8D8D8D');

addColorPalatOption($wp_customize, 'about_area_text', 'about_area', 'Text Color', '#777777');

addColorPalatOption($wp_customize, 'about_area_Headingbxbrd', 'about_area', 'Heading Box Border Color', '#000');

addColorPalatOption($wp_customize, 'about_area_Headingbxbg', 'about_area', 'Heading Box BG Color', '#fff');


$wp_customize->add_setting('abt_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'abt_npp_heading',
        array(
            'settings'      => 'abt_npp_heading',
            'section'       => 'about_area',
            'label'         => __( 'Number Of List To Show', 'Luzuk Premium' ),
        )
    )
);    

$wp_customize->add_setting('abt_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 2));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'abt_npp_count', array(
        'label'    => __( '', 'luzuk' ),
        'section'  => 'about_area', // Replace with your actual section ID
        'settings' => 'abt_npp_count',
        'choices'=>array(1,2,3,4)
    ) ) );

//abtD PAGES
for( $i = 1; $i <= 4; $i++ ){
    $wp_customize->add_setting(
        'abt_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'abt_header'.$i,
            array(
                'settings'      => 'abt_header'.$i,
                'section'       => 'about_area',
                'label'         => __( 'List Number ', 'Luzuk Premium' ).$i
            )
        )
    );

        $wp_customize->add_setting(
        'abt_page_icon'.$i,
        array(
            'default'           => 'fa fa-shield',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'abt_page_icon'.$i,
            array(
                'settings'      => 'abt_page_icon'.$i,
                'section'       => 'about_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'Luzuk Premium' ),
            )
        )
    );

lzAddElement($wp_customize, 'abt_page_title'.$i, 'about_area', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Contact Professional');

lzAddElement($wp_customize, 'abt_page_txt'.$i, 'about_area', $type = 'text', $label="Text", $callback ='luzuk_sanitize_text', $default='There are many variations of which do not look even slightly believable.');

lzAddElement($wp_customize, 'ourabtd_page_url_'.$i, 'about_area', $type = 'text', $label="Add Page Link", $callback ='esc_url', $default='Add link here');
    
}



lzCustomLable($wp_customize, 'abtSec_listclr', 'about_area' , 'List Color');

addColorPalatOption($wp_customize, 'abt_listicnclr', 'about_area', 'List Icon Color', '#3A3A3A');

addColorPalatOption($wp_customize, 'abt_listicnbgclr', 'about_area', 'List Icon BG Color', '#EDEDED');

addColorPalatOption($wp_customize, 'abt_listtitleclr', 'about_area', 'List Title Color', '#242424');

addColorPalatOption($wp_customize, 'abt_listtxtclr', 'about_area', 'List Text Color', '#242424');


$wp_customize->add_setting(
    'abtphone',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '000 123 456 789', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'abtphone',
    array(
        'settings'      => 'abtphone',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Phone Number', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'phtxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Call For Booking', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'phtxt',
    array(
        'settings'      => 'phtxt',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Phone Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'email',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Hello@Example.Com', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'email',
    array(
        'settings'      => 'email',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Email Id', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'emtxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Send Us Email', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'emtxt',
    array(
        'settings'      => 'emtxt',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Email Text', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'abtSec_secclr', 'about_area' , 'Section Color');

addColorPalatOption($wp_customize, 'abt_phemicnclr', 'about_area', 'Phone & Email Icon Color', '#FDA12B');

addColorPalatOption($wp_customize, 'abt_phemclr', 'about_area', 'Phone & Email Color', '#333333');

addColorPalatOption($wp_customize, 'abt_phemhvclr', 'about_area', 'Phone & Email Hover Color', '#FDA12B');

addColorPalatOption($wp_customize, 'abt_phemtxtclr', 'about_area', 'Phone & Email Text Color', '#6D6D6D');

addColorPalatOption($wp_customize, 'abt_phembrdclr1', 'about_area', 'Phone & Email Top Border Color 1', '#545252');

addColorPalatOption($wp_customize, 'abt_phembrdclr2', 'about_area', 'Phone & Email Top Border Color 2', '#bcbcbc');

lzCustomLable($wp_customize, 'abtSec_btnclr', 'about_area' , 'Section Button');

$wp_customize->add_setting(
    'abtbtn_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Read More', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'abtbtn_text',
    array(
        'settings'      => 'abtbtn_text',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

$wp_customize->add_setting('abtbtnlink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('abtbtnlink',
    array(
        'settings'      => 'abtbtnlink',
        'section'       => 'about_area',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'abtdec_btntxtclr', 'about_area', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'abtdec_btntxthvclr', 'about_area', 'Button Text Hover Color', '#000');

addColorPalatOption($wp_customize, 'abtdec_btnBGclr', 'about_area', 'Button BG Color', '#333333');

addColorPalatOption($wp_customize, 'abtdec_btnicnBGclr', 'about_area', 'Button BG Hover Color', '#FDA12B');


lzCustomLable($wp_customize, 'aboutarea_rightclr', 'about_area', 'Section Right Side');

$wp_customize->add_setting(
    'about_image_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_image_heading',
        array(
            'settings'      => 'about_image_heading',
            'section'       => 'about_area',
            'label'         => __( 'First Image', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'about_image1',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_image1',
        array(
            'section' => 'about_area',
            'settings' => 'about_image1',
            'description' => __('Recommended Image Size: 400X290', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting( 'abtimg1_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'abtimg1_display', array( 'label' => 'First Image Display', 'section' => 'about_area', 'settings' => 'abtimg1_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 

lzCustomLable($wp_customize, 'aboutarea_fristimgtxtbx', 'about_area', 'First Image Text Box');

$wp_customize->add_setting(
    'yearnum',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '25', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'yearnum',
    array(
        'settings'      => 'yearnum',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Year ', 'Luzuk' )
    )
);


$wp_customize->add_setting(
    'yeartxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'years expertise', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'yeartxt',
    array(
        'settings'      => 'yeartxt',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Year Text ', 'Luzuk' )
    )
);

lzCustomLable($wp_customize, 'aboutarea_fristimgtxtbx', 'about_area', 'First Image Text Box Color');

addColorPalatOption($wp_customize, 'abtdec_txtbgimgclr1', 'about_area', 'Text Box BG Color', '#333333');

addColorPalatOption($wp_customize, 'abtdec_numimgclr1', 'about_area', 'Years Number Color', '#fff');

addColorPalatOption($wp_customize, 'abtdec_txtimgclr1', 'about_area', 'Years Text Color', '#fff');


$wp_customize->add_setting(
    'about_image_2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_image_2',
        array(
            'settings'      => 'about_image_2',
            'section'       => 'about_area',
            'label'         => __( 'Second Image', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'about_image2',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_image2',
        array(
            'section' => 'about_area',
            'settings' => 'about_image2',
            'description' => __('Recommended Image Size: 372X250', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting( 'abtimg2_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'abtimg2_display', array( 'label' => 'Second Image Display', 'section' => 'about_area', 'settings' => 'abtimg2_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 

addColorPalatOption($wp_customize, 'abtdec_imgclr2', 'about_area', 'Second Image Border Color', '#fff');



// ADDRESS GOOGLE/MSN/OTHER video IFRAME OR EMBADE CODE
$wp_customize->add_setting('luzuk_premium_abt_video_iframe_lbl', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
  new luzuk_Customize_Heading($wp_customize, 'luzuk_premium_abt_video_iframe_lbl',
    array(
      'settings'      => 'luzuk_premium_abt_video_iframe_lbl',
      'section'       => 'about_area',
      'label'         => __( 'Video Embeded Code', 'luzuk premium' ),
    )
  )
);

$wp_customize->add_setting( 'abtvdeo_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'abtvdeo_display', array( 'label' => 'Video Box Display', 'section' => 'about_area', 'settings' => 'abtvdeo_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 

// Add setting for the video URL
$wp_customize->add_setting('luzuk_premium_about_video_iframe', array(
    'default'   => '',
    'transport' => 'refresh', // or 'postMessage' for live preview
));

// Add control for the video URL
$wp_customize->add_control('luzuk_premium_about_video_iframe', array(
    'label'    => __('Video URL ', 'luzuk premium'),
    'section'  => 'about_area',
    'type'     => 'textarea', // Use 'textarea' if you need to support embed codes
    'settings' => 'luzuk_premium_about_video_iframe',
));

addColorPalatOption($wp_customize, 'abtdec_vdeobxbrdclr', 'about_area', 'Video Box Border Color', '#fff');

$wp_customize->add_setting(
    'txtnum',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '25', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'txtnum',
    array(
        'settings'      => 'txtnum',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Video Box Number ', 'Luzuk' )
    )
);


$wp_customize->add_setting(
    'n_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'World-Wide', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'n_txt',
    array(
        'settings'      => 'n_txt',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Video Box Text 1', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'n_txt2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Connections', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'n_txt2',
    array(
        'settings'      => 'n_txt2',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Video Box Text 2', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'abtdec_vbxnumclr', 'about_area', 'Video Box Number Color', '#fff');

addColorPalatOption($wp_customize, 'abtdec_vbxtxtclr', 'about_area', 'Video Box Text Color', '#fff');

addColorPalatOption($wp_customize, 'abtdec_vbxbgclr', 'about_area', 'Video Box BG Color', '#333333');