<?php
$wp_customize->add_section(
    'banner_section',
    array(
        'title' => __( 'Banner Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);

$wp_customize->add_setting(
    'banner_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'banner_section_disable',
        array(
            'settings'      => 'banner_section_disable',
            'section'       => 'banner_section',
            'label'         => __( 'Disable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            ),
        )
    )
);

BackgroundManager($wp_customize, 'banner', 'banner_section', $color='#fff', get_template_directory_uri().'/images/default.png', 'img');

lzCustomLable($wp_customize, 'sec_bannerpadding', 'banner_section', 'Section Padding');

$wp_customize->add_setting(
    'bannerTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'bannerTpadding',
    array(
        'settings'      => 'bannerTpadding',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Top', 'Luzuk' )
    )
);
$wp_customize->add_setting(
    'bannerBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'bannerBpadding',
    array(
        'settings'      => 'bannerBpadding',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'Luzuk' )
    )
);

lzCustomLable($wp_customize, 'bann1area_conwidth', 'banner_section', 'Section Width ');

$wp_customize->add_setting('bann1_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'bann1_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'banner_section', // Replace with your actual section ID
    'settings' => 'bann1_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );

// 
lzCustomLable($wp_customize, 'bann_line1', 'banner_section', 'Line 1 ');

$wp_customize->add_setting(
    'txt_1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'HIGH TECH', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'txt_1',
    array(
        'settings'      => 'txt_1',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Line 1 Text 1 ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'banner_line1txt1clr', 'banner_section', 'Line 1 Text 1 Color', '#333333'); 

lzCustomLable($wp_customize, 'bann_simg1', 'banner_section', 'Line 1 Image');

$wp_customize->add_setting(
    'bann1_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'bann1_image',
        array(
            'section' => 'banner_section',
            'settings' => 'bann1_image',
             'description' => __('Recommended Image Size: 240X65', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting( 'bannsimg_img1_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'bannsimg_img1_display', array( 'label' => '1st Image Display', 'section' => 'banner_section', 'settings' => 'bannsimg_img1_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 


$wp_customize->add_setting(
    'txt_2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'INSTALLATION & REPAIR', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'txt_2',
    array(
        'settings'      => 'txt_2',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Line 1 Text 2 ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'banner_line1txt2clr', 'banner_section', 'Line 1 Text 2 Color', '#333333'); 

addColorPalatOption($wp_customize, 'banner_line1txtbrdclr', 'banner_section', 'Line 1 Text 2 Border Color', '#FDA12B'); 
// 
lzCustomLable($wp_customize, 'bann_line2', 'banner_section', 'Line 2 ');

lzCustomLable($wp_customize, 'bann_simg2', 'banner_section', 'Line 2 Image');

$wp_customize->add_setting(
    'bann2_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'bann2_image',
        array(
            'section' => 'banner_section',
            'settings' => 'bann2_image',
             'description' => __('Recommended Image Size: 240X65', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting( 'bannsimg_img2_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'bannsimg_img2_display', array( 'label' => '2nd Image Display', 'section' => 'banner_section', 'settings' => 'bannsimg_img2_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) );


$wp_customize->add_setting(
    'f2txt_1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'SERVICES BY PROFESSIONAL', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'f2txt_1',
    array(
        'settings'      => 'f2txt_1',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Line 2 Text ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'banner_line2txt2clr', 'banner_section', 'Line 2 Text Color', '#BEBEBE');

$wp_customize->add_setting( 'bannsicn_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'bannsicn_display', array( 'label' => 'Icon Display', 'section' => 'banner_section', 'settings' => 'bannsicn_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 

addColorPalatOption($wp_customize, 'banner_line2icnclr', 'banner_section', 'Line 2 Icon Color', '#fff');

addColorPalatOption($wp_customize, 'banner_line2icnbgclr', 'banner_section', 'Line 2 Icon BG Color', '#000');

// 
lzCustomLable($wp_customize, 'bann_line3', 'banner_section', 'Line 3 ');


$wp_customize->add_setting(
    'f3txt_1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'TECHNICIANS, AND DESIGNERS', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'f3txt_1',
    array(
        'settings'      => 'f3txt_1',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Line 3 Text ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'banner_line3txtclr', 'banner_section', 'Line 3 Text Color', '#333');

addColorPalatOption($wp_customize, 'banner_line3txtbrdclr', 'banner_section', 'Line 3 Text Border Color', '#FDA12B'); 

lzCustomLable($wp_customize, 'bann_simg3', 'banner_section', 'Line 3 Image');

$wp_customize->add_setting(
    'bann3_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'bann3_image',
        array(
            'section' => 'banner_section',
            'settings' => 'bann3_image',
             'description' => __('Recommended Image Size: 240X65', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting( 'bannsimg_img3_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'bannsimg_img3_display', array( 'label' => '3rd Image Display', 'section' => 'banner_section', 'settings' => 'bannsimg_img3_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 


// 
lzCustomLable($wp_customize, 'bann_line4', 'banner_section', 'Line 4 ');


$wp_customize->add_setting(
    'f4txt_1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'FOR COMPLETE', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'f4txt_1',
    array(
        'settings'      => 'f4txt_1',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Line 4 Text 1', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'banner_line4txt1clr', 'banner_section', 'Line 4 Text 1 Color', '#BEBEBE');


$wp_customize->add_setting(
    'f4txt_2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'NEEDS', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'f4txt_2',
    array(
        'settings'      => 'f4txt_2',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Line 4 Text 2', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'banner_line4txt2clr', 'banner_section', 'Line 4 Text 2 Color', '#333');

lzCustomLable($wp_customize, 'bann_line4img', 'banner_section', 'Line 4 Image');

$wp_customize->add_setting( 'bannsimg_img4_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'bannsimg_img4_display', array( 'label' => 'Line 4 Image Display', 'section' => 'banner_section', 'settings' => 'bannsimg_img4_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 