<?php 

    $wp_customize->add_section(
        'banner2_area',
        array(
            'title' => __( 'Banner 2 Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );

    $wp_customize->add_setting(
        'banner2_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'banner2_area_disable',
            array(
                'settings'      => 'banner2_area_disable',
                'section'       => 'banner2_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'banner2us', 'banner2_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'banner2area_padding', 'banner2_area', 'Section Padding');

$wp_customize->add_setting(
    'banner2_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'banner2_areaTpadding',
    array(
        'settings'      => 'banner2_areaTpadding',
        'section'       => 'banner2_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'banner2_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'banner2_areaBpadding',
    array(
        'settings'      => 'banner2_areaBpadding',
        'section'       => 'banner2_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'banner2area_conwidth', 'banner2_area', 'Section Width ');

$wp_customize->add_setting('bann2_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'bann2_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'banner2_area', // Replace with your actual section ID
    'settings' => 'bann2_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


backgroundManager($wp_customize, 'banner2inn', 'banner2_area', $color='#fff', get_template_directory_uri().'/images/bannbg2.jpg', 'color');

lzCustomLable($wp_customize, 'bn2Sec_opcityclr', 'banner2_area' , 'Section Opacity');

$wp_customize->add_setting(
    'banner2_opacity2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.4', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'banner2_opacity2',
    array(
        'settings'      => 'banner2_opacity2',
        'section'       => 'banner2_area',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);
addColorPalatOption($wp_customize, 'bn2sec_opcityclr', 'banner2_area', ' Overlay Color', '#333');

lzCustomLable($wp_customize, 'banner2area_title', 'banner2_area', 'Section Title');

$wp_customize->add_setting(
    'bann2_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Reliable', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'bann2_title',
    array(
        'settings'      => 'bann2_title',
        'section'       => 'banner2_area',
        'type'          => 'text',
        'label'         => __( 'Title ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'bann2_hightitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Handyman', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'bann2_hightitle',
    array(
        'settings'      => 'bann2_hightitle',
        'section'       => 'banner2_area',
        'type'          => 'text',
        'label'         => __( 'Highlight Title ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'bann2_sometitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Services For', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'bann2_sometitle',
    array(
        'settings'      => 'bann2_sometitle',
        'section'       => 'banner2_area',
        'type'          => 'text',
        'label'         => __( 'Other Title', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'bann2_extratitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Every Job, Big Or Small', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'bann2_extratitle',
    array(
        'settings'      => 'bann2_extratitle',
        'section'       => 'banner2_area',
        'type'          => 'text',
        'label'         => __( 'Next Line Title ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'bn2sec_titleclr', 'banner2_area', ' Title Color', '#fff');

addColorPalatOption($wp_customize, 'bn2sec_hightitleclr', 'banner2_area', ' Highlight Title Color', '#FDA12B');

$wp_customize->add_setting(
    'bann2_txtno1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '483000+', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'bann2_txtno1',
    array(
        'settings'      => 'bann2_txtno1',
        'section'       => 'banner2_area',
        'type'          => 'text',
        'label'         => __( 'Download Number ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'bann2_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'App Download In 2024', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'bann2_txt',
    array(
        'settings'      => 'bann2_txt',
        'section'       => 'banner2_area',
        'type'          => 'text',
        'label'         => __( 'Download Text', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'bann2_txtno2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '30000+', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'bann2_txtno2',
    array(
        'settings'      => 'bann2_txtno2',
        'section'       => 'banner2_area',
        'type'          => 'text',
        'label'         => __( 'User Number ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'bann2_txt2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'App Download In 2024', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'bann2_txt2',
    array(
        'settings'      => 'bann2_txt2',
        'section'       => 'banner2_area',
        'type'          => 'text',
        'label'         => __( 'User Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'bn2sec_txtclr', 'banner2_area', ' Text Color', '#fff');

lzCustomLable($wp_customize, 'banner2_vdeobtnclr', 'banner2_area' , 'Video Button ');

$wp_customize->add_setting('luzuk_bann2_vb_embade', array(/*'sanitize_callback' => 'esc_url_raw',*/ 'default'=>'Add your video embade code'));

$wp_customize->add_control('luzuk_bann2_vb_embade', array('settings'=>'luzuk_bann2_vb_embade', 'section'=>'banner2_area','type'=>'textarea', 'label'=> __('Iframe Code For Video', 'luzuk premium')));

$wp_customize->add_setting(
    'bann2vbt_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Tap To Play', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'bann2vbt_text',
    array(
        'settings'      => 'bann2vbt_text',
        'section'       => 'banner2_area',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'bn2sec_btntxtclr', 'banner2_area', 'Button Text Color', '#000');

addColorPalatOption($wp_customize, 'bn2sec_btntxthvclr', 'banner2_area', 'Button Text Hover Color', '#FDA12B');

addColorPalatOption($wp_customize, 'bn2sec_btnbgclr', 'banner2_area', 'Button BG Color', '#fff');

addColorPalatOption($wp_customize, 'bn2sec_btnbghvclr', 'banner2_area', 'Button BG Hover Color', '#000');

addColorPalatOption($wp_customize, 'bn2sec_btnicnclr', 'banner2_area', 'Button Icon Color', '#fff');

addColorPalatOption($wp_customize, 'bn2sec_btnicnbgclr', 'banner2_area', 'Button Icon BG Color', '#FDA12B');

// rhs

lzCustomLable($wp_customize, 'banner2sec_right', 'banner2_area', 'Section Right Side');

$wp_customize->add_setting(
    'img_ttle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Get Our App', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'img_ttle',
    array(
        'settings'      => 'img_ttle',
        'section'       => 'banner2_area',
        'type'          => 'text',
        'label'         => __( 'Box Title', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'bn2sec_appbxtitleclr', 'banner2_area', 'Box Title Color', '#333333');

addColorPalatOption($wp_customize, 'bn2sec_appbxbrdclr', 'banner2_area', 'Box Border Color', '#f2f2f2');

addColorPalatOption($wp_customize, 'bn2sec_appbxbgclr', 'banner2_area', 'Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'bn2sec_appbxcornerclr', 'banner2_area', 'Box BG Corner Color', '#f2f2f2');


lzCustomLable($wp_customize, 'aboutarea_qr', 'banner2_area', 'QR Image');

$wp_customize->add_setting(
    'qr_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'qr_image',
        array(
            'section' => 'banner2_area',
            'settings' => 'qr_image',
            'description' => __('Recommended Image Size: 200X200', 'luzuk-premium')
        )
    )
);
$wp_customize->add_setting( 'qrimg2_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'qrimg2_display', array( 'label' => 'Apple Image Display', 'section' => 'banner2_area', 'settings' => 'qrimg2_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 
addColorPalatOption($wp_customize, 'bn2sec_qrimgbgclr', 'banner2_area', 'QR Image BG Color', '#E7F5FC');




$wp_customize->add_setting('bann2apleimglink1',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('bann2apleimglink1',
    array(
        'settings'      => 'bann2apleimglink1',
        'section'       => 'banner2_area',
        'type'          => 'url',
        'label'         => __( 'Apple Link ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting( 'appleimg2_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'appleimg2_display', array( 'label' => 'Apple Image Display', 'section' => 'banner2_area', 'settings' => 'appleimg2_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 


$wp_customize->add_setting('bann2gpyimglink2',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('bann2gpyimglink2',
    array(
        'settings'      => 'bann2gpyimglink2',
        'section'       => 'banner2_area',
        'type'          => 'url',
        'label'         => __( 'Gpay Link ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting( 'Gpayimg2_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'Gpayimg2_display', array( 'label' => 'Gpay Image Display', 'section' => 'banner2_area', 'settings' => 'Gpayimg2_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 