<?php
/**
 * Createing a bog pannel for customizer
 *
 */
$categories = get_categories(array('hide_empty' => 0));
foreach ($categories as $category) {
	$cat[$category->term_id] = $category->cat_name;
}
/****************************/
// START BLOG SECTION FOR HOME PAGE
/*============BLOG PANEL============*/
$wp_customize->add_section(
	'blog_area',
	array(
		'title' => __( 'Blog Section', 'luzuk-premium' ),
		'panel' => 'luzuk_premium_home_panel',
     	//'priority' => '50',
	)
);
//ENABLE/DISABLE BLOG SECTION
$wp_customize->add_setting(
	'blog_section_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'blog_section_disable',
		array(
			'settings'      => 'blog_section_disable',
			'section'       => 'blog_area',
			'label'         => __( 'Disable Section', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk-premium' ),
				'off' => __( 'No', 'luzuk-premium' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'blog', 'blog_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'blog_area_blogsectionpadding', 'blog_area', 'Section Padding');

$wp_customize->add_setting(
    'blog_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_areaTpadding',
    array(
        'settings'      => 'blog_areaTpadding',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Top ', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'blog_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_areaBpadding',
    array(
        'settings'      => 'blog_areaBpadding',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'blogarea_conwidth', 'blog_area', 'Section Width ');

$wp_customize->add_setting('blog_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'blog_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'blog_area', // Replace with your actual section ID
    'settings' => 'blog_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


lzCustomLable($wp_customize, 'blogearea_headingaling', 'blog_area', 'Heading Alignment ');

$wp_customize->add_setting('blog_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'left'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'blog_maintitle_align', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'blog_area', // Replace with your actual section ID
    'settings' => 'blog_maintitle_align',
    'choices'=>array(
       'left' => 'Left',
       'center' => 'Center',
       'right' => 'Right',
    )
) ) );

lzCustomLable($wp_customize, 'blogarea_headingcase', 'blog_area', 'Heading Style');

$wp_customize->add_setting('blog_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'blog_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'blog_area', // Replace with your actual section ID
    'settings' => 'blog_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Uapitalize',
    )
) ) );


$wp_customize->add_setting(
	'blog_title_subtitle_heading',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text'
	)
);
$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'blog_title_subtitle_heading',
		array(
			'settings'		=> 'blog_title_subtitle_heading',
			'section'       => 'blog_area',
			'label'         => __( 'Section Heading', 'luzuk-premium' ),
		)
	)
);



$wp_customize->add_setting(
	'blog_title2',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Our Blog', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'blog_title2',
	array(
		'settings'      => 'blog_title2',
		'section'       => 'blog_area',
		'type'          => 'text',
		'label'         => __( ' Heading', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
    'blog_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'There Are Many Variations Passages Ipsum Available.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_subtitle',
    array(
        'settings'      => 'blog_subtitle',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Sub Heading ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'blog_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or which do not look even slightly believable.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_txt',
    array(
        'settings'      => 'blog_txt',
        'section'       => 'blog_area',
        'type'          => 'textarea',
        'label'         => __( 'Text ', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'blog_Heading', 'blog_area', 'Heading Color', '#000');

addColorPalatOption($wp_customize, 'blog_subHeading', 'blog_area', 'Sub Heading Color', '#8D8D8D');

addColorPalatOption($wp_customize, 'blog_subHeadtxt', 'blog_area', 'Text Color', '#333');

addColorPalatOption($wp_customize, 'blog_Headingbxbrd', 'blog_area', 'Heading Box Border Color', '#000');

addColorPalatOption($wp_customize, 'blog_Headingbxbg', 'blog_area', 'Heading Box BG Color', '#E7F5FC');

$wp_customize->add_setting('blog_post_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'blog_post_heading',
        array(
            'settings'      => 'blog_post_heading',
            'section'       => 'blog_area',
            'label'         => __( 'Number Of Post To Show', 'Luzuk Premium' ),
        )
    )
);    

$wp_customize->add_setting('blog_post_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'blog_post_count', array(
        'label'    => __( '', 'luzuk' ),
        'section'  => 'blog_area', // Replace with your actual section ID
        'settings' => 'blog_post_count',
        'choices'       => $luzuk_post_count_choice
    ) ) );


// CREATING A BLOG SECTION IN CUSTOMIZER FOR BLOG PAGES
$wp_customize->add_section(
	'premium_blog_area',
	array(
		'title' => __( 'Blog Page Settings', 'luzuk-premium' ),
        // 'panel' => 'luzuk_premium_home_panel'
		'priority' =>19
	)
);

$wp_customize->add_setting('blog_categories_settings', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control('blog_categories_settings', array(
    'settings' => 'blog_categories_settings',
    'label'    => __('Posts on Blog Page', 'luzuk-premium'),
    'section'  => 'lpremium_blog_area',
    'type'     => 'radio',
    'choices'  => array(
        '0' => __('Excerpts','luzuk-premium'),
        '1' => __('Full Posts','luzuk-premium'),
    ),
));
// ADDING THE CATEGORY TO SELECT
$wp_customize->add_setting('luzuk_blog_categories', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Checkbox_Multiple(
		$wp_customize,
		'luzuk_blog_categories',
		array(
			'label' => __('Exclude Category From Blog Posts', 'luzuk-premium'),
			'section' => 'premium_blog_area',
			'settings' => 'luzuk_blog_categories',
			'choices' => $luzuk_cat
		)
	)
);


lzCustomLable($wp_customize, 'blog_area_clr', 'blog_area', 'Section Color');


addColorPalatOption($wp_customize, 'blogarea_datebxtxtclr', 'blog_area', 'Date Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_datebgclr', 'blog_area', 'Date BG Color', '#f6f6f6');

addColorPalatOption($wp_customize, 'blogarea_conbgclr', 'blog_area', 'Conten Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'blogarea_Title_color', 'blog_area', 'Title Color', '#333');

addColorPalatOption($wp_customize, 'blogarea_Titlehv_clr', 'blog_area', 'Title Hover Color', '#FDA12B');

addColorPalatOption($wp_customize, 'blogarea_textclr', 'blog_area', 'Text Color', '#9E9E9E');

lzCustomLable($wp_customize, 'blog_area_btnclr', 'blog_area' , 'Section Button');

$wp_customize->add_setting(
    'blogbtn_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Read More', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'blogbtn_text',
    array(
        'settings'      => 'blogbtn_text',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'blogsec_btnt2xtclr', 'blog_area', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'blogsec_btnt2xthvclr', 'blog_area', 'Button Text Hover Color', '#000');

addColorPalatOption($wp_customize, 'blogsec_btn2BGclr', 'blog_area', 'Button BG Color', '#373434');

addColorPalatOption($wp_customize, 'blogsec_btn2icnBGclr', 'blog_area', 'Button BG Hover Color', '#FDA12B');