<?php

// START APPOINTMENT SECTION 
$section = 'faq_section';
$wp_customize->add_section(
	$section,
	array(
		'title'   => __( 'Faq Section', 'Luzuk' ),
		'panel'   => 'luzuk_premium_home_panel',
	)
);
$wp_customize->add_setting(
    'faq_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'faq_section_disable',
        array(
            'settings'      => 'faq_section_disable',
            'section'       => $section,
            'label'         => __( 'Disable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'faq_sec', $section, $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'faq_sectionnpadding', 'faq_section', 'Section Padding');

$wp_customize->add_setting(
    'faqsec_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'faqsec_toppadding',
    array(
        'settings'      => 'faqsec_toppadding',
        'section'       => 'faq_section',
        'type'          => 'text',
        'label'         => __( 'Top ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'faqsec_bpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'faqsec_bpadding',
    array(
        'settings'      => 'faqsec_bpadding',
        'section'       => 'faq_section',
        'type'          => 'text',
        'label'         => __( 'Bottom ', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'faqarea_conwidth', 'faq_section', 'Section Width ');

$wp_customize->add_setting('faq_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'faq_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'faq_section', // Replace with your actual section ID
    'settings' => 'faq_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


lzCustomLable($wp_customize, 'faqearea_headingaling', 'faq_section', 'Heading Alignment ');

$wp_customize->add_setting('faq_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'center'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'faq_maintitle_align', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'faq_section', // Replace with your actual section ID
    'settings' => 'faq_maintitle_align',
    'choices'=>array(
       'left' => 'Left',
       'center' => 'Center',
       'right' => 'Right',
    )
) ) );

lzCustomLable($wp_customize, 'faqarea_headingcase', 'faq_section', 'Heading Style');

$wp_customize->add_setting('faq_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'faq_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'faq_section', // Replace with your actual section ID
    'settings' => 'faq_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Capitalize',
    )
) ) );


lzCustomLable($wp_customize, 'faq_lhsbx', 'faq_section', 'Section Heading ');


$wp_customize->add_setting(
    'faq_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Repair & Installation' )
    )
);
$wp_customize->add_control(
    'faq_subtitle',
    array(
        'settings'      => 'faq_subtitle',
        'section'       => 'faq_section',
        'type'          => 'text',
        'label'         => __( 'Sub Heading', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'faqsec_subhedingClr', 'faq_section', 'Sub Heading Color', '#848484');


$wp_customize->add_setting(
    'faq_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Freqently Asked Questions' )
    )
);
$wp_customize->add_control(
    'faq_title',
    array(
        'settings'      => 'faq_title',
        'section'       => 'faq_section',
        'type'          => 'text',
        'label'         => __( 'Heading', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'faqsec_hedingClr', 'faq_section', 'Heading Color', '#000');

lzCustomLable($wp_customize, 'faq_secOddclr', 'faq_section', 'Section Color ');

addColorPalatOption($wp_customize, 'faqsec_titleColor', 'faq_section', 'Select Question Text Color', '#343434');

addColorPalatOption($wp_customize, 'faqsec_titleboxbrdClr', 'faq_section', 'Question Box Border Color', '#f1f1f1');

addColorPalatOption($wp_customize, 'faqsec_titleboxbgClr', 'faq_section', 'Question Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'faqsec_titleboxbghvClr', 'faq_section', 'Question Box BG Active Color', '#E5F3FA');

addColorPalatOption($wp_customize, 'faqsec_titleIconClr', 'faq_section', 'Question Icon Color', '#000');

addColorPalatOption($wp_customize, 'faqsec_titleIcnbgClr', 'faq_section', 'Question Icon BG Color', '#E5F3FA');

addColorPalatOption($wp_customize, 'faqsec_texbgClr', 'faq_section', 'Select Answer Text BG Color', '#F9F9F9');

addColorPalatOption($wp_customize, 'faqsec_textcColor', 'faq_section', 'Select Answer Text Color', '#2a2a2a');


