<?php  

$wp_customize->add_section(
    'feature_area',
    array(
        'title' => __('Feature Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
  // ENABLE/DISABLE FEATURED SECTION
    $wp_customize->add_setting(
        'feature_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'feature_area_disable',
            array(
                'settings'      => 'feature_area_disable',
                'section'       => 'feature_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    );

backgroundManager($wp_customize, 'feature', 'feature_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'featuresection_padding', 'feature_area', ' Section Padding ');

$wp_customize->add_setting(
    'feature_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'feature_areaTpadding',
    array(
        'settings'      => 'feature_areaTpadding',
        'section'       => 'feature_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'feature_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'feature_areaBpadding',
    array(
        'settings'      => 'feature_areaBpadding',
        'section'       => 'feature_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'feaearea_conwidth', 'feature_area', 'Section Width ');

$wp_customize->add_setting('fea_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'fea_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'feature_area', // Replace with your actual section ID
    'settings' => 'fea_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


lzCustomLable($wp_customize, 'featarea_headingaling', 'feature_area', 'Heading Alignment');

$wp_customize->add_setting('fea_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'left'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'fea_maintitle_align', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'feature_area', // Replace with your actual section ID
    'settings' => 'fea_maintitle_align',
    'choices'=>array(
       'left' => 'Left',
       'center' => 'Center',
       'right' => 'Right',
    )
) ) );

lzCustomLable($wp_customize, 'featarea_headingcase', 'feature_area', 'Heading Style');

$wp_customize->add_setting('fea_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'fea_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'feature_area', // Replace with your actual section ID
    'settings' => 'fea_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Capitalize',
    )
) ) );

$wp_customize->add_setting(
    'feature_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'feature_title_heading',
        array(
            'settings'      => 'feature_title_heading',
            'section'       => 'feature_area',
            'label'         => __( 'Section Heading', 'luzuk-premium' ),
        )
    )
);


$wp_customize->add_setting(
    'fea_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Why People trust Us', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'fea_title',
    array(
        'settings'      => 'fea_title',
        'section'       => 'feature_area',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'fea_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Why We Best', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'fea_subtitle',
    array(
        'settings'      => 'fea_subtitle',
        'section'       => 'feature_area',
        'type'          => 'text',
        'label'         => __( 'Sub Heading ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'fea_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or which do not look even slightly believable.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'fea_txt',
    array(
        'settings'      => 'fea_txt',
        'section'       => 'feature_area',
        'type'          => 'textarea',
        'label'         => __( 'Text ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'feature_Heading', 'feature_area', 'Heading Color', '#000');

addColorPalatOption($wp_customize, 'feature_subHeading', 'feature_area', 'Sub Heading Color', '#8D8D8D');

addColorPalatOption($wp_customize, 'feature_subHeadtxt', 'feature_area', 'Text Color', '#333');

addColorPalatOption($wp_customize, 'feature_Headingbxbrd', 'feature_area', 'Heading Box Border Color', '#000');

addColorPalatOption($wp_customize, 'feature_Headingbxbg1', 'feature_area', 'Heading Box BG Color', '#E7F5FC');


$wp_customize->add_setting(
    'f_phone',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+00 12 3456 789', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'f_phone',
    array(
        'settings'      => 'f_phone',
        'section'       => 'feature_area',
        'type'          => 'text',
        'label'         => __( 'Phone Number 1 ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'f_2phone',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+00 12 3456 780', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'f_2phone',
    array(
        'settings'      => 'f_2phone',
        'section'       => 'feature_area',
        'type'          => 'text',
        'label'         => __( 'Phone Number 2 ', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'f_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Book Your First Service & Get 30% Off', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'f_txt',
    array(
        'settings'      => 'f_txt',
        'section'       => 'feature_area',
        'type'          => 'text',
        'label'         => __( 'Box Text ', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'f_btn',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Book Now', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'f_btn',
    array(
        'settings'      => 'f_btn',
        'section'       => 'feature_area',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

$wp_customize->add_setting('f_btnlink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('f_btnlink',
    array(
        'settings'      => 'f_btnlink',
        'section'       => 'feature_area',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'feature_phbxBGClr', 'feature_area', 'Phone Box BG Color', '#FDA12B');

addColorPalatOption($wp_customize, 'feature_phnoClr', 'feature_area', 'Phone Number Color', '#E5F3FA');

addColorPalatOption($wp_customize, 'feature_phnohvClr', 'feature_area', 'Phone Number Hover Color', '#000');

addColorPalatOption($wp_customize, 'feature_phtxtClr', 'feature_area', 'Text Color', '#E5F3FA');

addColorPalatOption($wp_customize, 'feature_btnxtClr', 'feature_area', 'Button Text Color', '#333');

addColorPalatOption($wp_customize, 'feature_btnxthvClr', 'feature_area', 'Button Text Hover Color', '#FDA12B');

addColorPalatOption($wp_customize, 'feature_btnbgClr', 'feature_area', 'Button BG Color', '#fff');

addColorPalatOption($wp_customize, 'feature_btnbghvClr', 'feature_area', 'Button BG Hover Color', '#000');

$wp_customize->add_setting('feature_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'feature_npp_heading',
        array(
            'settings'      => 'feature_npp_heading',
            'section'       => 'feature_area',
            'label'         => __( 'Number Of Feature To Show', 'Luzuk Premium' ),
        )
    )
);    

$wp_customize->add_setting('feature_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 4));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'feature_npp_count', array(
        'label'    => __( '', 'luzuk' ),
        'section'  => 'feature_area', // Replace with your actual section ID
        'settings' => 'feature_npp_count',
        'choices'=>array(1,2,3,4,5,6,7,8,9)
    ) ) );


//FEATURED PAGES
for( $i = 1; $i <= 9; $i++ ){
    $wp_customize->add_setting(
        'feature_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'feature_header'.$i,
            array(
                'settings'      => 'feature_header'.$i,
                'section'       => 'feature_area',
                'label'         => __( 'Feature Box ', 'Luzuk Premium' ).$i
            )
        )
    );

    $wp_customize->add_setting(
        'feature_page_icon'.$i,
        array(
            'default'           => 'fa fa-users',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'feature_page_icon'.$i,
            array(
                'settings'      => 'feature_page_icon'.$i,
                'section'       => 'feature_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'Luzuk Premium' ),
            )
        )
    );

lzAddElement($wp_customize, 'feature_page_title'.$i, 'feature_area', $type = 'text', $label="Feature Title", $callback ='luzuk_sanitize_text', $default='Contact Professional');

lzAddElement($wp_customize, 'feature_page_txt'.$i, 'feature_area', $type = 'text', $label="Feature Text", $callback ='luzuk_sanitize_text', $default='There are many variations of which do not look even slightly believable.');

lzAddElement($wp_customize, 'ourfeatured_page_url_'.$i, 'feature_area', $type = 'text', $label="Featured Page Link", $callback ='esc_url', $default='Add link here');
    
}


lzCustomLable($wp_customize, 'feature_sectioncolor', 'feature_area', 'Section Color');

addColorPalatOption($wp_customize, 'feature_conbxBrdClr', 'feature_area', 'Box Border Color', '#DEDEDE');

addColorPalatOption($wp_customize, 'feature_conbxBGClr', 'feature_area', 'Box BG Color', '#FBFBFB');

addColorPalatOption($wp_customize, 'feature_conbxBGhvClr', 'feature_area', 'Box BG Hover Color', '#FDA12B');

addColorPalatOption($wp_customize, 'feature_conbxicnClr', 'feature_area', 'Icon Color', '#212121');

addColorPalatOption($wp_customize, 'feature_titleClr', 'feature_area', 'Title Color', '#212121');

addColorPalatOption($wp_customize, 'feature_txtClr', 'feature_area', 'Text Color', '#888888');

