<?php 
 
$wp_customize->add_section(
	'gallery_section',
	array(
		'title'         => __( 'Gallery Section', 'Luzuk' ),
		'panel'   => 'luzuk_premium_home_panel',
	)
);
$wp_customize->add_setting(
	'gallery_section_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'gallery_section_disable',
		array(
			'settings'      => 'gallery_section_disable',
			'section'       => 'gallery_section',
			'label'         => __( 'Disable Section', 'Luzuk' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'Luzuk' ),
				'off' => __( 'No', 'Luzuk' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'gallery', 'gallery_section', $color='#fff');

lzCustomLable($wp_customize, 'luzuk_sec_gallerysectionpadding', 'gallery_section', 'Section Padding');

$wp_customize->add_setting(
    'secgalleryTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'secgalleryTpadding',
    array(
        'settings'      => 'secgalleryTpadding',
        'section'       => 'gallery_section',
        'type'          => 'text',
        'label'         => __( 'Top ', 'luzuk' )
    )
);
$wp_customize->add_setting(
    'secgalleryBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'secgalleryBpadding',
    array(
        'settings'      => 'secgalleryBpadding',
        'section'       => 'gallery_section',
        'type'          => 'text',
        'label'         => __( 'Bottom ', 'luzuk' )
    )
);

lzCustomLable($wp_customize, 'galleryarea_conwidth', 'gallery_section', 'Section Width ');

$wp_customize->add_setting('gall_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container-fluid'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'gall_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'gallery_section', // Replace with your actual section ID
    'settings' => 'gall_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );

lzCustomLable($wp_customize, 'galleryarea_conwidthheading', 'gallery_section', 'Heading Width ');

$wp_customize->add_setting('gall_heading_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'gall_heading_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'gallery_section', // Replace with your actual section ID
    'settings' => 'gall_heading_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


lzCustomLable($wp_customize, 'galleryarea_headingaling', 'gallery_section', 'Heading Alignment');

$wp_customize->add_setting('gallery_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'left'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'gallery_maintitle_align', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'gallery_section', // Replace with your actual section ID
    'settings' => 'gallery_maintitle_align',
    'choices'=>array(
       'left' => 'Left',
       'center' => 'Center',
       'right' => 'Right',
    )
) ) );

lzCustomLable($wp_customize, 'galleryarea_headingcase', 'gallery_section', 'Heading Style');

$wp_customize->add_setting('gallery_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'gallery_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'gallery_section', // Replace with your actual section ID
    'settings' => 'gallery_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Capitalize',
    )
) ) );



$wp_customize->add_setting(
    'gallery_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'gallery_title_heading',
        array(
            'settings'      => 'gallery_title_heading',
            'section'       => 'gallery_section',
            'label'         => __( 'Section Heading', 'luzuk-premium' ),
        )
    )
);


$wp_customize->add_setting(
    'gallery_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our Gallery', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'gallery_title',
    array(
        'settings'      => 'gallery_title',
        'section'       => 'gallery_section',
        'type'          => 'text',
        'label'         => __( 'Heading ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'gallery_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'The Art Of Gallery', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'gallery_subtitle',
    array(
        'settings'      => 'gallery_subtitle',
        'section'       => 'gallery_section',
        'type'          => 'textarea',
        'label'         => __( 'Sub Heading ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'gallery_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or which do not look even slightly believable.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'gallery_txt',
    array(
        'settings'      => 'gallery_txt',
        'section'       => 'gallery_section',
        'type'          => 'textarea',
        'label'         => __( 'Text ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'gallery_Heading', 'gallery_section', 'Heading Color', '#000');

addColorPalatOption($wp_customize, 'gallery_subHeading', 'gallery_section', 'Sub Heading Color', '#8D8D8D');

addColorPalatOption($wp_customize, 'gallery_subHeadtxt', 'gallery_section', 'Text Color', '#333');

addColorPalatOption($wp_customize, 'gallery_Headingbxbrd', 'gallery_section', 'Heading Box Border Color', '#000');

addColorPalatOption($wp_customize, 'gallery_Headingbxbg', 'gallery_section', 'Heading Box BG Color', '#E7F5FC');



$wp_customize->add_setting('gallery_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Info_Text( 
		$wp_customize,
		'gallery_section_lbl',
		array(
			'settings'		=> 'gallery_section_lbl',
			'section'		=> 'gallery_section',
			'label'			=> __( 'Note:', 'Luzuk' ),	
			'description'	=> __( 'Use Gallery Images Of Equal Height.{400px*400px}', 'Luzuk' ),
		)
	)
);

$wp_customize->add_setting('luzuk_gallery_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'luzuk_gallery_npp_heading',
		array(
			'settings'      => 'luzuk_gallery_npp_heading',
			'section'       => 'gallery_section',
			'label'         => __( 'Number Of Gallery Images To Show', 'luzuk' ),
		)
	)
);  

$wp_customize->add_setting('gallery_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 5));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'gallery_npp_count', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'gallery_section', // Replace with your actual section ID
    'settings' => 'gallery_npp_count',
    'choices'=>array(1,2,3,4,5,6)
) ) );


$luzukGallerySingleChoice[] = 'Select';

for( $i = 1; $i <= 6; $i++ ){
	$wp_customize->add_setting(
		'rg_gallery_heading'.$i,
		array(
			'sanitize_callback' => 'luzuk_sanitize_text'
		)
	);
	$wp_customize->add_control(
		new luzuk_Customize_Heading(
			$wp_customize,
			'rg_gallery_heading'.$i,
			array(
				'settings'      => 'rg_gallery_heading'.$i,
				'section'       => 'gallery_section',
				'label'         => __( 'Gallery Image ', 'Luzuk' ).$i, 
			)
		)
	);
	if(is_array($luzukGallerySingleChoice)){
		$wp_customize->add_setting(
			'gallery_page'.$i,
			array(
				'sanitize_callback' => 'absint'
			)
		);
		$wp_customize->add_control(
			'gallery_page'.$i,
			array(
				'settings'      => 'gallery_page'.$i,
				'section'       => 'gallery_section',
				'type'=> 'select',
				'label'         => __( 'Select A Gallery Image', 'Luzuk' ),
				'choices' => $luzukGallerySingleChoice,
			)
		);
	}else{
		$wp_customize->add_setting('gallery_section_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
		$wp_customize->add_control(
			new luzuk_Info_Text( 
				$wp_customize,
				'gallery_section_lbl'.$i,
				array(
					'settings'		=> 'gallery_section_lbl'.$i,
					'section'		=> 'gallery_section',
					'label'			=> __( 'Note:', 'Luzuk' ),	
					'description'	=> __( '<strong>Changes will not reflect unless you select the gallery Image.</strong> <br/>Please add the gallery images from "Gallery menu" and then select gallery Image to show.', 'Luzuk' ),
				)
			)
		);
	}
}


lzCustomLable($wp_customize, 'luzuk_sec_galleryclr', 'gallery_section', 'Section Color');

addColorPalatOption($wp_customize, 'gallsec_imgbrdclr', 'gallery_section', 'Image Hover Border Color ', '#FDA12B');

