<?php 

    $wp_customize->add_section(
        'offres_area',
        array(
            'title' => __( 'Offers Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );

    $wp_customize->add_setting(
        'offres_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'offres_area_disable',
            array(
                'settings'      => 'offres_area_disable',
                'section'       => 'offres_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'offresus', 'offres_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'offresarea_padding', 'offres_area', 'Section Padding');

$wp_customize->add_setting(
    'offres_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'offres_areaTpadding',
    array(
        'settings'      => 'offres_areaTpadding',
        'section'       => 'offres_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'offres_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'offres_areaBpadding',
    array(
        'settings'      => 'offres_areaBpadding',
        'section'       => 'offres_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'offres_conwidth', 'offres_area', 'Section Width ');

$wp_customize->add_setting('offer_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'offer_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'offres_area', // Replace with your actual section ID
    'settings' => 'offer_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


lzCustomLable($wp_customize, 'offersarea_headingaling', 'offres_area', 'Heading Alignment');

$wp_customize->add_setting('offers_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'left'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'offers_maintitle_align', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'offres_area', // Replace with your actual section ID
    'settings' => 'offers_maintitle_align',
    'choices'=>array(
       'left' => 'Left',
       'center' => 'Center',
       'right' => 'Right',
    )
) ) );


lzCustomLable($wp_customize, 'offresarea_headingcase', 'offres_area', 'Heading Style');

$wp_customize->add_setting('offer_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'offer_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'offres_area', // Replace with your actual section ID
    'settings' => 'offer_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Capitalize',
    )
) ) );

$wp_customize->add_setting(
    'offres_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'offres_title_heading',
        array(
            'settings'      => 'offres_title_heading',
            'section'       => 'offres_area',
            'label'         => __( 'Section Heading', 'luzuk-premium' ),
        )
    )
);


$wp_customize->add_setting(
    'offres_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our Best Offers', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'offres_title',
    array(
        'settings'      => 'offres_title',
        'section'       => 'offres_area',
        'type'          => 'text',
        'label'         => __( 'Heading ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'offres_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Tax Included Plans', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'offres_subtitle',
    array(
        'settings'      => 'offres_subtitle',
        'section'       => 'offres_area',
        'type'          => 'text',
        'label'         => __( 'Sub Heading ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'offres_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or which do not look even slightly believable.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'offres_txt',
    array(
        'settings'      => 'offres_txt',
        'section'       => 'offres_area',
        'type'          => 'textarea',
        'label'         => __( 'Text ', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'offres_Heading', 'offres_area', 'Heading Color', '#000');

addColorPalatOption($wp_customize, 'offres_subHeading', 'offres_area', 'Sub Heading Color', '#8D8D8D');

addColorPalatOption($wp_customize, 'offres_subHeadtxt', 'offres_area', 'Text Color', '#333');

addColorPalatOption($wp_customize, 'offres_Headingbxbrd', 'offres_area', 'Heading Box Border Color', '#000');

addColorPalatOption($wp_customize, 'offres_Headingbxbg', 'offres_area', 'Heading Box BG Color', '#fff');


$wp_customize->add_setting('offresus_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'offresus_npp_heading',
        array(
            'settings'      => 'offresus_npp_heading',
            'section'       => 'offres_area',
            'label'         => __( 'Number Of Offres Box', 'luzuk-premium' ),
        )
    )
);   

$wp_customize->add_setting('offresus_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'offresus_npp_count', array(
        'label'    => __( '', 'luzuk' ),
        'section'  => 'offres_area', // Replace with your actual section ID
        'settings' => 'offresus_npp_count',
        'choices'=>array(1,2,3,4,5,6,7,8)
    ) ) ); 


//offres PAGES
for( $i = 1; $i <= 8; $i++ ){
    $wp_customize->add_setting(
        'offresus_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'offresus_header'.$i,
            array(
                'settings'      => 'offresus_header'.$i,
                'section'       => 'offres_area',
                'label'         => __( 'Section Box ', 'luzuk-premium' ).$i
            )
        )
    );


lzAddImageElement($wp_customize, 'offresus_page_icon'.$i, 'offres_area', $label="Recommended Image Size: 600X350px");


// 01

lzAddElement($wp_customize, 'offresus_title1'.$i, 'offres_area', $type = 'text', $label="Title 1", $callback ='luzuk_sanitize_text', $default='Industrial Electricians');

lzAddElement($wp_customize, 'offres_price1'.$i, 'offres_area', $type = 'text', $label="Price 1", $callback ='luzuk_sanitize_text', $default='$15.80');

// 02

lzAddElement($wp_customize, 'offresus_title2'.$i, 'offres_area', $type = 'text', $label="Title 2", $callback ='luzuk_sanitize_text', $default='Commercial Electrician');

lzAddElement($wp_customize, 'offres_price2'.$i, 'offres_area', $type = 'text', $label="Price 2 ", $callback ='luzuk_sanitize_text', $default='$14.40');

// 03

lzAddElement($wp_customize, 'offresus_title3'.$i, 'offres_area', $type = 'text', $label="Title 3", $callback ='luzuk_sanitize_text', $default='Residential Electrician');

lzAddElement($wp_customize, 'offres_price3'.$i, 'offres_area', $type = 'text', $label="Price 3 ", $callback ='luzuk_sanitize_text', $default='$12.50');

// 04

lzAddElement($wp_customize, 'offresus_title4'.$i, 'offres_area', $type = 'text', $label="Title 4", $callback ='luzuk_sanitize_text', $default='Maintenance Electrician');

lzAddElement($wp_customize, 'offres_price4'.$i, 'offres_area', $type = 'text', $label="Price 4 ", $callback ='luzuk_sanitize_text', $default='$17.30');

// 05

lzAddElement($wp_customize, 'offresus_title5'.$i, 'offres_area', $type = 'text', $label="Title 5", $callback ='luzuk_sanitize_text', $default='Master Electrician');

lzAddElement($wp_customize, 'offres_price5'.$i, 'offres_area', $type = 'text', $label="Price 5 ", $callback ='luzuk_sanitize_text', $default='$13.80');
// btn

lzAddElement($wp_customize, 'offres_btntxt'.$i, 'offres_area', $type = 'text', $label="Button Text ", $callback ='luzuk_sanitize_text', $default='Book Now');

lzAddElement($wp_customize, 'luzuk_offres_page_url_'.$i, 'offres_area', $type = 'text', $label="Link", $callback ='esc_url', $default='Add link here');

}


lzCustomLable($wp_customize, 'offres_area-clr', 'offres_area' , ' Section Color');

addColorPalatOption($wp_customize, 'offrsec_contbxbg', 'offres_area', 'Conten Box BG Color', '#000');

addColorPalatOption($wp_customize, 'offrsec_titleclr', 'offres_area', 'Title Color', '#fff');

addColorPalatOption($wp_customize, 'offrsec_priceclr', 'offres_area', 'Price Color', '#fff');

addColorPalatOption($wp_customize, 'offrsec_brdclr', 'offres_area', 'Border Color', '#80786f');

addColorPalatOption($wp_customize, 'offrsec_btntxtclr', 'offres_area', 'Button Text Color', '#000');

addColorPalatOption($wp_customize, 'offrsec_btntxthvclr', 'offres_area', 'Button Text Hover Color', '#FDA12B');

addColorPalatOption($wp_customize, 'offrsec_btnbgclr', 'offres_area', 'Button BG Color', '#E7F5FC');

addColorPalatOption($wp_customize, 'offrsec_btnbghvclr', 'offres_area', 'Button BG Hover Color', '#000');

addColorPalatOption($wp_customize, 'offrsec_slidotclr', 'offres_area', 'Slider Dots Color', '#000');

addColorPalatOption($wp_customize, 'offrsec_sliactdotclr', 'offres_area', 'Slider Active Dot Color', '#000');

addColorPalatOption($wp_customize, 'offrsec_sliactdotbrdclr', 'offres_area', 'Slider Active Dot Border Color', '#ccc');