<?php 
$wp_customize->add_section('pricing_area',array('title' => __( 'Pricing Section', 'luzuk' ),'panel' => 'luzuk_premium_home_panel'));
$wp_customize->add_setting('pricing_area_disable',array('sanitize_callback' => 'luzuk_sanitize_text',));
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'pricing_area_disable',
        array(
            'settings' => 'pricing_area_disable',
            'section' => 'pricing_area',
            'label' => __( 'Disable Section', 'luzuk' ),
            'on_off_label'  => array('on' => __( 'Yes', 'luzuk' ), 'off' => __( 'No', 'luzuk' )),
        )
    )
); 


backgroundManager($wp_customize, 'pricingsec', 'pricing_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'pricing_areapadding', 'pricing_area', 'Section Padding');

$wp_customize->add_setting(
    'pricing_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'pricing_areaTpadding',
    array(
        'settings'      => 'pricing_areaTpadding',
        'section'       => 'pricing_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk' )
    )
);
$wp_customize->add_setting(
    'pricing_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'pricing_areaBpadding',
    array(
        'settings'      => 'pricing_areaBpadding',
        'section'       => 'pricing_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk' )
    )
);

lzCustomLable($wp_customize, 'pricingarea_conwidth', 'pricing_area', 'Section Width ');

$wp_customize->add_setting('pricing_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'pricing_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'pricing_area', // Replace with your actual section ID
    'settings' => 'pricing_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );



lzCustomLable($wp_customize, 'pricingarea_headingaling', 'pricing_area', 'Heading Alignment ');

$wp_customize->add_setting('pricing_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'left'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'pricing_maintitle_align', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'pricing_area', // Replace with your actual section ID
    'settings' => 'pricing_maintitle_align',
    'choices'=>array(
       'left' => 'Left',
       'center' => 'Center',
       'right' => 'Right',
    )
) ) );


lzCustomLable($wp_customize, 'pricingarea_headingcase', 'pricing_area', 'Heading Style');

$wp_customize->add_setting('pricing_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'pricing_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'pricing_area', // Replace with your actual section ID
    'settings' => 'pricing_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Capitalize',
    )
) ) );


lzCustomLable($wp_customize, 'pricing_areaheading', 'pricing_area', 'Section Heading ');

$wp_customize->add_setting('pricingsec_maintitle',array('sanitize_callback' => 'luzuk_sanitize_text','default' => __( 'Pricing Plans', 'luzuk' )));
$wp_customize->add_control(
    'pricingsec_maintitle',
    array(
        'settings'      => 'pricingsec_maintitle',
        'section'       => 'pricing_area',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk' )
    )
);



$wp_customize->add_setting('pricimgsec_subtitle',array('sanitize_callback' => 'luzuk_sanitize_text','default' => __( 'Tax Included Plans', 'luzuk' )));
$wp_customize->add_control(
    'pricimgsec_subtitle',
    array(
        'settings'      => 'pricimgsec_subtitle',
        'section'       => 'pricing_area',
        'type'          => 'text',
        'label'         => __( 'Sub Heading', 'luzuk' )
    )
);


$wp_customize->add_setting('pricingsec_text',array('sanitize_callback' => 'luzuk_sanitize_text','default' => __( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or which do not look even slightly believable.', 'luzuk' )));
$wp_customize->add_control(
    'pricingsec_text',
    array(
        'settings'      => 'pricingsec_text',
        'section'       => 'pricing_area',
        'type'          => 'textarea',
        'label'         => __( ' Text', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'pricingsec_Heading', 'pricing_area', 'Heading Color', '#000');

addColorPalatOption($wp_customize, 'pricingsec_subHeading', 'pricing_area', 'Sub Heading Color', '#8D8D8D');

addColorPalatOption($wp_customize, 'pricingsec_subHeadtxt', 'pricing_area', 'Text Color', '#333');

addColorPalatOption($wp_customize, 'pricingsec_Headingbxbrd', 'pricing_area', 'Heading Box Border Color', '#000');

addColorPalatOption($wp_customize, 'pricingsec_Headingbxbg', 'pricing_area', 'Heading Box BG Color', '#E7F5FC');


$wp_customize->add_setting('pricing_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'pricing_npp_heading',
        array(
            'settings'      => 'pricing_npp_heading',
            'section'       => 'pricing_area',
            'label'         => __( 'Pricing Plan To Show', 'luzuk' ),
        )
    )
);  

$wp_customize->add_setting('pricing_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 2));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'pricing_npp_count', array(
        'label'    => __( '', 'luzuk' ),
        'section'  => 'pricing_area', // Replace with your actual section ID
        'settings' => 'pricing_npp_count',
        'choices'=>array(1,2,3,4,5,6)
    ) ) );


// $wp_customize->add_setting('pricing_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 2));
// $wp_customize->add_control(
//     'pricing_npp_count',
//     array(
//         'settings'      => 'pricing_npp_count',
//         'section'       => 'pricing_area',
//         'type'          => 'select',
//         'label'         => __( 'Number Of Plan To Show', 'luzuk' ),
//         'choices'=>array(1,2,3,4,5,6)
//     )
// );

for($i=1;$i<=6;$i++){
    $wp_customize->add_setting('pricing_plan_heading_'.$i,array('sanitize_callback' => 'luzuk_sanitize_text'));
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'pricing_plan_heading_'.$i,
            array(
                'settings' => 'pricing_plan_heading_'.$i,
                'section' => 'pricing_area',
                'label' => __( 'Pricing Plan '.$i, 'luzuk' ),
            )
        )
    ); 


$wp_customize->add_setting('pricing_plan_name_'.$i,array('sanitize_callback' => 'luzuk_sanitize_text','default' => __( 'Standard Plan', 'luzuk' )));

$wp_customize->add_control(
    'pricing_plan_name_'.$i,
    array(
        'settings' => 'pricing_plan_name_'.$i,
        'section' => 'pricing_area',
        'type' => 'text',
        'label' => __( 'Add Plan Name Here ', 'luzuk' )
    )
);

$wp_customize->add_setting('pricing_priceTitle_'.$i,array('sanitize_callback' => 'luzuk_sanitize_text','default' => __( 'Price', 'luzuk' )));

$wp_customize->add_control(
    'pricing_priceTitle_'.$i,
    array(
        'settings' => 'pricing_priceTitle_'.$i,
        'section' => 'pricing_area',
        'type' => 'text',
        'label' => __( 'Price Title ', 'luzuk' )
    )
);



$wp_customize->add_setting('pricing_plan_price_'.$i,array('sanitize_callback' => 'luzuk_sanitize_text','default' => __( '$250', 'luzuk' )));
$wp_customize->add_control(
    'pricing_plan_price_'.$i,
    array(
        'settings' => 'pricing_plan_price_'.$i,
        'section' => 'pricing_area',
        'type' => 'text',
        'label' => __( 'Add Plan Price Here ', 'luzuk' )
    )
);

$wp_customize->add_setting('pricing_plan_day_'.$i,array('sanitize_callback' => 'luzuk_sanitize_text','default' => __( '/hour', 'luzuk' )));
$wp_customize->add_control(
    'pricing_plan_day_'.$i,
    array(
        'settings' => 'pricing_plan_day_'.$i,
        'section' => 'pricing_area',
        'type' => 'text',
        'label' => __( 'Add Time Here ', 'luzuk' )
    )
);

$wp_customize->add_setting('pricing_plan_content_'.$i,array('sanitize_callback' => 'luzuk_sanitize_text','default' => __( '  
<li>All Basic Plan Services</li>
<li>Carpentry & Painting</li>
<li>Door & Window Installation</li>
<li>Light Fixture Installation</li>', 'luzuk' )));

$wp_customize->add_control(
    'pricing_plan_content_'.$i,
    array(
        'settings' => 'pricing_plan_content_'.$i,
        'section' => 'pricing_area',
        'type' => 'textarea',
        'label' => __( 'Add Pricing Plan Content Here ', 'luzuk' )
    )
);

    /*code for button text*/
$wp_customize->add_setting(
    'pricing_page_button_title_'.$i,
    array(
        'sanitize_callback'=>'luzuk_sanitize_text',
        'default'=> __('Buy Now', 'luzuk')
    )
);
$wp_customize->add_control(
    'pricing_page_button_title_'.$i,
    array(
        'settings' =>'pricing_page_button_title_'.$i,
        'section' => 'pricing_area',
        'type'=> 'text',
        'label'=> __('Add Button Text Here ', 'luzuk')
    )
);

lzAddElement($wp_customize, 'pricing_plan_url_'.$i, 'pricing_area', $type = 'text', $label="Add Link Here", $callback ='esc_url', $default='#');

    }


lzCustomLable($wp_customize, 'pricing_areacolor', 'pricing_area', 'Section Color');

addColorPalatOption($wp_customize, 'pricingarea_PlanbxbrdClr', 'pricing_area', 'Plan Box Border Color ', '#E7F5FC');

addColorPalatOption($wp_customize, 'pricingarea_PlanbxbgClr', 'pricing_area', 'Plan Box BG Color ', '#f7fbfe');

addColorPalatOption($wp_customize, 'pricingarea_PlanbxbghvClr', 'pricing_area', 'Plan Box BG Hover Color ', '#E7F5FC');

addColorPalatOption($wp_customize, 'pricingarea_PlanNameClr', 'pricing_area', 'Plan Name Color ', '#1A1A1A');

addColorPalatOption($wp_customize, 'pricingarea_pricetitlclr', 'pricing_area', 'Plan Price Title Color ', '#000');

addColorPalatOption($wp_customize, 'pricingarea_Planpriceclr', 'pricing_area', 'Plan Price Color ', '#7D7D7D');

addColorPalatOption($wp_customize, 'pricingarea_Planprtimeclr', 'pricing_area', 'Plan Price Time Color ', '#000');

addColorPalatOption($wp_customize, 'price_ContentliicnClr', 'pricing_area', 'Plan Content List Icon Color', '#646464');

addColorPalatOption($wp_customize, 'pricing_PlanConiClr', 'pricing_area', 'Plan Content List Color ', '#646464');

addColorPalatOption($wp_customize, 'pricing_ButtontextColor', 'pricing_area', 'Plan Button Text Color ', '#fff');

addColorPalatOption($wp_customize, 'pricing_ButtontexthvClr', 'pricing_area', 'Plan Button Text Hover Color ', '#000');

addColorPalatOption($wp_customize, 'pricing_ButtonbgColor', 'pricing_area', 'Plan Button BG Color', '#000');

addColorPalatOption($wp_customize, 'pricing_ButtonbghvClr', 'pricing_area', 'Plan Button BG Hover Color', '#FDA12B');


