<?php 
$wp_customize->add_section(
    'service_area',
    array(
        'title'         => __( 'Services Section', 'luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);

$wp_customize->add_setting(
    'service_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'service_area_disable',
        array(
            'settings'      => 'service_area_disable',
            'section'       => 'service_area',
            'label'         => __( 'Disable Section', 'luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk' ),
                'off' => __( 'No', 'luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'service', 'service_area', $color='#fff', get_template_directory_uri().'/images/default.png', 'img');


lzCustomLable($wp_customize, 'luzuk_sec_servicessectionpadding', 'service_area', 'Section Padding');

$wp_customize->add_setting(
    'service_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaTpadding',
    array(
        'settings'      => 'service_areaTpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'service_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaBpadding',
    array(
        'settings'      => 'service_areaBpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'servicearea_conwidth', 'service_area', 'Section Width ');

$wp_customize->add_setting('ser_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'ser_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'service_area', // Replace with your actual section ID
    'settings' => 'ser_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


lzCustomLable($wp_customize, 'servicearea_headingaling', 'service_area', 'Heading Alignment');

$wp_customize->add_setting('ser_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'left'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'ser_maintitle_align', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'service_area', // Replace with your actual section ID
    'settings' => 'ser_maintitle_align',
    'choices'=>array(
       'left' => 'Left',
       'center' => 'Center',
       'right' => 'Right',
    )
) ) );


lzCustomLable($wp_customize, 'serarea_headingcase', 'service_area', 'Heading Style');

$wp_customize->add_setting('ser_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'ser_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'service_area', // Replace with your actual section ID
    'settings' => 'ser_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Capitalize',
    )
) ) );



$wp_customize->add_setting(
    'ser_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'ser_title_heading',
        array(
            'settings'      => 'ser_title_heading',
            'section'       => 'service_area',
            'label'         => __( 'Section Heading', 'luzuk-premium' ),
        )
    )
);


$wp_customize->add_setting(
    'ser_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our Services', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'ser_title',
    array(
        'settings'      => 'ser_title',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Heading ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'ser_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Reliable Handyman Services For Every Job, Big Or Small', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'ser_subtitle',
    array(
        'settings'      => 'ser_subtitle',
        'section'       => 'service_area',
        'type'          => 'textarea',
        'label'         => __( 'Sub Heading ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'ser_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or which do not look even slightly believable.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'ser_txt',
    array(
        'settings'      => 'ser_txt',
        'section'       => 'service_area',
        'type'          => 'textarea',
        'label'         => __( 'Text ', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'ser_Heading', 'service_area', 'Heading Color', '#000');

addColorPalatOption($wp_customize, 'ser_subHeading', 'service_area', 'Sub Heading Color', '#8D8D8D');

addColorPalatOption($wp_customize, 'ser_subHeadtxt', 'service_area', 'Text Color', '#333');

addColorPalatOption($wp_customize, 'ser_Headingbxbrd', 'service_area', 'Heading Box Border Color', '#000');

addColorPalatOption($wp_customize, 'ser_Headingbxbg', 'service_area', 'Heading Box BG Color', '#E7F5FC');


$wp_customize->add_setting('service_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'service_area_lbl2',
        array(
            'settings'      => 'service_area_lbl2',
            'section'       => 'service_area',
            'label'         => __( 'Note :', 'luzuk' ),  
            'description'   => __( 'Use Shortcode [SERVICES] to show all services in a page', 'luzuk' ),
        )
    )
);


$wp_customize->add_setting('service_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'service_npp_heading',
        array(
            'settings'      => 'service_npp_heading',
            'section'       => 'service_area',
            'label'         => __( 'Number Of Services To Show', 'luzuk' ),
        )
    )
);    

$wp_customize->add_setting('service_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'service_npp_count', array(
        'label'    => __( '', 'luzuk' ),
        'section'  => 'service_area', // Replace with your actual section ID
        'settings' => 'service_npp_count',
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    ) ) );


$ServicesSingleChoice[] = 'Select';

for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'services_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'services_heading'.$i,
            array(
                'settings'      => 'services_heading'.$i,
                'section'       => 'service_area',
                'label'         => __( 'Service ', 'luzuk' ).$i,
            )
        )
    );
    if(is_array($ServicesSingleChoice)){
        $wp_customize->add_setting(
            'services_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'services_page'.$i,
            array(
                'settings'      => 'services_page'.$i,
                'section'       => 'service_area',
                'type'=> 'select',
                'label'         => __( 'Select A Service Box ', 'luzuk' ),
                'choices' => $ServicesSingleChoice,
            )
        );

// $wp_customize->add_setting(
//         'services_page_icon1'.$i,
//         array(
//             'default'           => 'fa fa-wrench',
//             'sanitize_callback' => 'luzuk_sanitize_text'
//         )
//     );        
//     $wp_customize->add_control(
//         new luzuk_Fontawesome_Icon_Chooser(
//             $wp_customize,
//             'services_page_icon1'.$i,
//             array(
//                 'settings'      => 'services_page_icon1'.$i,
//                 'section'       => 'service_area',
//                 'type'          => 'icon',
//                 'label'         => __( 'FontAwesome Icon', 'luzuk' ),
//             )
//         )
//     );



    }else{
        $wp_customize->add_setting('service_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'service_area_lbl'.$i,
                array(
                    'settings'      => 'service_area_lbl'.$i,
                    'section'       => 'service_area',
                    'label'         => __( 'Note:', 'luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the Service Page.</strong> <br/>Please add the Services from "Services menu" and then select Services to show information.', 'luzuk' ),
                )
            )
        );
    }
}

lzCustomLable($wp_customize, 'luzuk_sec_servicesclr', 'service_area', 'Section Color');

addColorPalatOption($wp_customize, 'services_secimgolyClr', 'service_area', 'Image Overlay Color ', '#7f7d7d');

addColorPalatOption($wp_customize, 'services_secicnClr', 'service_area', 'Title Icon Color ', '#fff');

addColorPalatOption($wp_customize, 'services_secicnbgClr', 'service_area', 'Title Icon BG Color ', '#E7F5FC');

addColorPalatOption($wp_customize, 'services_secTitleClr', 'service_area', 'Title Color ', '#fff');


lzCustomLable($wp_customize, 'luzuk_sec_servbtnclr', 'service_area', 'Section Button 1');

$wp_customize->add_setting(
    'serbtn_text1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Browse All Services', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'serbtn_text1',
    array(
        'settings'      => 'serbtn_text1',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

$wp_customize->add_setting('serbtn1link',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('serbtn1link',
    array(
        'settings'      => 'serbtn1link',
        'section'       => 'service_area',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'sersec_btntxtclr', 'service_area', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'sersec_btntxthvclr', 'service_area', 'Button Text Hover Color', '#FDA12B');

addColorPalatOption($wp_customize, 'sersec_btnBGclr', 'service_area', 'Button BG Color', '#FDA12B');

addColorPalatOption($wp_customize, 'sersec_btnicnBGclr', 'service_area', 'Button BG Hover Color', '#000');


lzCustomLable($wp_customize, 'luzuk_sec_servbtnclr', 'service_area', 'Section Button 2');

$wp_customize->add_setting(
    'serbtn_text2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Get a quote', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'serbtn_text2',
    array(
        'settings'      => 'serbtn_text2',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

$wp_customize->add_setting('serbtn2link',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('serbtn2link',
    array(
        'settings'      => 'serbtn2link',
        'section'       => 'service_area',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'sersec_btnt2xtclr', 'service_area', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'sersec_btnt2xthvclr', 'service_area', 'Button Text Hover Color', '#373434');

addColorPalatOption($wp_customize, 'sersec_btn2BGclr', 'service_area', 'Button BG Color', '#373434');

addColorPalatOption($wp_customize, 'sersec_btn2icnBGclr', 'service_area', 'Button BG Hover Color', '#FDA12B');