<?php  

$luzukSliderSingleChoice = getFitnessPostsType('slider');
$wp_customize->add_section(
	'slider_section',
	array(
		'title' => __( 'Slider Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel',
		'priority' =>18
	)
);

$wp_customize->add_setting(
	'slider_section_show_content',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'slider_section_show_content',
		array(
			'settings'      => 'slider_section_show_content',
			'section'       => 'slider_section',
			'label'         => __( 'Hide Title And Description On Slider', 'Luzuk' ),
			'on_off_label'  => array(
				'on' => __( 'No', 'Luzuk' ),
				'off' => __( 'Yes', 'Luzuk' )
			),
		)
	)
);
$wp_customize->add_setting('slider_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Info_Text( 
		$wp_customize,
		'slider_section_lbl',
		array(
			'settings'		=> 'slider_section_lbl',
			'section'		=> 'slider_section',
			'label'			=> __( 'Note:', 'Luzuk' ),	
			'description'	=> __( 'The page featured image works as a banner and the title & content work as a slider caption. You can add this from the Slider menu. <br/> Recommended Image Size: 1300X780', 'Luzuk' ),
		)
	)
);

lzCustomLable($wp_customize, 'luzuk_sliderimgopcity', 'slider_section', 'Image Overlay ');

$wp_customize->add_setting(
    'slider_areaOpacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.8', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'slider_areaOpacity',
    array(
        'settings'      => 'slider_areaOpacity',
        'section'       => 'slider_section',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'slider_imgovlyclr', 'slider_section', 'Image Overlay Color', '#404040');

lzCustomLable($wp_customize, 'luzuk_sliderotherclrs', 'slider_section', 'Section Color');

//addColorPalatOption($wp_customize, 'slider_bxbgColor', 'slider_section', 'Slider BG Color', '#fff');

addColorPalatOption($wp_customize, 'slider_contbxleftbrdClr', 'slider_section', 'Slider Conten Left Border Color', '#fff');

addColorPalatOption($wp_customize, 'slider_subtitleclr', 'slider_section', 'Sub Title Color', '#fff');

addColorPalatOption($wp_customize, 'slider_titleColor', 'slider_section', 'Title Color', '#fff');

addColorPalatOption($wp_customize, 'slider_textclr', 'slider_section', 'Text Color', '#fff');

addColorPalatOption($wp_customize, 'slider_BtntextClr', 'slider_section', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'slider_BtntxthvClr', 'slider_section', 'Button Text Hover Color', '#FDA12B');

addColorPalatOption($wp_customize, 'slider_Buttonibrd', 'slider_section', 'Button BG Color', '#FDA12B');

addColorPalatOption($wp_customize, 'slider_Buttonbghv1', 'slider_section', 'Button BG Hover Color', '#000');


lzCustomLable($wp_customize, 'luzuk_sliderbutnclrs', 'slider_section', 'Slider Dots Setting');

addColorPalatOption($wp_customize, 'sli_arrwbtnclr', 'slider_section', 'Slider Dots Color', '#000');

addColorPalatOption($wp_customize, 'sli_arrwbgclr', 'slider_section', 'Slider Active Dot Color', '#FDA12B');

// 
lzCustomLable($wp_customize, 'luzuk_sliderRespclrs', 'slider_section', 'Slider Responsive Color');

addColorPalatOption($wp_customize, 'slider_Resp_subtitleclr', 'slider_section', 'Sub Title Color', '#000');

addColorPalatOption($wp_customize, 'slider_Resp_titleColor', 'slider_section', 'Title Color', '#000');

addColorPalatOption($wp_customize, 'slider_Resp_textclr', 'slider_section', 'Text Color', '#000');