<?php   
$wp_customize->add_section(
	'team_area',
	array(
		'title'         => __( 'Team Section', 'luzuk-premium' ),
		'panel'   => 'luzuk_premium_home_panel',
	)
);
$wp_customize->add_setting(
	'team_area_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'team_area_disable',
		array(
			'settings'      => 'team_area_disable',
			'section'       => 'team_area',
			'label'         => __( 'Disable Section', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk-premium' ),
				'off' => __( 'No', 'luzuk-premium' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'team', 'team_area', $color='#fdfdfd', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'team_area_teamsectionpadding', 'team_area', 'Section Padding');

$wp_customize->add_setting(
    'team_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'team_areaTpadding',
    array(
        'settings'      => 'team_areaTpadding',
        'section'       => 'team_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'team_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'team_areaBpadding',
    array(
        'settings'      => 'team_areaBpadding',
        'section'       => 'team_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'teamarea_conwidth', 'team_area', 'Section Width ');

$wp_customize->add_setting('team_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'team_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'team_area', // Replace with your actual section ID
    'settings' => 'team_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


lzCustomLable($wp_customize, 'teamarea_headingaling', 'team_area', 'Heading Alignment');

$wp_customize->add_setting('team_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'left'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'team_maintitle_align', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'team_area', // Replace with your actual section ID
    'settings' => 'team_maintitle_align',
    'choices'=>array(
       'left' => 'Left',
       'center' => 'Center',
       'right' => 'Right',
    )
) ) );


lzCustomLable($wp_customize, 'teamarea_headingcase', 'team_area', 'Heading Style');

$wp_customize->add_setting('team_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'team_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'team_area', // Replace with your actual section ID
    'settings' => 'team_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Capitalize',
    )
) ) );


$wp_customize->add_setting(
	'luzuk_team_title_subtitle_heading',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
	)
);
$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'luzuk_team_title_subtitle_heading',
		array(
			'settings'      => 'luzuk_team_title_subtitle_heading',
			'section'       => 'team_area',
			'label'         => __( 'Section Heading', 'luzuk-premium' ),
		)
	)
);


$wp_customize->add_setting(
	'team_title',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Our Team ', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'team_title',
	array(
		'settings'      => 'team_title',
		'section'       => 'team_area',
		'type'          => 'text',
		'label'         => __( 'Heading', 'luzuk-premium' )
	)
);

addColorPalatOption($wp_customize, 'teamarea_sectitle_color', 'team_area', 'Heading Color', '#000');

$wp_customize->add_setting(
	'teamsubtitle',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Lorem Ipsum Available, Injected ', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'teamsubtitle',
	array(
		'settings'      => 'teamsubtitle',
		'section'       => 'team_area',
		'type'          => 'text',
		'label'         => __( 'Sub Heading', 'luzuk-premium' )
	)
);

addColorPalatOption($wp_customize, 'teamarea_subtitle_clr', 'team_area', 'Sub Heading Color', '#515151');

$wp_customize->add_setting(
	'teamtxt',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'There are many variations of passages of Lorem Ipsum available, but the even slightly believable. ', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'teamtxt',
	array(
		'settings'      => 'teamtxt',
		'section'       => 'team_area',
		'type'          => 'textarea',
		'label'         => __( 'Text', 'luzuk-premium' )
	)
);

addColorPalatOption($wp_customize, 'teamarea_txtclr', 'team_area', 'Text Color', '#656565');


/*for note text*/
$wp_customize->add_setting('team_area_lbl1', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'team_area_lbl1',
        array(
            'settings'      => 'team_area_lbl1',
            'section'       => 'team_area',
            'label'         => __( 'Note1:', 'luzuk' ),    
            'description'   => __( 'Just place the shortcode "[TEAMLIST]" in your page to Show all teams in a page', 'luzuk' ),
        )
    )
);


/*for note text*/

$wp_customize->add_setting('team_area_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'team_area_npp_heading',
		array(
			'settings'      => 'team_area_npp_heading',
			'section'       => 'team_area',
			'label'         => __( 'Number Of Team Members', 'luzuk-premium' ),
		)
	)
);    

$wp_customize->add_setting('team_area_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 2));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'team_area_npp_count', array(
        'label'    => __( '', 'luzuk' ),
        'section'  => 'team_area', // Replace with your actual section ID
        'settings' => 'team_area_npp_count',
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    ) ) );


// TEAM PAGES
$TeamsSingleChoice[] = 'select';
for( $i = 1; $i <= 12; $i++ ){
	$wp_customize->add_setting(
		'team_area_heading'.$i,
		array(
			'sanitize_callback' => 'luzuk_sanitize_text'
		)
	);
	$wp_customize->add_control(
		new luzuk_Customize_Heading(
			$wp_customize,
			'team_area_heading'.$i,
			array(
				'settings'      => 'team_area_heading'.$i,
				'section'       => 'team_area',
				'label'         => __( 'Team ', 'luzuk-premium' ).$i,
			)
		)
	);
	if(is_array($TeamsSingleChoice)){
		$wp_customize->add_setting(
			'team_area_page'.$i,
			array(
				'sanitize_callback' => 'absint'
			)
		);
		$wp_customize->add_control(
			'team_area_page'.$i,
			array(
				'settings'      => 'team_area_page'.$i,
				'section'       => 'team_area',
				'type'=> 'select',
				'label'         => __( 'Select A Team Member', 'luzuk-premium' ),
				'choices' => $TeamsSingleChoice,
			)
		);

	}
	else{
		$wp_customize->add_setting('team_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
		$wp_customize->add_control(
			new luzuk_Info_Text( 
				$wp_customize,
				'team_area_lbl'.$i,
				array(
					'settings'		=> 'team_area_lbl'.$i,
					'section'		=> 'team_area',
					'label'			=> __( 'Note:', 'luzuk-premium' ),	
					'description'	=> __( '<strong>Changes will not reflect unless you select the Teams.</strong> <br/>Please add the teams from "Teams menu" and then select Team Member to show information.', 'luzuk-premium' ),
				)
			)
		);
	}
}

lzCustomLable($wp_customize, 'team_area_teamsecclr', 'team_area', 'Section Color');

addColorPalatOption($wp_customize, 'teamsec_bxclr', 'team_area', 'Team Member Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'teamsec_TeamNameClr', 'team_area', 'Team Member Name Color', '#000');

addColorPalatOption($wp_customize, 'teamsec_TmDesignClr', 'team_area', 'Team Designation Color', '#000');

addColorPalatOption($wp_customize, 'teamsec_TmsclicnbgClr', 'team_area', 'Social Icon Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'teamsec_TmsclicnClr', 'team_area', 'Social Icon Color', '#000');

addColorPalatOption($wp_customize, 'teamsec_TmsclicnhvClr', 'team_area', 'Social Icon Hover Color', '#FDA12B');


addColorPalatOption($wp_customize, 'pages_Teamslidedotbgclr', 'team_area', 'Slider Dot BG Color', '#000');

addColorPalatOption($wp_customize, 'pages_Teamslideactdotbgclr', 'team_area', 'Slider Active Dot BG Color', '#FDA12B');