<?php  
// TESTIMONIALS SECTION START HERE 

$wp_customize->add_section(
    'testimonials_area',
    array(
        'title'         => __( 'Testimonial Section', 'luzuk Premium' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);

    //ENABLE/DISABLE TESTIMONIALS SECTION
$wp_customize->add_setting(
    'testimonials_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'testimonials_area_disable',
        array(
            'settings'      => 'testimonials_area_disable',
            'section'       => 'testimonials_area',
            'label'         => __( 'Disable Section', 'luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk Premium' ),
                'off' => __( 'No', 'luzuk Premium' )
            )   
        ) 
    )
);
 
backgroundManager($wp_customize, 'testimonials', 'testimonials_area', $color='#fbfaf9', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'luzuk_sec_testsectionpadding', 'testimonials_area', 'Section Padding');

$wp_customize->add_setting(
    'testimonials_areaTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaTpadding',
    array(
        'settings'      => 'testimonials_areaTpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk Premium' )
    )
);
$wp_customize->add_setting(
    'testimonials_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaBpadding',
    array(
        'settings'      => 'testimonials_areaBpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk Premium' )
    )
);

lzCustomLable($wp_customize, 'testiarea_conwidth', 'testimonials_area', 'Section Width ');

$wp_customize->add_setting('testi_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'testi_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'testimonials_area', // Replace with your actual section ID
    'settings' => 'testi_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );

lzCustomLable($wp_customize, 'testiarea_headingaling', 'testimonials_area', 'Heading Alignment ');

$wp_customize->add_setting('testi_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'left'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'testi_maintitle_align', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'testimonials_area', // Replace with your actual section ID
    'settings' => 'testi_maintitle_align',
    'choices'=>array(
       'left' => 'Left',
       'center' => 'Center',
       'right' => 'Right',
    )
) ) );


lzCustomLable($wp_customize, 'testiarea_headingcase', 'testimonials_area', 'Heading Style');

$wp_customize->add_setting('testi_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'testi_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'testimonials_area', // Replace with your actual section ID
    'settings' => 'testi_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Capitalize',
    )
) ) );


$wp_customize->add_setting(
    'testi_title_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'testi_title_subtitle_heading',
        array(
            'settings'      => 'testi_title_subtitle_heading',
            'section'       => 'testimonials_area',
            'label'         => __( 'Section Heading ', 'luzuk-premium' ),
        )
    )
);


$wp_customize->add_setting(
    'testi_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Reviews', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'testi_title',
    array(
        'settings'      => 'testi_title',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'testi_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Happy Customer Thoughts', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'testi_subtitle',
    array(
        'settings'      => 'testi_subtitle',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Sub Heading ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'testi_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or which do not look even slightly believable.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'testi_txt',
    array(
        'settings'      => 'testi_txt',
        'section'       => 'testimonials_area',
        'type'          => 'textarea',
        'label'         => __( 'Text ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'tessec_Heading', 'testimonials_area', 'Heading Color', '#000');

addColorPalatOption($wp_customize, 'tessec_subHeading', 'testimonials_area', 'Sub Heading Color', '#8D8D8D');

addColorPalatOption($wp_customize, 'tessec_subHeadtxt', 'testimonials_area', 'Text Color', '#333');

addColorPalatOption($wp_customize, 'tessec_Headingbxbrd', 'testimonials_area', 'Heading Box Border Color', '#000');

addColorPalatOption($wp_customize, 'tessec_Headingbxbg', 'testimonials_area', 'Heading Box BG Color', '#E7F5FC');


$TesimonialsSingleChoice[] = 'select';
if(!is_array($TesimonialsSingleChoice)){
    $wp_customize->add_setting('testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
    $wp_customize->add_control(
        new luzuk_Info_Text( 
            $wp_customize,
            'testimonials_area_lbl',
            array(
                'settings'      => 'testimonials_area_lbl',
                'section'       => 'testimonials_area',
                'label'         => __( 'Note:', 'luzuk Premium' ), 
                'description'   => __( '<strong>Changes will not reflect unless you select the Testimonials.</strong> <br/>Please add the Testimonials from "Testimonials menu" and then select Testimonial to show information.', 'luzuk Premium' ),
            )
        )
    );
}
$wp_customize->add_setting('luzuk_premium_testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_testimonials_area_lbl',
        array(
            'settings'      => 'luzuk_premium_testimonials_area_lbl',
            'section'       => 'testimonials_area',
            'label'         => __( 'Note:', 'luzuk Premium' ), 
            'description'   => __( 'Just place the shortcode "[TESTIMONIALS]" in your page to list the Testimonials in a page ', 'luzuk Premium' ),
        )
    )
);

//TESTIMONIALS PAGES
for( $i = 1; $i < 8; $i++ ){
    $wp_customize->add_setting(
        'luzuk_testimonials_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_testimonials_heading'.$i,
            array(
                'settings'      => 'luzuk_testimonials_heading'.$i,
                'section'       => 'testimonials_area',
                'label'         => __( 'Testimonial ', 'luzuk Premium' ).$i,
            )
        )
    );
    $wp_customize->add_setting(
        'testimonials_page'.$i,
        array(
            'sanitize_callback' => 'absint'
        )
    );
    $wp_customize->add_control(
        'testimonials_page'.$i,
        array(
            'settings'      => 'testimonials_page'.$i,
            'section'       => 'testimonials_area',
            'type'=> 'select',
            'label'         => __( 'Select A Client Testimonial', 'luzuk Premium' ),
            'choices' => $TesimonialsSingleChoice,
        )
    );
}


lzCustomLable($wp_customize, 'clientcolor', 'testimonials_area', 'Section Color');

addColorPalatOption($wp_customize, 'tes_secimgactbrdclr', 'testimonials_area', 'Active Image Border Color', '#FDA12B');

addColorPalatOption($wp_customize, 'tes_secicnclr', 'testimonials_area', 'Diamond Icon Color', '#FDA12B');

addColorPalatOption($wp_customize, 'tes_secicnbrdclr', 'testimonials_area', 'Diamond Icon Border Color', '#FDA12B');

addColorPalatOption($wp_customize, 'tes_sectextclr', 'testimonials_area', ' Text Color', '#676767');

addColorPalatOption($wp_customize, 'tes_secNameclr', 'testimonials_area', 'Client Name Color', '#000000');

addColorPalatOption($wp_customize, 'tes_secdeginclr', 'testimonials_area', 'Client Designation Color', '#8A8A8A');

addColorPalatOption($wp_customize, 'tes_secslidebtnarrowbgclr', 'testimonials_area', 'Slider Button Arrow BG Color', '#f9f9f9');

addColorPalatOption($wp_customize, 'tes_secslidebtnbrdclr', 'testimonials_area', 'Slider Button Border Color', '#3E3024');

addColorPalatOption($wp_customize, 'tes_secslidebtnarrowclr', 'testimonials_area', 'Slider Button Arrow Color', '#3E3024');

addColorPalatOption($wp_customize, 'tes_secslidebtnarrowhvclr', 'testimonials_area', 'Slider Button Hover Arrow Color', '#FDA12B');

