<?php
/**
 *
 * @package Slider Premium
 */
?>
<?php $showContent = get_theme_mod('slider_section_show_content', 'on'); ?>
<div id="slider" class="slider_section">
    <div class="container-fluid">
        <div class="owl-slider">
            <div id="carousel" class="owl-carousel">
                <?php
                $args = array( 'post_type' => 'slider', 'orderby'   => 'id', 'order' => 'DESC',);
                if(!empty($pageId)){
                    $args['page_id'] = absint($pageId);

                }
                $text = '';
                $query = new WP_Query($args);
                if($query->have_posts()){
                    while($query->have_posts()) : $query->the_post(); 
                    

                    if( get_theme_mod('slider_areaOpacity',true) ) {
                        $slider_areaOpacity = 'opacity:'.esc_attr(get_theme_mod('slider_areaOpacity')).';';
                    }
                    if( get_theme_mod('slider_Tfontsize',true) ) {
                        $slider_Tfontsize = 'font-size:'.esc_attr(get_theme_mod('slider_Tfontsize')).';';
                    }

                    $pageLink = '';
                    $slider_btn_link = get_post_meta($post->ID,'slider_btn_link',false);
                    $sliderBtnTxt = get_post_meta($post->ID,'sliderBtnTxt',false);
                    if(!empty($slider_btn_link) && is_array($slider_btn_link)){
                        $pageLink = esc_url(get_permalink($slider_btn_link[0]));
                    }
                    if(!empty($sliderBtnTxt) && is_array($sliderBtnTxt)){
                        $pageLinkTxt = $sliderBtnTxt[0];
                    }else{
                        $pageLinkTxt = 'Start Free Trial'; 
                    }

                     $sliderSubtitle = get_post_meta($post->ID, 'sliderSubtitle', false);
                     $sliderdatetext = !empty($sliderSubtitle[0]) ? $sliderSubtitle[0] : '';

                    ?>
                <div class="item">
                    <div class="slider-area">
                        
                        <div class="sliderimg ">
                            <?php 
                                if(has_post_thumbnail()){
                                    $total_slider_image = wp_get_attachment_image_src(get_post_thumbnail_id(),'full');  
                                    echo '<img class="slide-mainimg" alt="'. esc_html(get_the_title()) .'" src="'.esc_url($total_slider_image[0]).'">';
                            }?>
                            <div class="slider-overlay"></div>
                        </div>
                        <?php if($showContent == 'on'){?>
                            <div class="slider_content animated " >
                                <?php 
                                    if(!empty($sliderdatetext)){ ?>
                                    <!-- <div class="subtitle-brd"></div> -->
                                    <div class="sub-title animated "><?php echo $sliderdatetext; ?></div>
                                 <?php }?>
                                <div class="title animated "><?php echo (get_the_title()); ?></div>
                                <div class="text animated "><?php echo (get_the_content()); ?></div>
                                <?php 
                                    if(!empty($pageLink)){ ?>
                                    <div class="slide-btna">
                                        <div class="btn5">  
                                            <a href="<?php echo $pageLink; ?>"> 
                                                <span><?php echo($pageLinkTxt); ?></span>
                                            </a>
                                        </div>
                                    </div>
                                <?php }?>
                            </div>
                        <?php }?>
                    </div>
                </div>
                        <?php
                    endwhile;
                }else{ 
                for($i=0;$i<6;$i++){?>
                <div class="item">
                    <div class="slider-area">
                        
                        <div class="sliderimg ">
                            <?php echo '<img class="slide-mainimg " alt="Slider" src="'. esc_html(get_template_directory_uri()) .'/images/slider.jpg">';?>
                            <div class="slider-overlay"></div>
                        </div>
                        <?php if($showContent == 'on'){?>
                            <div class="slider_content animated " >
                                <!-- <div class="subtitle-brd"></div> -->
                                <div class="sub-title animated ">Let's Get To Work</div>
                                <div class="title animated ">There Are Many Variations Of Available</div>
                                <div class="text animated ">There are many variations of passages of Lorem Ipsum available, but the majority have suffered believable.</div>
                                <div class="slide-btna ">
                                    <div class="btn5">
                                        <a href="#">
                                            <span><?php _e( 'Learn More', 'luzuk-premium' ); ?></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php }?>
                    </div>
                </div>
                <?php }
            }?>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {
          $('.slider_section .owl-carousel').owlCarousel({
            refreshClass: 'owl-refresh',
            autoplayTimeout:8000,
            loop: true,
            margin: 30,
            autoHeight: true,
            autoWidth: false,
            autoplay: true,
            animateOut: 'lightSpeedOut',
            // animateIn: 'zoomIn',
            // navText: [
            //         '<i class="fa fa-chevron-left"></i> ',
            //         '<i class="fa fa-chevron-right" ></i>'
            //     ],
            responsiveClass: true,

            responsive: {
              0: {
                items: 1,
                nav: true,
                margin: 40
              },
              600: {
                items:1,
                nav: true,
                margin: 50
              },
              1000: {
                items:1,
                nav: true,
                loop: true,
                margin: 100
              }
            }
          })
        })

</script>

<div class="clearfix"></div>
</div>