<?php 
/**
 * 
 * @package luzuk
 */

if(get_theme_mod('testimonials_area_disable') != 'on' ){ ?> 
  <?php 
    if( get_theme_mod('testimonials_areaTpadding',true) ) {
      $testimonials_areaTpadding = 'padding-top:'.esc_attr(get_theme_mod('testimonials_areaTpadding')).';';
    }
    if( get_theme_mod('testimonials_areaBpadding',true) ) {
      $testimonials_areaBpadding = 'padding-bottom:'.esc_attr(get_theme_mod('testimonials_areaBpadding')).';';
    }
  ?>  
 
<div id="testimonials"class="testimonials-area " >
    <?php   
        // width 
        $c_width = get_theme_mod('testi_c_width', 'container');

        if ($c_width === 'container') {
          $c_alignment = 'container';
        } elseif ($c_width === 'container-fluid') {
            $c_alignment = 'container-fluid';
        } else {
            $text_alignment = 'container'; // Default to 'container' if the setting is invalid
        }
         
        // Heading Style
        $heading_case = get_theme_mod('testi_maintitle_case', 'capitalize');

        if ($heading_case === 'uppercase') {
          $text_case = 'uppercase';
        } elseif ($heading_case === 'lowercase') {
            $text_case = 'lowercase';
        } elseif ($heading_case === 'capitalize') {
            $text_case = 'capitalize';
        } else {
            $text_case = 'capitalize'; // Default to 'left' if the setting is invalid
        }

      // Alientment
        $heading_alignment = get_theme_mod('testi_maintitle_align', 'left');

        if ($heading_alignment === 'left') {
        $text_alignment = 'left';
        } elseif ($heading_alignment === 'center') {
            $text_alignment = 'center';
        } elseif ($heading_alignment === 'right') {
            $text_alignment = 'right';
        } else {
            $text_alignment = 'left'; // Default to 'left' if the setting is invalid
        }
    ?>
    <?php
        $testi_title = get_theme_mod('testi_title', 'Reviews');
        $testi_subtitle = get_theme_mod('testi_subtitle', 'Happy Customer Thoughts');
      $testi_txt = get_theme_mod('testi_txt', 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or which do not look even slightly believable.');
    ?>
  
    <?php if( $testi_title || $testi_subtitle || $testi_txt ){ ?> 
    <div class="section-title">
        <div class="<?php echo esc_attr($c_width); ?>">
            <div class="row">
                <div class="col-lg-6">
                    <div class="titlebx">
                        <h3 style="text-align: <?php echo esc_attr($text_alignment); ?>; text-transform: <?php echo esc_attr($heading_case); ?>;"><?php echo ($testi_title); ?></h3>
                        <h5 style="text-align: <?php echo esc_attr($text_alignment); ?>;"><?php echo ($testi_subtitle); ?></h5>
                      <div class="titlebrd"></div>
                    </div>
                </div>
              <div class="col-lg-6">
                  <p>
                      <?php echo ($testi_txt); ?> 
                  </p>
                  <div class="clearfix"></div>
              </div>
            </div>
        </div>
    </div>
    <?php }?>


    <div class="<?php echo esc_attr($c_width); ?>">     
        <div class="tsoutbx">
          <div class="tsbx">
              <div class="cards">
                <?php  
                    $showStatic = true;
                    $cols = get_theme_mod('test_npp_count', 6);
                    $cols++;
                    switch($cols){
                      case 1:
                        $colCls = 'col-md-12 col-sm-12 col-xs-12';
                        break;
                      case 2:
                        $colCls = 'col-md-12 col-sm-12 col-xs-12';
                        break;
                      case 3:
                      case 5:
                      case 6:
                      case 7:
                      case 8:
                      case 9:
                      case 10:
                      case 11:
                      case 12:
                        $colCls = 'col-md-12 col-sm-12 col-xs-12';
                        break;
                      default:
                        $colCls = 'col-md-12 col-sm-12 col-xs-12';
                        break;
                    }
                    $icons = array(1=>'heart', 2=>'star', 3=>'flash', 4=>'bell',5=>'heart', 6=>'star', 7=>'flash', 8=>'bell'); 

                    for( $i = 1; $i <= $cols; $i++ ){
                      $testimonials_page_id = get_theme_mod('testimonials_page'.$i); 
                      $testimonials_page_icon = get_theme_mod('testimonials_page_icon'.$i);
                      if($testimonials_page_id){
                        $showStatic = false;
                        echo testimonialimgShortCode($testimonials_page_id, $isCustomizer=true, $i);
                    }
                  }

                  // adding the static content
                  if($showStatic === true){
                    for( $i = 1; $i <= $cols; $i++ ){ ?>
                  <div class="card" data-id="content<?php echo $i; ?>">
                      <img class="img-responsive" src="<?php echo get_template_directory_uri(); ?>/images/testi.jpg" alt="">
                            
                  </div> 
                  <?php }

                  }?>               
              </div> 
              <div class="icnbx">
                  <div class="icn">
                      <!-- <i class="fa fa-quote-right" ></i> -->
                      <svg xmlns="http://www.w3.org/2000/svg" width="12" height="17" viewBox="0 0 12 17">
                        <g id="Polygon_8" data-name="Polygon 8" fill="#fda12b">
                          <path d="M 6 16.13298034667969 L 0.61201411485672 8.5 L 6 0.8670200109481812 L 11.3879861831665 8.5 L 6 16.13298034667969 Z" stroke="none"/>
                          <path d="M 6 1.734054565429688 L 1.224038124084473 8.5 L 6 15.26594543457031 L 10.77596187591553 8.5 L 6 1.734054565429688 M 6 0 L 12 8.5 L 6 17 L 0 8.5 L 6 0 Z" stroke="none" fill="#fda12b"/>
                        </g>
                      </svg>
                  </div>
                  <div class="icnbrd"></div>
              </div>

              <div class="contentoutbx ">
                <?php  
                  $showStatic = true;
                  $cols = get_theme_mod('test_npp_count', 6);
                  $cols++;
                  switch($cols){
                    case 1:
                      $colCls = 'col-md-12 col-sm-12 col-xs-12';
                      break;
                    case 2:
                      $colCls = 'col-md-12 col-sm-12 col-xs-12';
                      break;
                    case 3:
                    case 5:
                    case 6:
                    case 7:
                    case 8:
                    case 9:
                    case 10:
                    case 11:
                    case 12:
                      $colCls = 'col-md-12 col-sm-12 col-xs-12';
                      break;
                    default:
                      $colCls = 'col-md-12 col-sm-12 col-xs-12';
                      break;
                  }
                  $icons = array(1=>'heart', 2=>'star', 3=>'flash', 4=>'bell',5=>'heart', 6=>'star', 7=>'flash', 8=>'bell'); 

                  for( $i = 1; $i <= $cols; $i++ ){
                    $testimonials_page_id = get_theme_mod('testimonials_page'.$i); 
                    $testimonials_page_icon = get_theme_mod('testimonials_page_icon'.$i);
                    if($testimonials_page_id){
                      $showStatic = false;
                      echo testimonialShortCode($testimonials_page_id, $isCustomizer=true, $i);
                  }
                }

                // adding the static content
                if($showStatic === true){
                  for( $i = 1; $i <= $cols; $i++ ){ ?>
                  <div class="contentBox " id="content<?php echo $i; ?>">
                      <div class="text">  
                          <p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don't even slightly believable.</p>
                          <div class="detailbx">
                              <h3 class="ts-area-title">Smith Enterprises</h3>
                              <div class="text-designation">Company Ceo</div>
                          </div>
                      </div>
                  </div>
                  <?php }

                  }?>
              </div>      
          </div>
          <div class="clearfix"></div>
          <div class="slidebtn">
            <button id="prevBtn" class="arrow prevBtn"><i class="fa fa-angle-left"></i></button>
            <button id="nextBtn" class="arrow nextBtn"><i class="fa fa-angle-right"></i></button>
          </div>
        </div>
    </div>
</div>

<script type="text/javascript">
let card = document.querySelectorAll("#testimonials .card");
let contentBox = document.querySelectorAll("#testimonials .contentBox");
let currentIndex = 0;

function showSlide(index) {
  // Reset all contentBox and card classes
  for (let i = 0; i < contentBox.length; i++) {
    contentBox[i].className = "contentBox , card";
    card[i].className = "card";
  }

  // Activate the correct contentBox and card based on index
  contentBox[index].className = "contentBox active";
  card[index].className = "card active";
}

function nextSlide() {
  currentIndex = (currentIndex + 1) % card.length;
  showSlide(currentIndex);
}

function prevSlide() {
  currentIndex = (currentIndex - 1 + card.length) % card.length;
  showSlide(currentIndex);
}

// Add event listeners to the arrow buttons
document.getElementById("nextBtn").addEventListener("click", nextSlide);
document.getElementById("prevBtn").addEventListener("click", prevSlide);

// Add event listeners to each card to handle image clicks
card.forEach((element, index) => {
  element.addEventListener("click", () => {
    currentIndex = index; // Update the current index based on the clicked image
    showSlide(currentIndex); // Show the corresponding slide
  });
});

// Auto-rotate every 5 seconds
let autoSlide = setInterval(nextSlide, 8000);

// Pause auto-rotation on hover
document.querySelectorAll(".card, .arrow").forEach(element => {
  element.addEventListener("mouseover", () => clearInterval(autoSlide));
  element.addEventListener("mouseout", () => {
    autoSlide = setInterval(nextSlide, 8000);
  });
});

// Initialize the first slide
showSlide(currentIndex);
</script>

<?php } 
