<?php    
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package luzuk Premium
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<script src="https://use.fontawesome.com/18a9c36ed1.js"></script>
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.min.css">
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/animate.css" />
	<link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,600;0,700;0,800;1,300;1,400;1,600;1,700;1,800&display=swap" rel="stylesheet">
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Exo+2:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
	<script src="https://code.jquery.com/jquery-3.1.1.min.js" integrity="sha384-3ceskX3iaEnIogmQchP8opvBy3Mi7Ce34nWjpBIwVTHfGYWQS9jwHDVRnpKKHJg7" crossorigin="anonymous"></script>
	

	<script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" crossorigin="anonymous"></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/bootstrap.min.js" type="text/javascript"  ></script>
	<script src="<?php echo get_template_directory_uri(); ?>/js/wow.js" ></script>

    <script src="<?php echo get_template_directory_uri(); ?>/js/jquery-3.1.1.slim.min.js" type="text/javascript"  ></script>
   <script src="<?php echo get_template_directory_uri(); ?>/js/swiper.min.js" type="text/javascript"  ></script>
	<script type="text/javascript" src="https://code.jquery.com/jquery-1.12.0.min.js"></script>
   	

	<?php wp_head(); ?>
</head>

  <?php if( get_theme_mod('bubbles_button_display','show' ) == 'show') :
        ?>
<style type="text/css">
.slider_section::after {
    content: '';
    pointer-events: none;
    opacity: .9;
    background: radial-gradient(circle at 20% 35%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 28% 40%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 75% 44%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 65% 40%, transparent 0, transparent 2px, #fff 5px, #fff 2px, transparent 4px), radial-gradient(circle at 46% 52%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 33% 44%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 65% 40%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 46% 52%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 25% 30%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 30% 32%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px);
    width: 100%;
    height: 300%;
    top: 0;
    left: 0;
    position: absolute;
    animation: bubbles 5s linear infinite both;
}

.slider_section a.btn::after {
    content: '';
    pointer-events: none;
    border: none;
    opacity: .9;
    background: radial-gradient(circle at 20% 35%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 75% 44%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 46% 52%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 33% 44%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 65% 40%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 30% 32%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px);
    width: 100%;
    height: 300%;
    top: 0;
    left: 0;
    position: absolute;
    animation: bubbles 4s linear infinite both;
}

#about .abt-btn a::after {
    content: '';
    pointer-events: none;
    opacity: .9;
    background: radial-gradient(circle at 20% 35%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 75% 44%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 46% 52%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 33% 44%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 65% 40%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 30% 32%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px);
    width: 100%;
    height: 300%;
    top: 0;
    left: 0;
    position: absolute;
    animation: bubbles 5s linear infinite both;
}
.service-area .service-icon::after {
    content: '';
    pointer-events: none;
    opacity: 0;
    background: radial-gradient(circle at 20% 35%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 75% 44%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 46% 52%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 33% 44%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 65% 40%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 30% 32%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px);
    width: 100%;
    height: 300%;
    top: 0;
    left: 0;
    position: absolute;
    animation: bubbles 5s linear infinite both;
}
#team .lhsteam-img::after {
    content: '';
    pointer-events: none;
    opacity: .9;
    background: radial-gradient(circle at 20% 35%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 75% 44%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 46% 52%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 33% 44%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 65% 40%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 30% 32%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px);
    width: 100%;
    height: 300%;
    top: 0;
    left: 0;
    position: absolute;
    animation: bubbles 5s linear infinite both;
}

#facility::after {
    content: '';
    pointer-events: none;
    opacity: .9;
    background: 
    radial-gradient(circle at 20% 35%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), 
    radial-gradient(circle at 75% 44%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), 
    radial-gradient(circle at 46% 52%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), 
    radial-gradient(circle at 33% 44%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), 
    radial-gradient(circle at 65% 40%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px),
    radial-gradient(circle at 20% 18%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px),
    radial-gradient(circle at 15% 20%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), 
    radial-gradient(circle at 30% 32%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px);
    width: 100%;
    height: 300%;
    top: 0;
    left: 0;
    position: absolute;
    animation: bubbles 5s linear infinite both;
}

.blog-area .blog-thumbnail::after {
    content: '';
    pointer-events: none;
    opacity: 0;
    background: radial-gradient(circle at 20% 35%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 75% 44%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 46% 52%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 33% 44%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 65% 40%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 30% 32%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px);
    width: 100%;
    height: 300%;
    top: 0;
    left: 0;
    transition: all 1s ease 0s;
    position: absolute;
    animation: bubbles 5s linear infinite both;
}
.blog-area .blogbtn a::after {
    content: '';
    pointer-events: none;
    opacity: .9;
    background: radial-gradient(circle at 20% 35%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 75% 44%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 46% 52%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 33% 44%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 65% 40%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 30% 32%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px);
    width: 100%;
    height: 300%;
    top: 0;
    left: 0;
    position: absolute;
    animation: bubbles 5s linear infinite both;
}

.page-main-header:after{
    content: '';
    pointer-events: none;
    opacity: .9;
    background: 
    radial-gradient(circle at 20% 35%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), 
    radial-gradient(circle at 75% 44%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), 
    radial-gradient(circle at 46% 52%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), 
    radial-gradient(circle at 33% 44%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), 
    radial-gradient(circle at 65% 40%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px),
    radial-gradient(circle at 20% 18%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px),
    radial-gradient(circle at 15% 20%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), 
    radial-gradient(circle at 30% 32%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px);
    width: 100%;
    height: 300%;
    top: 0;
    left: 0;
    position: absolute;
    animation: bubbles 5s linear infinite both;
}

.footer-area::after {
    content: '';
    pointer-events: none;
    opacity: .9;
    background: 
    radial-gradient(circle at 20% 35%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), 
    radial-gradient(circle at 75% 44%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), 
    radial-gradient(circle at 46% 52%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), 
    radial-gradient(circle at 33% 44%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), 
    radial-gradient(circle at 65% 40%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px),
    radial-gradient(circle at 20% 18%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px),
    radial-gradient(circle at 15% 20%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), 
    radial-gradient(circle at 30% 32%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px);
    width: 100%;
    height: 300%;
    top: 0;
    left: 0;
    position: absolute;
    animation: bubbles 5s linear infinite both;
}

.service-area .serbtn a::after {
    content: '';
    pointer-events: none;
    opacity: .9;
    background: radial-gradient(circle at 20% 35%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 75% 44%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 46% 52%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 33% 44%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 65% 40%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 30% 32%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px);
    width: 100%;
    height: 300%;
    top: 0;
    left: 0;
    position: absolute;
    animation: bubbles 5s linear infinite both;
}

#innerpage-box .serbtn a::after {
    content: '';
    pointer-events: none;
    opacity: .9;
    background: radial-gradient(circle at 20% 35%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 75% 44%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 46% 52%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 33% 44%, transparent 0, transparent 4px, #fff 5px, #fff 6px, transparent 6px), radial-gradient(circle at 65% 40%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px), radial-gradient(circle at 30% 32%, transparent 0, transparent 2px, #fff 3px, #fff 4px, transparent 4px);
    width: 100%;
    height: 300%;
    top: 0;
    left: 0;
    position: absolute;
    animation: bubbles 5s linear infinite both;
}
</style>

<?php endif ?> 

<body <?php body_class(); ?>>
	<div class="main-container">
		<!-- <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'InsideTours' ); ?></a> -->
		<div id="loading-area"><div class="la-anim-10"></div></div>
		<!-- header -->
		<!-- #masthead -->
		<header class="site-header header-transparent header header-seo">
			<div class="top-bar-head">
				<div class="container clearfix">
					<div class="header-left col-md-3 col-sm-3 col-xs-5 logo">
        				<?php 
        				
        					if( get_theme_mod('pages_logoTopsetmaxwidth',true) ) {
        						$pages_logoTopsetmaxwidth = 'max-width:'.esc_attr(get_theme_mod('pages_logoTopsetmaxwidth')).';';
        					}

        				?>
    					<!-- website logo -->
    					<div class="logo-header mostion">
    						<?php 
    						if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
    							the_custom_logo();
    					else : 
    						if ( is_front_page() ) : ?>
    							<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
    							<?php else : ?>
    								<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
    							<?php endif; ?>
    						<?php endif; ?>
    					</div> 
    					<p class="ht-site-description"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'description' ); ?></a></p>  
    					<!-- nav toggle button -->
    					<div class="resp_header_logo">
    						<?php 
    						if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) :
    							the_custom_logo();
    					else : 
    						if ( is_front_page() ) : ?>
    							<h1 class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
    							<?php else : ?>
    								<p class="ht-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
    							<?php endif; ?>
    							<!-- <p class="ht-site-description"><a href="<?php //echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php //bloginfo( 'description' ); ?></a></p> -->
    						<?php endif; ?>
    					</div>
    				</div>
    				<?php
    					$header_ph = get_theme_mod('header_ph', '+21 777 888 9999');
    					$facebook = get_theme_mod('header_fb', '//www.facebook.com/');
    					$instagram = get_theme_mod('header_insta', 'https://www.instagram.com/');
    					$twitter = get_theme_mod('header_tw', '//www.twitter.com/');
    					$linkedin = get_theme_mod('header_in', 'https://www.linkedin.com/');
    				?>
    				<div class="col-md-9 col-sm-9 col-xs-7 head-menu">
    					<div class="mobi">
        					<div class="htop">
        						<?php if( $header_ph){ ?>
        						<div class="hphone col-md-8 col-sm-7 ">
                                    <button type="button" class="btn share-icn"><i class="fa fa-phone" aria-hidden="true"></i> </button>
                                    <div class="share-btn headphone">
        							     <a href="tel:<?php echo $header_ph;?>"><i class="fa fa-phone-square" ></i><?php echo ($header_ph);  ?></a>
                                    </div>
        						</div>
        						<?php }?>
        						<div class="col-md-4 col-sm-5  pd-0 share-area">
                                    <button type="button" class="btn share-icn"><i class="fa fa-share-alt" aria-hidden="true"></i> </button>
        							<div class="share-btn">
        								<?php if(!empty($facebook || $instagram || $twitter || $linkedin)){ ?>

        									<?php if(!empty($facebook)){ ?>
        										<li><a href="<?php echo $facebook ?>" title="Facebook" target="_blank"><i class="fa fa-facebook"></i></a></li>
        									<?php }?>

        									<?php if(!empty($instagram)){ ?>
        										<li><a href="<?php echo $instagram ?>" title="Instagram"  target="_blank"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>
        									<?php }?>

        									<?php if(!empty($twitter)){ ?>
        										<li><a href="<?php echo $twitter ?>" title="Twitter" target="_blank"><i class="fa-brands fa-x-twitter"></i></a></li>
        									<?php }?>
        									<?php if(!empty($linkedin)){ ?>
        										<li><a href="<?php echo $linkedin ?>" title="linkedin" target="_blank"><i class="fa fa-linkedin" aria-hidden="true"></i></a></li>
        									<?php }?>
        									<div class="clearfix"></div>
        								<?php }?>
        							</div>
        						</div>
        					</div>
        				</div>
    					<div class="site-navigation ">
                            <div class="nav-menus">                 
                                <a class="js-nav-toggle">
                                    <span></span>
                                </a>
                                <div class="nav-wrapper">
                                    <nav role="navigation">
                                        <div class="nav-toggle">
                                                <span class="nav-back"></span>
                                                <span class="nav-title">Menu</span>
                                                <span class="nav-close"></span>
                                        </div>
                                        <?php
                                            if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
                                                wp_nav_menu ( array(
                                                    'menu_class' => 'mainm ht-clearfix',
                                                    'container'=> 'ul',
                                                    'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
                                                    'theme_location' => 'primary',  
                                                )); 
                                            } else {
                                                wp_nav_menu ( array(
                                                    'menu_class' => 'mainm ht-clearfix',
                                                    'container'=> 'ul',
                                                    'theme_location' => 'primary',  
                                                )); 
                                            }
                                        ?>
                                    </nav>
                                </div>
                            </div>
                            <nav class="navigation">
                                <div class="overlaybg"></div><!--  /.overlaybg -->
                                <!-- Main Menu -->
                                <div class="menu-wrapper">
                                    <div class="menu-content">
                                        <?php
                                            if( get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true) !=='0') {
                                                wp_nav_menu ( array(
                                                    'menu_class' => 'mainmenu ht-clearfix',
                                                    'container'=> 'ul',
                                                    'menu' => get_post_meta( get_the_ID(), 'intrinsic_header_page_menu', true),
                                                    'theme_location' => 'primary',  
                                                )); 
                                            } else {
                                                wp_nav_menu ( array(
                                                    'menu_class' => 'mainmenu ht-clearfix',
                                                    'container'=> 'ul',
                                                    'theme_location' => 'primary',  
                                                )); 
                                            }
                                        ?>
                                    </div> <!-- /.hours-content-->
    							<div class="clearfix"></div>
                                </div><!-- /.menu-wrapper --> 
                            </nav>
                            <div class="clearfix"></div>
                        </div><!--  /.site-navigation -->
    				</div>	  
    			    <div class="clearfix"></div>
    			</div>
    			<div class="clearfix"></div>
    		</div>			
    		<div class="clearfix"></div>
    	</header>
    </div>
<script type="text/javascript">
    $( document ).ready(function() {
     $( "header .share-icn" ).click(function(e) {
         $('header .share-btn').not($(this).next( "header .share-btn" )).each(function(){
            $(this).removeClass("active");
         });
     
            $(this).next( "header .share-btn" ).toggleClass( "active" );
    });   
});
</script>