<?php 
    $wp_customize->add_section(
        'about_area',
        array(
            'title' => __( 'About Us Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'about_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'about_area_disable',
            array(
                'settings'      => 'about_area_disable',
                'section'       => 'about_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'aboutus', 'about_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'aboutarea_padding', 'about_area', 'Set Section Padding');

$wp_customize->add_setting(
    'about_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaTpadding',
    array(
        'settings'      => 'about_areaTpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'about_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaBpadding',
    array(
        'settings'      => 'about_areaBpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'about_image_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_image_heading',
        array(
            'settings'      => 'about_image_heading',
            'section'       => 'about_area',
            'label'         => __( 'Section Right Side Image', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'about_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_image',
        array(
            'section' => 'about_area',
            'settings' => 'about_image',
            'description' => __('Recommended Image Size: 630X670px', 'luzuk-premium')
        )
    )
);


$wp_customize->add_setting(
    'about_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_title_heading',
        array(
            'settings'      => 'about_title_heading',
            'section'       => 'about_area',
            'label'         => __( ' Section Sub Heading & Heading', 'luzuk-premium' ),
        )
    )
);    

$wp_customize->add_setting(
    'aboutsubtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Fish Health', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'aboutsubtitle',
    array(
        'settings'      => 'aboutsubtitle',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Section Sub Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_secsbuheading', 'about_area', 'Section Sub Heading Color ', '#5c36a8');


$wp_customize->add_setting(
    'about_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'OUR AQUACULTURE PROGRAM', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_title',
    array(
        'settings'      => 'about_title',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_sectitle_color', 'about_area', 'Section Heading Color ', '#000');


$wp_customize->add_setting(
    'about_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '   We  have  programs  in  aquaculture  for  Corals, Clownfish, Bergia,  Orchid  Dottyback,  Cuttlefish, Blue   Assessor  and  several other fish/corals.We have the capability and experience to handle all aspects  of your next aquarium project - from the initial design  of your dream tank, to installation of equipment and aquatic life.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_text',
    array(
        'settings'      => 'about_text',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( 'Section Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_text', 'about_area', 'Section Text Color', '#939290');



$wp_customize->add_setting('aboutus_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'aboutus_npp_heading',
        array(
            'settings'      => 'aboutus_npp_heading',
            'section'       => 'about_area',
            'label'         => __( 'Number Of About Plans', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('aboutus_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 1));
$wp_customize->add_control(
    'aboutus_npp_count',
    array(
        'settings'      => 'aboutus_npp_count',
        'section'       => 'about_area',
        'type'          => 'select',
        'label'         => __( 'Number Of About Plan To Show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6)
    )
);

//ABOUT PAGES
for( $i = 1; $i <= 6; $i++ ){
    $wp_customize->add_setting(
        'aboutus_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'aboutus_header'.$i,
            array(
                'settings'      => 'aboutus_header'.$i,
                'section'       => 'about_area',
                'label'         => __( 'About Page ', 'luzuk-premium' ).$i
            )
        )
    );

//lzAddImageElement($wp_customize, 'aboutus_page_icon'.$i, 'about_area', $label="Recommended Image Size: 150X150px");

     $wp_customize->add_setting(
        'aboutus_page_icon'.$i,
        array(
            'default'           => 'fa fa-tint',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'aboutus_page_icon'.$i,
            array(
                'settings'      => 'aboutus_page_icon'.$i,
                'section'       => 'about_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );

lzAddElement($wp_customize, 'aboutus_page_title'.$i, 'about_area', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Health Services');

lzAddElement($wp_customize, 'aboutus_page_ttext'.$i, 'about_area', $type = 'textarea', $label="Text", $callback ='luzuk_sanitize_text', $default='We have the capability and experience to handle all aspects of your next aquarium project.');

}

lzCustomLable($wp_customize, 'Sec_abtclor', 'about_area' , 'Section Color');

addColorPalatOption($wp_customize, 'about_area_pagebxbg', 'about_area', 'Section Icon BG Color', '#5c36a8');

addColorPalatOption($wp_customize, 'about_area_pagebxbrd', 'about_area', 'Section Icon Border Color', '#fff');

addColorPalatOption($wp_customize, 'about_area_pagebxicn', 'about_area', 'Section Icon Color', '#fff');

addColorPalatOption($wp_customize, 'about_area_pagetitle', 'about_area', 'Section Icon Title Color', '#000');

addColorPalatOption($wp_customize, 'about_area_icntext', 'about_area', 'Section Icon Text Color', '#6a6a6a');


lzCustomLable($wp_customize, 'abtbtn', 'about_area' , 'Section Button');

$wp_customize->add_setting(
    'abtbtntxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Contact Us' )
    )
);
$wp_customize->add_control(
    'abtbtntxt',
    array(
        'settings'      => 'abtbtntxt',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Section Button Text', 'luzuk-premium' )
    )
);
$wp_customize->add_setting('abtbtnlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('abtbtnlink',
    array(
        'settings'      => 'abtbtnlink',
        'section'       => 'about_area',
        'type'          => 'url',
        'label'         => __( 'Add "Button" link here', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_btntext', 'about_area', 'Section Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'about_area_btntexthv', 'about_area', 'Section Button Text Hover Color', '#5c36a8');

addColorPalatOption($wp_customize, 'about_area_btnbg', 'about_area', 'Section Button BG Color', '#5c36a8');

addColorPalatOption($wp_customize, 'about_area_btnbghv', 'about_area', 'Section Button BG Hover Color', '#d5a8e9');

 