<?php 
    $wp_customize->add_section(
        'facility_area',
        array(
            'title' => __( 'Facility Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );

    $wp_customize->add_setting(
        'facility_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'facility_area_disable',
            array(
                'settings'      => 'facility_area_disable',
                'section'       => 'facility_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'facilityus', 'facility_area', $color='#fff', get_template_directory_uri().'/images/facilitybg.jpg', 'color');

lzCustomLable($wp_customize, 'facilityarea_opacity', 'facility_area', 'Section Opacity');

$wp_customize->add_setting(
    'facility_areaOpacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.4', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'facility_areaOpacity',
    array(
        'settings'      => 'facility_areaOpacity',
        'section'       => 'facility_area',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'facility_olyclr', 'facility_area', 'Section Overlay Color ', '#1e05c6');


lzCustomLable($wp_customize, 'facilityarea_padding', 'facility_area', 'Set Section Padding');

$wp_customize->add_setting(
    'facility_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '10em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'facility_areaTpadding',
    array(
        'settings'      => 'facility_areaTpadding',
        'section'       => 'facility_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'facility_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '16em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'facility_areaBpadding',
    array(
        'settings'      => 'facility_areaBpadding',
        'section'       => 'facility_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'facility_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'facility_title_heading',
        array(
            'settings'      => 'facility_title_heading',
            'section'       => 'facility_area',
            'label'         => __( 'Section Heading', 'luzuk-premium' ),
        )
    )
);    

$wp_customize->add_setting(
    'facility_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Facility We Provide', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'facility_heading',
    array(
        'settings'      => 'facility_heading',
        'section'       => 'facility_area',
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'facility_Heading_clr', 'facility_area', 'Section Heading Color ', '#fff');


$wp_customize->add_setting('facilityus_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'facilityus_npp_heading',
        array(
            'settings'      => 'facilityus_npp_heading',
            'section'       => 'facility_area',
            'label'         => __( 'Number Of Facility Plans', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('facilityus_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'facilityus_npp_count',
    array(
        'settings'      => 'facilityus_npp_count',
        'section'       => 'facility_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Facility Plan To Show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9)
    )
);

//facility PAGES
for( $i = 1; $i <= 9; $i++ ){
    $wp_customize->add_setting(
        'facilityus_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'facilityus_header'.$i,
            array(
                'settings'      => 'facilityus_header'.$i,
                'section'       => 'facility_area',
                'label'         => __( 'Facility Box ', 'luzuk-premium' ).$i
            )
        )
    );

     $wp_customize->add_setting(
        'facilityus_page_icon'.$i,
        array(
            'default'           => 'fa fa-heart-o',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'facilityus_page_icon'.$i,
            array(
                'settings'      => 'facilityus_page_icon'.$i,
                'section'       => 'facility_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );

lzAddElement($wp_customize, 'facilityus_page_title'.$i, 'facility_area', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Animal Care');

lzAddElement($wp_customize, 'facilityus_page_text'.$i, 'facility_area', $type = 'textarea', $label="Text", $callback ='luzuk_sanitize_text', $default='Many cities have run-down neighbourhoods and derelict land.');

lzAddElement($wp_customize, 'luzuk_facility_page_url_'.$i, 'facility_area', $type = 'text', $label="facility Page Link", $callback ='esc_url', $default='Add link here');

}

lzCustomLable($wp_customize, 'feasecbtn', 'facility_area' , 'Section Color');

addColorPalatOption($wp_customize, 'facility_area_pagebx', 'facility_area', 'Section Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'facility_area_pageicon', 'facility_area', 'Section Icon Color', '#fff');

addColorPalatOption($wp_customize, 'facility_area_icon1bg', 'facility_area', 'Section Icon Bg Color One', '#7f7fbf');

addColorPalatOption($wp_customize, 'facility_area_icon2bg', 'facility_area', 'Section Icon Bg Color Two', '#97a4df');

addColorPalatOption($wp_customize, 'facility_area_pagetitle', 'facility_area', 'Section Title Color', '#000');

addColorPalatOption($wp_customize, 'facility_textclr', 'facility_area', 'Section Text Color', '#9f9f9f');

addColorPalatOption($wp_customize, 'facility_slidarowbgclr', 'facility_area', 'Section Slider Arrow BG Color', '#fff');

addColorPalatOption($wp_customize, 'facility_slidarowbghvclr', 'facility_area', 'Section Slider Arrow BG Hover Color', '#d5a8e9');

addColorPalatOption($wp_customize, 'facility_slidarowclr', 'facility_area', 'Section Slider Arrow Color', '#5c36a8');