<?php 
 
$wp_customize->add_section(
	'gallery_section',
	array(
		'title'         => __( 'Gallery Section', 'Luzuk' ),
		'panel'   => 'luzuk_premium_home_panel',
	)
);
$wp_customize->add_setting(
	'gallery_section_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'gallery_section_disable',
		array(
			'settings'      => 'gallery_section_disable',
			'section'       => 'gallery_section',
			'label'         => __( 'Disable Section', 'Luzuk' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'Luzuk' ),
				'off' => __( 'No', 'Luzuk' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'gallery', 'gallery_section', $color='#c0c6d6');

lzCustomLable($wp_customize, 'luzuk_sec_gallerysectionpadding', 'gallery_section', 'Section Padding');

$wp_customize->add_setting(
    'secgalleryTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'lz-fitness-premium' )
    )
);
$wp_customize->add_control(
    'secgalleryTpadding',
    array(
        'settings'      => 'secgalleryTpadding',
        'section'       => 'gallery_section',
        'type'          => 'text',
        'label'         => __( 'Top ', 'lz-fitness-premium' )
    )
);
$wp_customize->add_setting(
    'secgalleryBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'lz-fitness-premium' )
    )
);
$wp_customize->add_control(
    'secgalleryBpadding',
    array(
        'settings'      => 'secgalleryBpadding',
        'section'       => 'gallery_section',
        'type'          => 'text',
        'label'         => __( 'Bottom ', 'lz-fitness-premium' )
    )
);


// ========= left Image ========
lzCustomLable($wp_customize, 'lhsgall_image_heading', 'gallery_section', 'Left Image');

$wp_customize->add_setting(
    'lhsgall_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'lhsgall_image',
        array(
            'section' => 'gallery_section',
            'settings' => 'lhsgall_image',
            'description' => __('Recommended Image Size: 400X500px', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting(
    'lhsimgtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Blue Gill Fish', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'lhsimgtitle',
    array(
        'settings'      => 'lhsimgtitle',
        'section'       => 'gallery_section',
        'type'          => 'text',
        'label'         => __( 'Section Left Image Title', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('lhsimgink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('lhsimgink',
    array(
        'settings'      => 'lhsimgink',
        'section'       => 'gallery_section',
        'type'          => 'url',
        'label'         => __( 'Add link here', 'luzuk-premium' )
    )
);



// ================= Right Image ======

lzCustomLable($wp_customize, 'rhsgall_image_heading', 'gallery_section', 'Middle Image');

$wp_customize->add_setting(
    'rhsgall_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'rhsgall_image',
        array(
            'section' => 'gallery_section',
            'settings' => 'rhsgall_image',
            'description' => __('Recommended Image Size: 330X500px', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting(
    'rhsimgtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Popular Fish', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'rhsimgtitle',
    array(
        'settings'      => 'rhsimgtitle',
        'section'       => 'gallery_section',
        'type'          => 'text',
        'label'         => __( 'Section Middle Image Title', 'luzuk-premium' )
    )
);


$wp_customize->add_setting('luzuk_gallery_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'luzuk_gallery_npp_heading',
		array(
			'settings'      => 'luzuk_gallery_npp_heading',
			'section'       => 'gallery_section',
			'label'         => __( 'Number Of Gallery Images', 'luzuk' ),
		)
	)
);    

$wp_customize->add_setting('gallery_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 5));
$wp_customize->add_control(
	'gallery_npp_count',
	array(
		'settings'      => 'gallery_npp_count',
		'section'       => 'gallery_section',
		'type'          => 'select',
		'label'         => __( 'Number Of Gallery Images', 'luzuk' ),
		'choices'=>array(1,2,3,4)
	)
);
$wp_customize->add_setting('gallery_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Info_Text( 
		$wp_customize,
		'gallery_section_lbl',
		array(
			'settings'		=> 'gallery_section_lbl',
			'section'		=> 'gallery_section',
			'label'			=> __( 'Note:', 'Luzuk' ),	
			'description'	=> __( 'Use Gallery Images Of Equal Height.{600px*600px}', 'Luzuk' ),
		)
	)
);

$luzukGallerySingleChoice[] = 'Select';

for( $i = 1; $i <= 4; $i++ ){
	$wp_customize->add_setting(
		'rg_gallery_heading'.$i,
		array(
			'sanitize_callback' => 'luzuk_sanitize_text'
		)
	);
	$wp_customize->add_control(
		new luzuk_Customize_Heading(
			$wp_customize,
			'rg_gallery_heading'.$i,
			array(
				'settings'      => 'rg_gallery_heading'.$i,
				'section'       => 'gallery_section',
				'label'         => __( 'Gallery Image ', 'Luzuk' ).$i, 
			)
		)
	);
	if(is_array($luzukGallerySingleChoice)){
		$wp_customize->add_setting(
			'gallery_page'.$i,
			array(
				'sanitize_callback' => 'absint'
			)
		);
		$wp_customize->add_control(
			'gallery_page'.$i,
			array(
				'settings'      => 'gallery_page'.$i,
				'section'       => 'gallery_section',
				'type'=> 'select',
				'label'         => __( 'Select A Gallery Image', 'Luzuk' ),
				'choices' => $luzukGallerySingleChoice,
			)
		);
	}else{
		$wp_customize->add_setting('gallery_section_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
		$wp_customize->add_control(
			new luzuk_Info_Text( 
				$wp_customize,
				'gallery_section_lbl'.$i,
				array(
					'settings'		=> 'gallery_section_lbl'.$i,
					'section'		=> 'gallery_section',
					'label'			=> __( 'Note:', 'Luzuk' ),	
					'description'	=> __( '<strong>Changes will not reflect unless you select the gallery Image.</strong> <br/>Please add the gallery images from "Gallery menu" and then select gallery Image to show.', 'Luzuk' ),
				)
			)
		);
	}
}


lzCustomLable($wp_customize, 'luzuk_sec_galleryclr', 'gallery_section', 'Section Color');

addColorPalatOption($wp_customize, 'gall_secimgolyclr', 'gallery_section', 'Section Image Color ', '#000');

addColorPalatOption($wp_customize, 'gall_secimgtitleclr', 'gallery_section', 'Section Image Title Color ', '#fff');

addColorPalatOption($wp_customize, 'gall_secicnbgicnclr', 'gallery_section', 'Section Image Hover Icon Color ', '#fff');

addColorPalatOption($wp_customize, 'gall_secicnbgicnbgclr', 'gallery_section', 'Section Image Hover Icon BG Color ', '#5c36a8');
