<?php 
$wp_customize->add_section(
    'service_area',
    array(
        'title'         => __( 'Services Section', 'luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
$wp_customize->add_setting(
    'service_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'service_area_disable',
        array(
            'settings'      => 'service_area_disable',
            'section'       => 'service_area',
            'label'         => __( 'Disable Section', 'luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk' ),
                'off' => __( 'No', 'luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'service', 'service_area', $color='#fff', get_template_directory_uri().'/images/serbg.jpg', 'color');

lzCustomLable($wp_customize, 'luzuk_sec_servicesolyclr', 'service_area', 'Section Overlay & Opacity');

$wp_customize->add_setting(
    'service_areaOpacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.5', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaOpacity',
    array(
        'settings'      => 'service_areaOpacity',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Section Top Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'services_tpolyClr', 'service_area', 'Section Top Overlay Color ', '#000');
addColorPalatOption($wp_customize, 'services_bmolyClr', 'service_area', 'Section Bottom Overlay Color ', '#fff');

lzCustomLable($wp_customize, 'luzuk_sec_servicessectionpadding', 'service_area', 'Set Section Padding');

$wp_customize->add_setting(
    'service_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '7em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaTpadding',
    array(
        'settings'      => 'service_areaTpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'service_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaBpadding',
    array(
        'settings'      => 'service_areaBpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'services_maintitle_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'services_maintitle_subtitle_heading',
        array(
            'settings'      => 'services_maintitle_subtitle_heading',
            'section'       => 'service_area',
            'label'         => __( 'Section Heading', 'luzuk' ),
        )
    )
);

$wp_customize->add_setting(
    'services_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our Service', 'luzuk' )
    )
);
$wp_customize->add_control(
    'services_maintitle',
    array(
        'settings'      => 'services_maintitle',
        'section'       => 'service_area', 
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'servicearea_sectitle_color', 'service_area', 'Section Heading Color ', '#fff');

$wp_customize->add_setting('service_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'service_area_lbl2',
        array(
            'settings'      => 'service_area_lbl2',
            'section'       => 'service_area',
            'label'         => __( 'Note2:', 'luzuk' ),  
            'description'   => __( 'Use Shortcode [SERVICES] to show all services in a page', 'luzuk' ),
        )
    )
);


$wp_customize->add_setting('service_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'service_npp_heading',
        array(
            'settings'      => 'service_npp_heading',
            'section'       => 'service_area',
            'label'         => __( 'Number Of Services To Show', 'luzuk' ),
        )
    )
);    
$wp_customize->add_setting('service_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 2));
$wp_customize->add_control(
    'service_npp_count',
    array(
        'settings'      => 'service_npp_count',
        'section'       => 'service_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Services To Show', 'luzuk' ),
        'choices'=>array(1,2,3,4,5,6,7,8)
    )
);

$ServicesSingleChoice[] = 'Select';

for( $i = 1; $i <= 8; $i++ ){
    $wp_customize->add_setting(
        'services_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'services_heading'.$i,
            array(
                'settings'      => 'services_heading'.$i,
                'section'       => 'service_area',
                'label'         => __( 'Service ', 'luzuk' ).$i,
            )
        )
    );
    if(is_array($ServicesSingleChoice)){
        $wp_customize->add_setting(
            'services_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'services_page'.$i,
            array(
                'settings'      => 'services_page'.$i,
                'section'       => 'service_area',
                'type'=> 'select',
                'label'         => __( 'Select A Service Box ', 'luzuk' ),
                'choices' => $ServicesSingleChoice,
            )
        );

// $wp_customize->add_setting(
//         'services_page_icon1'.$i,
//         array(
//             'default'           => 'fa fa-desktop',
//             'sanitize_callback' => 'luzuk_sanitize_text'
//         )
//     );        
//     $wp_customize->add_control(
//         new luzuk_Fontawesome_Icon_Chooser(
//             $wp_customize,
//             'services_page_icon1'.$i,
//             array(
//                 'settings'      => 'services_page_icon1'.$i,
//                 'section'       => 'service_area',
//                 'type'          => 'icon',
//                 'label'         => __( 'FontAwesome Icon', 'luzuk' ),
//             )
//         )
//     );



    }else{
        $wp_customize->add_setting('service_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'service_area_lbl'.$i,
                array(
                    'settings'      => 'service_area_lbl'.$i,
                    'section'       => 'service_area',
                    'label'         => __( 'Note:', 'luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the Service Page.</strong> <br/>Please add the Services from "Services menu" and then select Services to show information.', 'luzuk' ),
                )
            )
        );
    }
 
}

lzCustomLable($wp_customize, 'luzuk_sec_servicesclr', 'service_area', 'Section Color');

//addColorPalatOption($wp_customize, 'servicearea_boxbg_color', 'service_area', 'Section Box BG Color ', '#fff');

addColorPalatOption($wp_customize, 'services_imghoverColor', 'service_area', 'Section Image Hover Wave Color ', '#5c35a8');

addColorPalatOption($wp_customize, 'services_ServicePageTitleColor', 'service_area', 'Section Title Color ', '#000');

addColorPalatOption($wp_customize, 'services_SubttlColor', 'service_area', 'Section Text Color ', '#929091');

lzCustomLable($wp_customize, 'luzuk_secser_sbtnclr', 'service_area', 'Section Button Setting');

$wp_customize->add_setting(
    'ser_button1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Learn More', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'ser_button1',
    array(
        'settings'      => 'ser_button1',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'services_btnarowclr', 'service_area', 'Section Button Text Color ', '#fff');

addColorPalatOption($wp_customize, 'services_btnarowhvclr', 'service_area', 'Section Button Text Hover Color ', '#5c35a8');

addColorPalatOption($wp_customize, 'services_btnarowbgclr', 'service_area', 'Section Button BG Color ', '#5c35a8');

addColorPalatOption($wp_customize, 'services_btnarowbghvclr', 'service_area', 'Section Button BG Hover Color ', '#d5a8e9');