<?php  

$luzukSliderSingleChoice = getFitnessPostsType('slider');
$wp_customize->add_section(
	'slider_section',
	array(
		'title' => __( 'Slider Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel',
		'priority' =>18
	)
);
$wp_customize->add_setting(
	'slider_section_show_content',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'slider_section_show_content',
		array(
			'settings'      => 'slider_section_show_content',
			'section'       => 'slider_section',
			'label'         => __( 'Hide Title and description on Slider', 'Luzuk' ),
			'on_off_label'  => array(
				'on' => __( 'No', 'Luzuk' ),
				'off' => __( 'Yes', 'Luzuk' )
			),
		)
	)
);
$wp_customize->add_setting('slider_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Info_Text( 
		$wp_customize,
		'slider_section_lbl',
		array(
			'settings'		=> 'slider_section_lbl',
			'section'		=> 'slider_section',
			'label'			=> __( 'Note:', 'Luzuk' ),	
			'description'	=> __( 'The page featured image works as a banner and the title & content work as a slider caption. You can add this from the Slider menu. <br/> Recommended Image Size: 1500X650', 'Luzuk' ),
		)
	)
);


lzCustomLable($wp_customize, 'slidersarea_Overlay', 'slider_section', 'Wave Setting');

$wp_customize->add_setting(
    'slider_areaOpacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.5', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'slider_areaOpacity',
    array(
        'settings'      => 'slider_areaOpacity',
        'section'       => 'slider_section',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'slider_bg_color', 'slider_section', 'Slider Wave Color', '#5c36a8');
addColorPalatOption($wp_customize, 'slider_bgbrd_clr', 'slider_section', 'Slider Wave Border Color', '#747373');

lzCustomLable($wp_customize, 'luzuk_sliderotherclrs', 'slider_section', 'Slider Colors');


addColorPalatOption($wp_customize, 'slider_titleColor', 'slider_section', 'Slider Title Color', '#fff');

addColorPalatOption($wp_customize, 'slider_SubtitleColor', 'slider_section', 'Slider Text Color', '#fff');

// ======================btn one=========================================
lzCustomLable($wp_customize, 'luzuk_sliderbtn1clrs', 'slider_section', 'Slider Button First');

addColorPalatOption($wp_customize, 'slider_1btnclr', 'slider_section', 'Slider Button One BG Color', '#fff');

addColorPalatOption($wp_customize, 'slider_1btnhvclr', 'slider_section', 'Slider Button One BG Hover Color', '#5c36a8');

addColorPalatOption($wp_customize, 'slider_1btntxtclr', 'slider_section', 'Slider Button One Text Color', '#5c36a8');

addColorPalatOption($wp_customize, 'slider_1btntxthvclr', 'slider_section', 'Slider Button One Text & icon Hover Color', '#fff');

// ======================btn second=========================================
lzCustomLable($wp_customize, 'luzuk_sliderbtn2nd', 'slider_section', 'Slider Button Second');

addColorPalatOption($wp_customize, 'slider_2brdclr', 'slider_section', 'Slider Second Button BG Color', '#d5a8e9');

addColorPalatOption($wp_customize, 'slider_2btnhvclr', 'slider_section', 'Slider Second Button BG Hover Color', '#5c36a8');

addColorPalatOption($wp_customize, 'slider_2btnTxtclr', 'slider_section', 'Slider Second Button Text Color', '#5c36a8');

addColorPalatOption($wp_customize, 'slider_2btnTxthvclr', 'slider_section', 'Slider Second Button Text Hover Color', '#d5a8e9');

lzCustomLable($wp_customize, 'luzuk_sliderArrowbtn', 'slider_section', 'Slider Arrow Button ');

addColorPalatOption($wp_customize, 'slider_slidebtnicnclr', 'slider_section', 'Sliding Button Icon Color', '#5c36a8');

addColorPalatOption($wp_customize, 'slider_slidebtnicnhvclr', 'slider_section', 'Sliding Button Icon Hover Color', '#fff');

addColorPalatOption($wp_customize, 'slider_slidebtnbgclr', 'slider_section', 'Sliding Button BG Color', '#9a94b8');

addColorPalatOption($wp_customize, 'slider_slidebtnbghvclr', 'slider_section', 'Sliding Button BG Hover Color', '#d5a8e9');