<?php  
// TESTIMONIALS SECTION START HERE 

$wp_customize->add_section(
    'testimonials_area',
    array(
        'title'         => __( 'Testimonial Section', 'luzuk Premium' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
    //ENABLE/DISABLE TESTIMONIALS SECTION
$wp_customize->add_setting(
    'testimonials_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'testimonials_area_disable',
        array(
            'settings'      => 'testimonials_area_disable',
            'section'       => 'testimonials_area',
            'label'         => __( 'Disable Section', 'luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk Premium' ),
                'off' => __( 'No', 'luzuk Premium' )
            )   
        ) 
    )
);
 
backgroundManager($wp_customize, 'testimonials', 'testimonials_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'luzuk_sec_testsectionpadding', 'testimonials_area', 'Section Padding ');

$wp_customize->add_setting(
    'testimonials_areaTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaTpadding',
    array(
        'settings'      => 'testimonials_areaTpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk Premium' )
    )
);
$wp_customize->add_setting(
    'testimonials_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaBpadding',
    array(
        'settings'      => 'testimonials_areaBpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk Premium' )
    )
);

lzCustomLable($wp_customize, 'luzuk_sec_ImageBox', 'testimonials_area', 'Section Image Box Overlay ');

backgroundManager($wp_customize, 'testbox', 'testimonials_area', $color='#fff', get_template_directory_uri().'/images/testimonial.jpg', 'color');

$wp_customize->add_setting(
    'testimon_ImageBox',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.2', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'testimon_ImageBox',
    array(
        'settings'      => 'testimon_ImageBox',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'testi_fullolyclr', 'testimonials_area', ' Section Image Box Overlay Color', '#fff');

lzCustomLable($wp_customize, 'luzuk_sec_testlhsoly', 'testimonials_area', 'Section Left Side Overlay ');

$wp_customize->add_setting(
    'testimon_areaOpacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.2', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'testimon_areaOpacity',
    array(
        'settings'      => 'testimon_areaOpacity',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'testi_olyclr', 'testimonials_area', ' Section Left Box Overlay Color', '#000');

$TesimonialsSingleChoice[] = 'select';
if(!is_array($TesimonialsSingleChoice)){
    $wp_customize->add_setting('testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
    $wp_customize->add_control(
        new luzuk_Info_Text( 
            $wp_customize,
            'testimonials_area_lbl',
            array(
                'settings'      => 'testimonials_area_lbl',
                'section'       => 'testimonials_area',
                'label'         => __( 'Note:', 'luzuk Premium' ), 
                'description'   => __( '<strong>Changes will not reflect unless you select the Testimonials.</strong> <br/>Please add the Testimonials from "Testimonials menu" and then select Testimonial to show information.', 'luzuk Premium' ),
            )
        )
    );
}
$wp_customize->add_setting('luzuk_premium_testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_testimonials_area_lbl',
        array(
            'settings'      => 'luzuk_premium_testimonials_area_lbl',
            'section'       => 'testimonials_area',
            'label'         => __( 'Note:', 'luzuk Premium' ), 
            'description'   => __( 'Just place the shortcode "[TESTIMONIALS]" in your page to list the Testimonials in a page ', 'luzuk Premium' ),
        )
    )
);
//TESTIMONIALS PAGES
for( $i = 1; $i < 10; $i++ ){
    $wp_customize->add_setting(
        'luzuk_testimonials_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_testimonials_heading'.$i,
            array(
                'settings'      => 'luzuk_testimonials_heading'.$i,
                'section'       => 'testimonials_area',
                'label'         => __( 'Testimonial ', 'luzuk Premium' ).$i,
            )
        )
    );
    $wp_customize->add_setting(
        'testimonials_page'.$i,
        array(
            'sanitize_callback' => 'absint'
        )
    );
    $wp_customize->add_control(
        'testimonials_page'.$i,
        array(
            'settings'      => 'testimonials_page'.$i,
            'section'       => 'testimonials_area',
            'type'=> 'select',
            'label'         => __( 'Select A Client Testimonial', 'luzuk Premium' ),
            'choices' => $TesimonialsSingleChoice,
        )
    );
}


lzCustomLable($wp_customize, 'clientcolor', 'testimonials_area', 'Section Colors');

addColorPalatOption($wp_customize, 'luzuk_testimonials_imgbrdclr', 'testimonials_area', 'Section Image Border Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_testimonials_Namecolor', 'testimonials_area', 'Section Client Name Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_testimonials_deginclr', 'testimonials_area', 'Section Client Designation Color', '#e6e6e6');

addColorPalatOption($wp_customize, 'luzuk_testimonialscontent_textcolor', 'testimonials_area', ' Section Text Color', '#e9eaee');

addColorPalatOption($wp_customize, 'luzuk_testimonials_dicnclr', 'testimonials_area', 'Section Box Icon Color', '#e5e5e3');

addColorPalatOption($wp_customize, 'luzuk_testimonials_slidedotclr', 'testimonials_area', 'Section Slider Dot Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_testimonials_slideactdotclr', 'testimonials_area', 'Section Slider Active Dot Color', '#b9a8b0');

// ===========Form Section ==========//

lzCustomLable($wp_customize, 'test_info', 'testimonials_area', 'Form Section');

lzCustomLable($wp_customize, 'sec_testimonialhead', 'testimonials_area', 'Form Heading ');

$wp_customize->add_setting(
    'testi_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Get In Touch', 'luzuk' )
    )
);
$wp_customize->add_control(
    'testi_maintitle',
    array(
        'settings'      => 'testi_maintitle',
        'section'       => 'testimonials_area', 
        'type'          => 'text',
        'label'         => __( 'Form Heading', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'testi_headingclr', 'testimonials_area', ' Form Heading Color', '#fff');

lzAddElement($wp_customize, 'luzuk_testfm_shortcode', 'testimonials_area', 'textarea', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');

addColorPalatOption($wp_customize, 'testi_forminputbgClr', 'testimonials_area', 'Form Input BG Color', '#f0f0f045');

addColorPalatOption($wp_customize, 'testi_forminputbrdClr', 'testimonials_area', 'Form Input Border Color', '#fff');

addColorPalatOption($wp_customize, 'testi_forminputtextClr', 'testimonials_area', 'Form Input Text / Placeholder Color', '#fff');

addColorPalatOption($wp_customize, 'testi_formlabelColor', 'testimonials_area', 'Form Label Color', '#fff');

addColorPalatOption($wp_customize, 'testi_formbuttontextClr', 'testimonials_area', 'Form Button Text Color', '#5c36a8');

addColorPalatOption($wp_customize, 'testi_formbuttontexthvClr', 'testimonials_area', 'Form Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'testi_formbuttonbgClr', 'testimonials_area', 'Form Button BG Color', '#fff');

addColorPalatOption($wp_customize, 'testi_formbuttonbghvClr', 'testimonials_area', 'Form Button BG Hover Color', '#5c36a8');