<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package luzuk Premium
 */

$luzuk_lite_single_breadcrumb_section = get_theme_mod('luzuk_lite_single_breadcrumb_section', '1');
$luzuk_lite_single_tags_section = get_theme_mod('luzuk_lite_single_tags_section', '1');
$luzuk_lite_authorbox_section = get_theme_mod('luzuk_lite_authorbox_section', '1');
$luzuk_lite_relatedposts_section = get_theme_mod('luzuk_lite_relatedposts_section', '1');

get_header(); ?> 
 <?php $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));?>
<header class="page-main-header"  <?php  if (!empty($image)) : ?>
             style="background: url('<?php echo esc_url($image); ?>'); background-repeat: no-repeat; background-size:cover; position: relative;"
              <?php endif ?>>
    <!-- <div class="overlay1"></div> -->
    <div class="container">
        <?php the_title( '<h1 class="ht-main-title ">', '</h1>' ); ?>
        <div class="clearfix"></div>
    </div>
     <?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'show') :
        ?>
        <div class="breadcrumbbox ">
            <div class="container">
                <div class='button'><?php luzuk_lite_the_breadcrumb(); ?></div>
                <!--  <?php //luzuk_lite_the_breadcrumb(); ?> -->
            </div>
        </div>
    <?php endif ?>  
    <div class="innheader">
        <svg class="innh-waves" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 24 150 28" preserveAspectRatio="none" shape-rendering="auto">
            <defs>
                <path id="gentle-wave" d="M-160 65c30 0 58-18 88-18s 58 18 88 18 58-18 88-18 58 18 88 18 v44h-352z" />
            </defs>
            <g class="parallax">
           <!-- <use xlink:href="#gentle-wave" class="wave3" x="48" y="0" fill="#d33" /> -->
                <use xlink:href="#gentle-wave" class="wave8" x="48" y="3" />
                <!-- <use xlink:href="#gentle-wave" class="wave4" x="48" y="5" fill="#000" /> -->
                <use xlink:href="#gentle-wave" class="wave9" x="48" y="6" />
            </g>
        </svg>
    </div> 
    <div class="clearfix"></div>
</header><!-- .entry-header --> 
<main id="innerpage-box">
    <div class="container">
        <div class="inner_contentbox">
            <div id="content-box" class="innerpage-whitebox">
                <div class="col-md-8 col-sm-7">
                    <article class="article">       
                        <?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
                        <div id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>>
                            <div class="single_post">
                              
                               <!-- Start Content -->
                               <div id="content" class="post-single-content box mark-links">
                                <?php the_content(); ?>
                            </div><!-- End Content -->
                            
                                <?php comments_template( '', true ); ?>
                            </div>
                        </div>
                    <?php endwhile; ?>
                    </article>
                </div>
                <div class="col-md-4 col-sm-5">
                  <div id="secondary" class="widget-area">
                        <?php  dynamic_sidebar('luzuk-service-sidebar'); ?>                         
                    </div> 
                </div>
            <!-- Start Sidebar -->
            <?php // get_sidebar(); ?>
            <!-- End Sidebar -->
        </div>

        <div class="clearfix"></div>
    </div>
  <div class="clearfix"></div>
    </div>
</main>
<?php get_footer(); ?>